/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import java.util.Arrays;

public class DoubleExponentialSmoothingForLinearSeries {
    public static Model fit(double[] data, double alpha, double beta) {
        DoubleExponentialSmoothingForLinearSeries.validateParams(alpha, beta);
        double[] smoothedData = new double[data.length];
        double[] trends = new double[data.length + 1];
        double[] levels = new double[data.length + 1];
        smoothedData[0] = data[0];
        trends[0] = data[1] - data[0];
        levels[0] = data[0];
        for (int t = 0; t < data.length; ++t) {
            smoothedData[t] = trends[t] + levels[t];
            levels[t + 1] = alpha * data[t] + (1.0 - alpha) * (levels[t] + trends[t]);
            trends[t + 1] = beta * (levels[t + 1] - levels[t]) + (1.0 - beta) * trends[t];
        }
        return new Model(smoothedData, trends, levels, DoubleExponentialSmoothingForLinearSeries.calculateSSE(data, smoothedData));
    }

    private static double calculateSSE(double[] data, double[] smoothedData) {
        double sse = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sse += Math.pow(smoothedData[i] - data[i], 2.0);
        }
        return sse;
    }

    private static void validateParams(double alpha, double beta) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new RuntimeException("The value of alpha must be between 0 and 1");
        }
        if (beta < 0.0 || beta > 1.0) {
            throw new RuntimeException("The value of beta must be between 0 and 1");
        }
    }

    public static void main(String[] args) {
        double[] testData = new double[]{128.0, 135.0, 131.0, 205.0, 173.0, 184.0};
        Model model = DoubleExponentialSmoothingForLinearSeries.fit(testData, 0.8, 0.2);
        System.out.println("Input values: " + Arrays.toString(testData));
        System.out.println("Smoothed values: " + Arrays.toString(model.getSmoothedData()));
        System.out.println("Trend: " + Arrays.toString(model.getTrend()));
        System.out.println("Level: " + Arrays.toString(model.getLevel()));
        System.out.println("Sum of squared error: " + model.getSSE());
        System.out.println("Forecast: " + Arrays.toString(model.forecast(3)));
    }

    public static class Model {
        private final double[] smoothedData;
        private final double[] trends;
        private final double[] levels;
        private final double sse;

        public Model(double[] smoothedData, double[] trends, double[] levels, double sse) {
            this.smoothedData = smoothedData;
            this.trends = trends;
            this.levels = levels;
            this.sse = sse;
        }

        public double[] forecast(int size) {
            double[] forecastData = new double[size];
            for (int i = 0; i < size; ++i) {
                forecastData[i] = this.levels[this.levels.length - 1] + (double)(i + 1) * this.trends[this.trends.length - 1];
            }
            return forecastData;
        }

        public double[] getSmoothedData() {
            return this.smoothedData;
        }

        public double[] getTrend() {
            return this.trends;
        }

        public double[] getLevel() {
            return this.levels;
        }

        public double getSSE() {
            return this.sse;
        }
    }
}

