/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.BoundsEventListener;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.events.TileEventListener;
import eu.hansolo.tilesfx.tools.CtxBounds;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.InfoRegion;
import eu.hansolo.tilesfx.tools.LowerRightRegion;
import eu.hansolo.tilesfx.tools.NotifyRegion;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class TileSkin
extends SkinBase<Tile>
implements Skin<Tile> {
    protected static final double PREFERRED_WIDTH = 250.0;
    protected static final double PREFERRED_HEIGHT = 250.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 50.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    protected double width;
    protected double height;
    protected double size;
    protected double inset;
    protected double doubleInset;
    protected CtxBounds contentBounds;
    protected double contentCenterX;
    protected double contentCenterY;
    protected Pane pane;
    protected double minValue;
    protected double maxValue;
    protected double range;
    protected double threshold;
    protected double stepSize;
    protected double angleRange;
    protected double angleStep;
    protected boolean highlightSections;
    protected String formatString;
    protected DecimalFormat decimalFormat;
    protected String tickLabelFormatString;
    protected Locale locale;
    protected List<Section> sections;
    protected boolean sectionsVisible;
    protected Tile.TextSize textSize;
    protected DropShadow shadow;
    protected InvalidationListener sizeListener;
    protected TileEventListener tileEventListener;
    protected InvalidationListener currentValueListener;
    protected InvalidationListener timeListener;
    protected Tile tile;
    private ImageView backgroundImageView;
    private NotifyRegion notifyRegion;
    private InfoRegion infoRegion;
    private LowerRightRegion lowerRightRegion;
    private EventHandler<MouseEvent> infoRegionHandler;

    public TileSkin(Tile TILE) {
        super((Control)TILE);
        this.tile = TILE;
        this.minValue = this.tile.getMinValue();
        this.maxValue = this.tile.getMaxValue();
        this.range = this.tile.getRange();
        this.threshold = this.tile.getThreshold();
        this.stepSize = 250.0 / this.range;
        this.angleRange = this.tile.getAngleRange();
        this.angleStep = this.angleRange / this.range;
        this.formatString = "%." + this.tile.getDecimals() + "f";
        this.tickLabelFormatString = "%." + this.tile.getTickLabelDecimals() + "f";
        this.locale = this.tile.getLocale();
        this.sections = this.tile.getSections();
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.highlightSections = this.tile.isHighlightSections();
        this.textSize = this.tile.getTextSize();
        this.infoRegionHandler = this.tile.getInfoRegionHandler();
        this.sizeListener = o -> this.handleEvents("RESIZE");
        this.tileEventListener = e -> this.handleEvents(e.getEventType().name());
        this.currentValueListener = o -> this.handleCurrentValue(this.tile.getCurrentValue());
        this.contentBounds = new CtxBounds();
        this.decimalFormat = this.tile.getCustomDecimalFormat();
        this.initGraphics();
        this.registerListeners();
    }

    protected void initGraphics() {
        if (Double.compare(this.tile.getPrefWidth(), 0.0) <= 0 || Double.compare(this.tile.getPrefHeight(), 0.0) <= 0 || Double.compare(this.tile.getWidth(), 0.0) <= 0 || Double.compare(this.tile.getHeight(), 0.0) <= 0) {
            if (this.tile.getPrefWidth() > 0.0 && this.tile.getPrefHeight() > 0.0) {
                this.tile.setPrefSize(this.tile.getPrefWidth(), this.tile.getPrefHeight());
            } else {
                this.tile.setPrefSize(250.0, 250.0);
            }
        }
        this.shadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 3.0, 0.0, 0.0, 0.0);
        this.backgroundImageView = new ImageView();
        this.backgroundImageView.setPreserveRatio(true);
        this.backgroundImageView.setMouseTransparent(true);
        if (null == this.tile.getBackgroundImage()) {
            Helper.enableNode((Node)this.backgroundImageView, false);
        } else {
            this.backgroundImageView.setImage(this.tile.getBackgroundImage());
            Helper.enableNode((Node)this.backgroundImageView, true);
        }
        this.notifyRegion = new NotifyRegion();
        Helper.enableNode((Node)this.notifyRegion, false);
        this.infoRegion = new InfoRegion();
        this.infoRegion.setPickOnBounds(false);
        Helper.enableNode((Node)this.infoRegion, false);
        this.lowerRightRegion = new LowerRightRegion();
        Helper.enableNode((Node)this.lowerRightRegion, false);
        this.pane = new Pane(new Node[]{this.backgroundImageView, this.notifyRegion, this.infoRegion, this.lowerRightRegion});
        this.pane.getStyleClass().add((Object)"tile");
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getBorderColor(), BorderStrokeStyle.SOLID, new CornerRadii(6.25), new BorderWidths(this.tile.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.tile.getBackgroundColor(), new CornerRadii(6.25), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    protected void registerListeners() {
        this.tile.widthProperty().addListener(this.sizeListener);
        this.tile.heightProperty().addListener(this.sizeListener);
        this.tile.setOnTileEvent(this.tileEventListener);
        this.tile.currentValueProperty().addListener(this.currentValueListener);
        if (null != this.infoRegionHandler) {
            this.infoRegion.addEventHandler(MouseEvent.ANY, this.infoRegionHandler);
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected Pane getPane() {
        return this.pane;
    }

    protected void handleEvents(String EVENT_TYPE) {
        if (TileEvent.EventType.RESIZE.name().equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if (TileEvent.EventType.REDRAW.name().equals(EVENT_TYPE)) {
            this.redraw();
        } else if (TileEvent.EventType.RECALC.name().equals(EVENT_TYPE)) {
            this.minValue = this.tile.getMinValue();
            this.maxValue = this.tile.getMaxValue();
            this.range = this.tile.getRange();
            this.threshold = this.tile.getThreshold();
            this.stepSize = this.size / this.range;
            this.angleRange = Helper.clamp(90.0, 180.0, this.tile.getAngleRange());
            this.angleStep = this.angleRange / this.range;
            this.highlightSections = this.tile.isHighlightSections();
            this.redraw();
            this.handleCurrentValue(this.tile.getCurrentValue());
        } else if (TileEvent.EventType.SECTION.name().equals(EVENT_TYPE)) {
            this.sections = this.tile.getSections();
        } else if (TileEvent.EventType.SHOW_NOTIFY_REGION.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.notifyRegion, true);
        } else if (TileEvent.EventType.HIDE_NOTIFY_REGION.equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.notifyRegion, false);
        } else if (TileEvent.EventType.SHOW_INFO_REGION.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.infoRegion, true);
        } else if (TileEvent.EventType.HIDE_INFO_REGION.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.infoRegion, false);
        } else if (TileEvent.EventType.SHOW_LOWER_RIGHT_REGION.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.lowerRightRegion, true);
        } else if (TileEvent.EventType.HIDE_LOWER_RIGHT_REGION.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.lowerRightRegion, false);
        } else if (TileEvent.EventType.BACKGROUND_IMAGE.name().equals(EVENT_TYPE)) {
            if (null == this.tile.getBackgroundImage()) {
                Helper.enableNode((Node)this.backgroundImageView, false);
            } else {
                this.backgroundImageView.setImage(this.tile.getBackgroundImage());
                this.backgroundImageView.setFitWidth(this.width);
                this.backgroundImageView.setFitHeight(this.height);
                Helper.enableNode((Node)this.backgroundImageView, true);
            }
        } else if (TileEvent.EventType.REGIONS_ON_TOP.name().equals(EVENT_TYPE)) {
            this.notifyRegion.toFront();
            this.infoRegion.toFront();
        } else if (TileEvent.EventType.INFO_REGION_HANDLER.name().equals(EVENT_TYPE)) {
            if (null != this.infoRegionHandler) {
                this.infoRegion.removeEventHandler(MouseEvent.ANY, this.infoRegionHandler);
            }
            this.infoRegionHandler = this.tile.getInfoRegionHandler();
            if (null == this.infoRegionHandler) {
                return;
            }
            this.infoRegion.addEventHandler(MouseEvent.ANY, this.infoRegionHandler);
        }
    }

    protected void handleCurrentValue(double VALUE) {
    }

    public CtxBounds getContentBounds() {
        return this.contentBounds;
    }

    public void setOnContentBoundsChanged(BoundsEventListener LISTENER) {
        this.contentBounds.setOnBoundsEvent(LISTENER);
    }

    public void removeOnContentBoundsChanged(BoundsEventListener LISTENER) {
        this.contentBounds.removeBoundsEventListener(LISTENER);
    }

    public NotifyRegion getNotifyRegion() {
        return this.notifyRegion;
    }

    public InfoRegion getInfoRegion() {
        return this.infoRegion;
    }

    public LowerRightRegion getLowerRightRegion() {
        return this.lowerRightRegion;
    }

    public void dispose() {
        this.contentBounds.removeAllListeners();
        this.tile.widthProperty().removeListener(this.sizeListener);
        this.tile.heightProperty().removeListener(this.sizeListener);
        this.tile.removeTileEventListener(this.tileEventListener);
        this.tile.currentValueProperty().removeListener(this.currentValueListener);
        this.tile = null;
    }

    protected void resizeDynamicText() {
    }

    protected void resizeStaticText() {
    }

    protected void resize() {
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = Helper.clamp(0.0, Double.MAX_VALUE, this.width < this.height ? this.width : this.height);
        this.stepSize = this.width / this.range;
        this.shadow.setRadius(this.size * 0.012);
        this.inset = this.size * 0.05;
        this.doubleInset = this.inset * 2.0;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            double offsetTop = this.tile.getTitle().isEmpty() ? this.inset : this.size * 0.15;
            double offsetBottom = this.tile.getText().isEmpty() || !this.tile.isTextVisible() ? this.height - this.inset : this.height - this.size * 0.15;
            this.contentBounds.setX(this.inset);
            this.contentBounds.setY(offsetTop);
            this.contentBounds.setWidth(this.width - this.doubleInset);
            this.contentBounds.setHeight(offsetBottom - offsetTop);
            this.contentCenterX = this.contentBounds.getX() + this.contentBounds.getWidth() * 0.5;
            this.contentCenterY = this.contentBounds.getY() + this.contentBounds.getHeight() * 0.5;
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            if (this.backgroundImageView.isVisible()) {
                if (this.tile.getRoundedCorners()) {
                    Rectangle imgClip = new Rectangle(this.width, this.height);
                    imgClip.setArcWidth(Helper.clamp(0.0, Double.MAX_VALUE, this.inset));
                    imgClip.setArcHeight(Helper.clamp(0.0, Double.MAX_VALUE, this.inset));
                    this.backgroundImageView.setClip((Node)imgClip);
                }
                this.backgroundImageView.setFitWidth(this.width);
                this.backgroundImageView.setFitHeight(this.height);
                this.backgroundImageView.setPreserveRatio(this.tile.getBackgroundImageKeepAspect());
                this.backgroundImageView.relocate((this.width - this.backgroundImageView.getLayoutBounds().getWidth()) * 0.5, (this.height - this.backgroundImageView.getLayoutBounds().getHeight()) * 0.5);
            }
            double regionSize = this.size * 0.105;
            this.notifyRegion.setPrefSize(regionSize, regionSize);
            this.notifyRegion.relocate(this.width - regionSize, 0.0);
            this.infoRegion.setPrefSize(regionSize, regionSize);
            this.infoRegion.relocate(0.0, 0.0);
            this.lowerRightRegion.setPrefSize(regionSize, regionSize);
            this.lowerRightRegion.relocate(this.width - regionSize, this.height - regionSize);
            this.resizeStaticText();
            this.resizeDynamicText();
        }
    }

    protected void redraw() {
        boolean hasRoundedCorners = this.tile.getRoundedCorners();
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.tile.getBorderColor(), BorderStrokeStyle.SOLID, hasRoundedCorners ? new CornerRadii(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025)) : CornerRadii.EMPTY, new BorderWidths(Helper.clamp(0.0, Double.MAX_VALUE, this.tile.getBorderWidth() / 250.0 * this.size)))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.tile.getBackgroundColor(), hasRoundedCorners ? new CornerRadii(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025)) : CornerRadii.EMPTY, Insets.EMPTY)}));
        this.backgroundImageView.setOpacity(this.tile.getBackgroundImageOpacity());
        this.notifyRegion.setRoundedCorner(hasRoundedCorners);
        this.notifyRegion.setBackgroundColor(this.tile.getNotifyRegionBackgroundColor());
        this.notifyRegion.setForegroundColor(this.tile.getNotifyRegionForegroundColor());
        this.notifyRegion.setTooltipText(this.tile.getNotifyRegionTooltipText());
        this.infoRegion.setRoundedCorner(hasRoundedCorners);
        this.infoRegion.setBackgroundColor(this.tile.getInfoRegionBackgroundColor());
        this.infoRegion.setForegroundColor(this.tile.getInfoRegionForegroundColor());
        this.infoRegion.setTooltipText(this.tile.getInfoRegionTooltipText());
        this.lowerRightRegion.setRoundedCorner(hasRoundedCorners);
        this.lowerRightRegion.setBackgroundColor(this.tile.getLowerRightRegionBackgroundColor());
        this.lowerRightRegion.setForegroundColor(this.tile.getLowerRightRegionForegroundColor());
        this.lowerRightRegion.setTooltipText(this.tile.getLowerRightRegionTooltipText());
        this.locale = this.tile.getLocale();
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.decimalFormat = this.tile.getCustomDecimalFormat();
        } else {
            this.formatString = "%." + this.tile.getDecimals() + "f";
        }
        this.tickLabelFormatString = "%." + this.tile.getTickLabelDecimals() + "f";
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.textSize = this.tile.getTextSize();
    }
}

