/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Alarm;
import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TimeSection;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.RadarChartMode;
import eu.hansolo.tilesfx.chart.SunburstChart;
import eu.hansolo.tilesfx.chart.TilesFXSeries;
import eu.hansolo.tilesfx.colors.Bright;
import eu.hansolo.tilesfx.events.AlarmEventListener;
import eu.hansolo.tilesfx.events.TileEventListener;
import eu.hansolo.tilesfx.events.TimeEventListener;
import eu.hansolo.tilesfx.skins.BarChartItem;
import eu.hansolo.tilesfx.skins.LeaderBoardItem;
import eu.hansolo.tilesfx.tools.Country;
import eu.hansolo.tilesfx.tools.CountryGroup;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Location;
import eu.hansolo.tilesfx.tools.MatrixIcon;
import eu.hansolo.tilesfx.tools.Rank;
import eu.hansolo.tilesfx.tools.TreeNode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class TileBuilder<B extends TileBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected TileBuilder() {
    }

    public static final TileBuilder create() {
        return new TileBuilder();
    }

    public final B skinType(Tile.SkinType TYPE) {
        this.properties.put("skinType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B minValue(double VALUE) {
        this.properties.put("minValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B maxValue(double VALUE) {
        this.properties.put("maxValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B threshold(double VALUE) {
        this.properties.put("threshold", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B lowerThreshold(double VALUE) {
        this.properties.put("lowerThreshold", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B referenceValue(double VALUE) {
        this.properties.put("referenceValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B autoReferenceValue(boolean AUTO_REFERENCE_VALUE) {
        this.properties.put("autoReferenceValue", (Property)new SimpleBooleanProperty(AUTO_REFERENCE_VALUE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickLabelDecimals(int DECIMALS) {
        this.properties.put("tickLabelDecimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickLabelsXVisible(boolean VISIBLE) {
        this.properties.put("tickLabelsXVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B tickLabelsYVisible(boolean VISIBLE) {
        this.properties.put("tickLabelsYVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minValueVisible(boolean VISIBLE) {
        this.properties.put("minValueVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B maxValueVisible(boolean VISIBLE) {
        this.properties.put("maxValueVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B title(String TITLE) {
        this.properties.put("title", (Property)new SimpleStringProperty(TITLE));
        return (B)this;
    }

    public final B titleAlignment(TextAlignment ALIGNMENT) {
        this.properties.put("titleAlignment", (Property)new SimpleObjectProperty((Object)ALIGNMENT));
        return (B)this;
    }

    public final B description(String DESCRIPTION) {
        this.properties.put("description", (Property)new SimpleStringProperty(DESCRIPTION));
        return (B)this;
    }

    public final B descriptionAlignment(Pos ALIGNMENT) {
        this.properties.put("descriptionAlignment", (Property)new SimpleObjectProperty((Object)ALIGNMENT));
        return (B)this;
    }

    public final B unit(String UNIT) {
        this.properties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return (B)this;
    }

    public final B thumbColor(Color THUMB_COLOR) {
        this.properties.put("thumbColor", (Property)new SimpleObjectProperty((Object)THUMB_COLOR));
        return (B)this;
    }

    public final B flatUI(boolean FLAT_UI) {
        this.properties.put("flatUI", (Property)new SimpleBooleanProperty(FLAT_UI));
        return (B)this;
    }

    public final B duration(LocalTime DURATION) {
        this.properties.put("duration", (Property)new SimpleObjectProperty((Object)DURATION));
        return (B)this;
    }

    public final B selected(boolean SELECTED) {
        this.properties.put("selected", (Property)new SimpleBooleanProperty(SELECTED));
        return (B)this;
    }

    public final B averagingEnabled(boolean ENABLED) {
        this.properties.put("averagingEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B averagingPeriod(int PERIOD) {
        this.properties.put("averagingPeriod", (Property)new SimpleIntegerProperty(PERIOD));
        return (B)this;
    }

    public final B timePeriod(Duration PERIOD) {
        this.properties.put("timePeriod", (Property)new SimpleObjectProperty((Object)PERIOD));
        return (B)this;
    }

    public final B maxTimePeriod(Duration MAX_PERIOD) {
        this.properties.put("maxTimePeriod", (Property)new SimpleObjectProperty((Object)MAX_PERIOD));
        return (B)this;
    }

    public final B timePeriodResolution(TimeUnit RESOLUTION) {
        this.properties.put("timePeriodResolution", (Property)new SimpleObjectProperty((Object)RESOLUTION));
        return (B)this;
    }

    public final B fixedYScale(boolean FIXED_Y_SCALE) {
        this.properties.put("fixedYScale", (Property)new SimpleBooleanProperty(FIXED_Y_SCALE));
        return (B)this;
    }

    public final B foregroundBaseColor(Color COLOR) {
        this.properties.put("foregroundBaseColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B startFromZero(boolean START) {
        this.properties.put("startFromZero", (Property)new SimpleBooleanProperty(START));
        return (B)this;
    }

    public final B returnToZero(boolean RETURN) {
        this.properties.put("returnToZero", (Property)new SimpleBooleanProperty(RETURN));
        return (B)this;
    }

    public final B minMeasuredValueVisible(boolean VISIBLE) {
        this.properties.put("minMeasuredValueVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B maxMeasuredValueVisible(boolean VISIBLE) {
        this.properties.put("maxMeasuredValueVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B oldValueVisible(boolean VISIBLE) {
        this.properties.put("oldValueVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B valueVisible(boolean VISIBLE) {
        this.properties.put("valueVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B foregroundColor(Color COLOR) {
        this.properties.put("foregroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B borderColor(Color COLOR) {
        this.properties.put("borderColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B borderWidth(double WIDTH) {
        this.properties.put("borderWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B knobColor(Color COLOR) {
        this.properties.put("knobColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B activeColor(Color COLOR) {
        this.properties.put("activeColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B animated(boolean ANIMATED) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(ANIMATED));
        return (B)this;
    }

    public final B animationDuration(long DURATION) {
        this.properties.put("animationDuration", (Property)new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final B pauseDuration(long DURATION) {
        this.properties.put("pauseDuration", (Property)new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final B startAngle(double ANGLE) {
        this.properties.put("startAngle", (Property)new SimpleDoubleProperty(ANGLE));
        return (B)this;
    }

    public final B angleRange(double RANGE) {
        this.properties.put("angleRange", (Property)new SimpleDoubleProperty(RANGE));
        return (B)this;
    }

    public final B autoScale(boolean AUTO_SCALE) {
        this.properties.put("autoScale", (Property)new SimpleBooleanProperty(AUTO_SCALE));
        return (B)this;
    }

    public final B needleColor(Color COLOR) {
        this.properties.put("needleColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B barColor(Color COLOR) {
        this.properties.put("barColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B barBackgroundColor(Color COLOR) {
        this.properties.put("barBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B numberFormat(NumberFormat FORMAT) {
        this.properties.put("numberFormat", (Property)new SimpleObjectProperty((Object)FORMAT));
        return (B)this;
    }

    public final B shadowsEnabled(boolean ENABLED) {
        this.properties.put("shadowsEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B styleClass(String ... STYLES) {
        this.properties.put("styleClass", (Property)new SimpleObjectProperty((Object)STYLES));
        return (B)this;
    }

    public final B sections(Section ... SECTIONS) {
        this.properties.put("sectionsArray", (Property)new SimpleObjectProperty((Object)SECTIONS));
        return (B)this;
    }

    public final B sections(List<Section> SECTIONS) {
        this.properties.put("sectionsList", (Property)new SimpleObjectProperty(SECTIONS));
        return (B)this;
    }

    public final B series(XYChart.Series<String, Number> ... SERIES) {
        this.properties.put("seriesArray", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B series(List<XYChart.Series<String, Number>> SERIES) {
        this.properties.put("seriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B tilesFxSeries(TilesFXSeries<String, Number> ... SERIES) {
        this.properties.put("tilesFxSeriesArray", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B tilesFxSeries(List<TilesFXSeries<String, Number>> SERIES) {
        this.properties.put("tilesFxSeriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B chartType(Tile.ChartType TYPE) {
        this.properties.put("chartType", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B tooltipTimeout(double TIMEOUT) {
        this.properties.put("tooltipTimeout", (Property)new SimpleDoubleProperty(TIMEOUT));
        return (B)this;
    }

    public final B barChartItems(BarChartItem ... ITEMS) {
        this.properties.put("barChartItemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B barChartItems(List<BarChartItem> ITEMS) {
        this.properties.put("barChartItemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B leaderBoardItems(LeaderBoardItem ... ITEMS) {
        this.properties.put("leaderBoardItemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B leaderBoardItems(List<LeaderBoardItem> ITEMS) {
        this.properties.put("leaderBoardItemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B chartData(ChartData ... DATA) {
        this.properties.put("chartDataArray", (Property)new SimpleObjectProperty((Object)DATA));
        return (B)this;
    }

    public final B chartData(List<ChartData> DATA) {
        this.properties.put("chartDataList", (Property)new SimpleObjectProperty(DATA));
        return (B)this;
    }

    public final B characters(String ... CHARACTERS) {
        this.properties.put("characterArray", (Property)new SimpleObjectProperty((Object)CHARACTERS));
        return (B)this;
    }

    public final B flipTimeInMS(long TIME) {
        this.properties.put("flipTimeInMS", (Property)new SimpleLongProperty(TIME));
        return (B)this;
    }

    public final B flipText(String TEXT) {
        this.properties.put("flipText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B itemSorting(Tile.ItemSorting ITEM_SORTING) {
        this.properties.put("itemSorting", (Property)new SimpleObjectProperty((Object)ITEM_SORTING));
        return (B)this;
    }

    public final B itemSortingTopic(Tile.ItemSortingTopic ITEM_SORTING_TOPIC) {
        this.properties.put("itemSortingTopic", (Property)new SimpleObjectProperty((Object)ITEM_SORTING_TOPIC));
        return (B)this;
    }

    public final B titleColor(Color COLOR) {
        this.properties.put("titleColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B descriptionColor(Color COLOR) {
        this.properties.put("descriptionColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public B unitColor(Color COLOR) {
        this.properties.put("unitColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public B valueColor(Color COLOR) {
        this.properties.put("valueColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public B thresholdColor(Color COLOR) {
        this.properties.put("thresholdColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public B lowerThresholdColor(Color COLOR) {
        this.properties.put("lowerThresholdColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B checkSectionsForValue(boolean CHECK) {
        this.properties.put("checkSectionsForValue", (Property)new SimpleBooleanProperty(CHECK));
        return (B)this;
    }

    public final B checkThreshold(boolean CHECK) {
        this.properties.put("checkThreshold", (Property)new SimpleBooleanProperty(CHECK));
        return (B)this;
    }

    public final B checkLowerThreshold(boolean CHECK) {
        this.properties.put("checkLowerThreshold", (Property)new SimpleBooleanProperty(CHECK));
        return (B)this;
    }

    public final B innerShadowEnabled(boolean ENABLED) {
        this.properties.put("innerShadowEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B thresholdVisible(boolean VISIBLE) {
        this.properties.put("thresholdVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B lowerThresholdVisible(boolean VISIBLE) {
        this.properties.put("lowerThresholdVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B averageVisible(boolean VISIBLE) {
        this.properties.put("averageVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionsVisible(boolean VISIBLE) {
        this.properties.put("sectionsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionsAlwaysVisible(boolean VISIBLE) {
        this.properties.put("sectionsAlwaysVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionTextVisible(boolean VISIBLE) {
        this.properties.put("sectionTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionIconsVisible(boolean VISIBLE) {
        this.properties.put("sectionIconsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B highlightSections(boolean HIGHLIGHT) {
        this.properties.put("highlightSections", (Property)new SimpleBooleanProperty(HIGHLIGHT));
        return (B)this;
    }

    public final B orientation(Orientation ORIENTATION) {
        this.properties.put("orientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B customFontEnabled(boolean ENABLED) {
        this.properties.put("customFontEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B customFont(Font FONT) {
        this.properties.put("customFont", (Property)new SimpleObjectProperty((Object)FONT));
        return (B)this;
    }

    public final B customDecimalFormatEnabled(boolean ENABLED) {
        this.properties.put("customDecimalFormatEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B customDecimalFormat(DecimalFormat DECIMAL_FORMAT) {
        this.properties.put("customDecimalFormat", (Property)new SimpleObjectProperty((Object)DECIMAL_FORMAT));
        return (B)this;
    }

    public final B alertMessage(String MESSAGE) {
        this.properties.put("alertMessage", (Property)new SimpleStringProperty(MESSAGE));
        return (B)this;
    }

    public final B smoothing(boolean SMOOTHING) {
        this.properties.put("smoothing", (Property)new SimpleBooleanProperty(SMOOTHING));
        return (B)this;
    }

    public final B onValueChanged(InvalidationListener LISTENER) {
        this.properties.put("onValueChanged", (Property)new SimpleObjectProperty((Object)LISTENER));
        return (B)this;
    }

    public final B onThresholdExceeded(TileEventListener HANDLER) {
        this.properties.put("onThresholdExceeded", (Property)new SimpleObjectProperty((Object)HANDLER));
        return (B)this;
    }

    public final B onThresholdUnderrun(TileEventListener HANDLER) {
        this.properties.put("onThresholdUnderrun", (Property)new SimpleObjectProperty((Object)HANDLER));
        return (B)this;
    }

    public final B time(ZonedDateTime TIME) {
        this.properties.put("time", (Property)new SimpleObjectProperty((Object)TIME));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B textAlignment(TextAlignment ALIGNMENT) {
        this.properties.put("textAlignment", (Property)new SimpleObjectProperty((Object)ALIGNMENT));
        return (B)this;
    }

    public final B timeSections(TimeSection ... SECTIONS) {
        this.properties.put("timeSectionsArray", (Property)new SimpleObjectProperty((Object)SECTIONS));
        return (B)this;
    }

    public final B timeSections(List<TimeSection> SECTIONS) {
        this.properties.put("timeSectionsList", (Property)new SimpleObjectProperty(SECTIONS));
        return (B)this;
    }

    public final B discreteSeconds(boolean DISCRETE) {
        this.properties.put("discreteSeconds", (Property)new SimpleBooleanProperty(DISCRETE));
        return (B)this;
    }

    public final B discreteMinutes(boolean DISCRETE) {
        this.properties.put("discreteMinutes", (Property)new SimpleBooleanProperty(DISCRETE));
        return (B)this;
    }

    public final B discreteHours(boolean DISCRETE) {
        this.properties.put("discreteHours", (Property)new SimpleBooleanProperty(DISCRETE));
        return (B)this;
    }

    public final B secondsVisible(boolean VISIBLE) {
        this.properties.put("secondsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B textVisible(boolean VISIBLE) {
        this.properties.put("textVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B dateVisible(boolean VISIBLE) {
        this.properties.put("dateVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B running(boolean RUNNING) {
        this.properties.put("running", (Property)new SimpleBooleanProperty(RUNNING));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B dateColor(Color COLOR) {
        this.properties.put("dateColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B hourTickMarkColor(Color COLOR) {
        this.properties.put("hourTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B minuteTickMarkColor(Color COLOR) {
        this.properties.put("minuteTickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B alarmColor(Color COLOR) {
        this.properties.put("alarmColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickLabelColor(Color COLOR) {
        this.properties.put("tickLabelColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B tickMarkColor(Color COLOR) {
        this.properties.put("tickMarkColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B hourTickMarksVisible(boolean VISIBLE) {
        this.properties.put("hourTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minuteTickMarksVisible(boolean VISIBLE) {
        this.properties.put("minuteTickMarksVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B hourColor(Color COLOR) {
        this.properties.put("hourColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B minuteColor(Color COLOR) {
        this.properties.put("minuteColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B secondColor(Color COLOR) {
        this.properties.put("secondColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B alarmsEnabled(boolean ENABLED) {
        this.properties.put("alarmsEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B alarmsVisible(boolean VISIBLE) {
        this.properties.put("alarmsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B tooltipText(String TEXT) {
        this.properties.put("tooltipText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B alarms(Alarm ... ALARMS) {
        this.properties.put("alarmsArray", (Property)new SimpleObjectProperty((Object)ALARMS));
        return (B)this;
    }

    public final B alarms(List<Alarm> ALARMS) {
        this.properties.put("alarmsList", (Property)new SimpleObjectProperty(ALARMS));
        return (B)this;
    }

    public final B onAlarm(AlarmEventListener LISTENER) {
        this.properties.put("onAlarm", (Property)new SimpleObjectProperty((Object)LISTENER));
        return (B)this;
    }

    public final B onTimeEvent(TimeEventListener LISTENER) {
        this.properties.put("onTimeEvent", (Property)new SimpleObjectProperty((Object)LISTENER));
        return (B)this;
    }

    public final B onTileEvent(TileEventListener LISTENER) {
        this.properties.put("onTileEvent", (Property)new SimpleObjectProperty((Object)LISTENER));
        return (B)this;
    }

    public final B increment(double INCREMENT) {
        this.properties.put("increment", (Property)new SimpleDoubleProperty(INCREMENT));
        return (B)this;
    }

    public final B image(Image IMAGE) {
        this.properties.put("image", (Property)new SimpleObjectProperty((Object)IMAGE));
        return (B)this;
    }

    public final B imageMask(Tile.ImageMask MASK) {
        this.properties.put("imageMask", (Property)new SimpleObjectProperty((Object)MASK));
        return (B)this;
    }

    public final B graphic(Node GRAPHIC) {
        this.properties.put("graphic", (Property)new SimpleObjectProperty((Object)GRAPHIC));
        return (B)this;
    }

    public final B svgPath(SVGPath SVG_PATH) {
        this.properties.put("svgPath", (Property)new SimpleObjectProperty((Object)SVG_PATH));
        return (B)this;
    }

    public final B currentLocation(Location LOCATION) {
        this.properties.put("currentLocation", (Property)new SimpleObjectProperty((Object)LOCATION));
        return (B)this;
    }

    public final B pointsOfInterest(Location ... LOCATIONS) {
        this.properties.put("poiArray", (Property)new SimpleObjectProperty((Object)LOCATIONS));
        return (B)this;
    }

    public final B pointsOfInterest(List<Location> LOCATIONS) {
        this.properties.put("poiList", (Property)new SimpleObjectProperty(LOCATIONS));
        return (B)this;
    }

    public final B track(Location ... LOCATIONS) {
        this.properties.put("trackArray", (Property)new SimpleObjectProperty((Object)LOCATIONS));
        return (B)this;
    }

    public final B track(List<Location> LOCATIONS) {
        this.properties.put("trackList", (Property)new SimpleObjectProperty(LOCATIONS));
        return (B)this;
    }

    public final B trackColor(Tile.TileColor COLOR) {
        this.properties.put("trackColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B mapProvider(Tile.MapProvider PROVIDER) {
        this.properties.put("mapProvider", (Property)new SimpleObjectProperty((Object)PROVIDER));
        return (B)this;
    }

    public final B gradientStops(Stop ... STOPS) {
        this.properties.put("gradientStopsArray", (Property)new SimpleObjectProperty((Object)STOPS));
        return (B)this;
    }

    public final B gradientStops(List<Stop> STOPS) {
        this.properties.put("gradientStopsList", (Property)new SimpleObjectProperty(STOPS));
        return (B)this;
    }

    public final B strokeWithGradient(boolean STROKE_WITH_GRADIENT) {
        this.properties.put("strokeWithGradient", (Property)new SimpleBooleanProperty(STROKE_WITH_GRADIENT));
        return (B)this;
    }

    public final B fillWithGradient(boolean FILL_WITH_GRADIENT) {
        this.properties.put("fillWithGradient", (Property)new SimpleBooleanProperty(FILL_WITH_GRADIENT));
        return (B)this;
    }

    public final B roundedCorners(boolean ROUNDED) {
        this.properties.put("roundedCorners", (Property)new SimpleBooleanProperty(ROUNDED));
        return (B)this;
    }

    public final B textSize(Tile.TextSize SIZE) {
        this.properties.put("textSize", (Property)new SimpleObjectProperty((Object)SIZE));
        return (B)this;
    }

    public final B xAxis(Axis AXIS) {
        this.properties.put("xAxis", (Property)new SimpleObjectProperty((Object)AXIS));
        return (B)this;
    }

    public final B yAxis(Axis AXIS) {
        this.properties.put("yAxis", (Property)new SimpleObjectProperty((Object)AXIS));
        return (B)this;
    }

    public final B radarChartMode(RadarChartMode RadarChartMODE) {
        this.properties.put("radarChartMode", (Property)new SimpleObjectProperty((Object)RadarChartMODE));
        return (B)this;
    }

    public final B chartGridColor(Color COLOR) {
        this.properties.put("chartGridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B country(Country COUNTRY) {
        this.properties.put("country", (Property)new SimpleObjectProperty((Object)COUNTRY));
        return (B)this;
    }

    public final B countryGroup(CountryGroup COUNTRY_GROUP) {
        this.properties.put("countryGroup", (Property)new SimpleObjectProperty((Object)COUNTRY_GROUP));
        return (B)this;
    }

    public final B dataPointsVisible(boolean VISIBLE) {
        this.properties.put("dataPointsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sunburstTree(TreeNode TREE) {
        this.properties.put("sunburstTree", (Property)new SimpleObjectProperty((Object)TREE));
        return (B)this;
    }

    public final B sunburstBackgroundColor(Color COLOR) {
        this.properties.put("sunburstBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B sunburstTextColor(Color COLOR) {
        this.properties.put("sunburstTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B sunburstUseColorFromParent(boolean USE) {
        this.properties.put("sunburstUseColorFromParent", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B sunburstTextOrientation(SunburstChart.TextOrientation ORIENTATION) {
        this.properties.put("sunburstTextOrientation", (Property)new SimpleObjectProperty((Object)ORIENTATION));
        return (B)this;
    }

    public final B sunburstVisibleData(SunburstChart.VisibleData VISIBLE_DATA) {
        this.properties.put("sunburstVisibleData", (Property)new SimpleObjectProperty((Object)VISIBLE_DATA));
        return (B)this;
    }

    public final B sunburstInteractive(boolean INTERACTIVE) {
        this.properties.put("sunburstInteractive", (Property)new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B sunburstAutoTextColor(boolean AUTOMATIC) {
        this.properties.put("sunburstAutoTextColor", (Property)new SimpleBooleanProperty(AUTOMATIC));
        return (B)this;
    }

    public final B sunburstUseChartDataTextColor(boolean USE) {
        this.properties.put("sunburstUseChartDataTextColor", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B snapToTicks(boolean SNAP) {
        this.properties.put("snapToTicks", (Property)new SimpleBooleanProperty(SNAP));
        return (B)this;
    }

    public final B minorTickCount(int COUNT) {
        this.properties.put("minorTickCount", (Property)new SimpleIntegerProperty(COUNT));
        return (B)this;
    }

    public final B majorTickUnit(double UNIT) {
        this.properties.put("majorTickUnit", (Property)new SimpleDoubleProperty(UNIT));
        return (B)this;
    }

    public final B matrixSize(int COLS, int ROWS) {
        this.properties.put("matrixSize", null);
        this.properties.put("matrixColumns", (Property)new SimpleIntegerProperty(COLS));
        this.properties.put("matrixRows", (Property)new SimpleIntegerProperty(ROWS));
        return (B)this;
    }

    public final B matrixIcons(MatrixIcon ... MATRIX_ICONS) {
        this.properties.put("matrixIconsArray", (Property)new SimpleObjectProperty((Object)MATRIX_ICONS));
        return (B)this;
    }

    public final B matrixIcons(List<MatrixIcon> MATRIX_ICONS) {
        this.properties.put("matrixIconsList", (Property)new SimpleObjectProperty(MATRIX_ICONS));
        return (B)this;
    }

    public final B notifyRegionBackgroundColor(Color COLOR) {
        this.properties.put("notifyRegionBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B notifyRegionForegroundColor(Color COLOR) {
        this.properties.put("notifyRegionForegroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B notifyRegionTooltipText(String TEXT) {
        this.properties.put("notifyRegionTooltipText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B showNotifyRegion(boolean SHOW) {
        this.properties.put("showNotifyRegion", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B infoRegionBackgroundColor(Color COLOR) {
        this.properties.put("infoRegionBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B infoRegionForegroundColor(Color COLOR) {
        this.properties.put("infoRegionForegroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B infoRegionTooltipText(String TEXT) {
        this.properties.put("infoRegionTooltipText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B showInfoRegion(boolean SHOW) {
        this.properties.put("showInfoRegion", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B lowerRightRegionBackgroundColor(Color COLOR) {
        this.properties.put("lowerRightRegionBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B lowerRightRegionForegroundColor(Color COLOR) {
        this.properties.put("lowerRightRegionForegroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B lowerRightRegionTooltipText(String TEXT) {
        this.properties.put("lowerRightRegionTooltipText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B showLowerRightRegion(boolean SHOW) {
        this.properties.put("showLowerRightRegion", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B leftText(String TEXT) {
        this.properties.put("leftText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B middleText(String TEXT) {
        this.properties.put("middleText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B rightText(String TEXT) {
        this.properties.put("rightText", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B leftValue(double VALUE) {
        this.properties.put("leftValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B middleValue(double VALUE) {
        this.properties.put("middleValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B rightValue(double VALUE) {
        this.properties.put("rightValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B leftGraphics(Node NODE) {
        this.properties.put("leftGraphics", (Property)new SimpleObjectProperty((Object)NODE));
        return (B)this;
    }

    public final B middleGraphics(Node NODE) {
        this.properties.put("middleGraphics", (Property)new SimpleObjectProperty((Object)NODE));
        return (B)this;
    }

    public final B rightGraphics(Node NODE) {
        this.properties.put("rightGraphics", (Property)new SimpleObjectProperty((Object)NODE));
        return (B)this;
    }

    public final B trendVisible(boolean VISIBLE) {
        this.properties.put("trendVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B timeoutMs(long TIMEOUT_MS) {
        this.properties.put("timeoutMs", (Property)new SimpleLongProperty(TIMEOUT_MS));
        return (B)this;
    }

    public final B rank(Rank RANK) {
        this.properties.put("rank", (Property)new SimpleObjectProperty((Object)RANK));
        return (B)this;
    }

    public final B interactive(boolean INTERACTIVE) {
        this.properties.put("interactive", (Property)new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B numberOfValuesForTrendCalculation(int NUMBER) {
        this.properties.put("numberOfValuesForTrendCalculation", (Property)new SimpleIntegerProperty(NUMBER));
        return (B)this;
    }

    public final B backgroundImage(Image IMAGE) {
        this.properties.put("backgroundImage", (Property)new SimpleObjectProperty((Object)IMAGE));
        return (B)this;
    }

    public final B backgroundImageOpacity(double OPACITY) {
        this.properties.put("backgroundImageOpacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B backgroundImageKeepAspect(boolean KEEP_ASPECT) {
        this.properties.put("backgroundImageKeepAspect", (Property)new SimpleBooleanProperty(KEEP_ASPECT));
        return (B)this;
    }

    public final B infoRegionEventHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("infoRegionEventHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final Tile build() {
        Object items;
        Tile TILE;
        if (this.properties.containsKey("skinType")) {
            Tile.SkinType skinType = (Tile.SkinType)((Object)((ObjectProperty)this.properties.get("skinType")).get());
            TILE = new Tile(skinType);
            switch (skinType) {
                case SMOOTHED_CHART: {
                    break;
                }
                case BAR_CHART: {
                    TILE.setItemSorting(Tile.ItemSorting.DESCENDING);
                    TILE.setAnimated(false);
                    break;
                }
                case CLOCK: {
                    break;
                }
                case GAUGE: {
                    TILE.setAnimated(true);
                    TILE.setTickLabelDecimals(0);
                    TILE.setBarColor(Tile.FOREGROUND);
                    TILE.setThresholdColor(Tile.BLUE);
                    TILE.setThresholdVisible(true);
                    break;
                }
                case GAUGE2: {
                    TILE.setAngleRange(240.0);
                    TILE.setStartAngle(330.0);
                    TILE.setAnimated(true);
                    TILE.setTickLabelDecimals(0);
                    TILE.setBarColor(Tile.BLUE);
                    TILE.setBarBackgroundColor(Tile.BACKGROUND.brighter());
                    break;
                }
                case HIGH_LOW: {
                    TILE.setMaxValue(Double.MAX_VALUE);
                    TILE.setDecimals(2);
                    TILE.setTickLabelDecimals(1);
                    break;
                }
                case PERCENTAGE: {
                    TILE.setAnimated(true);
                    TILE.setThresholdColor(Tile.GRAY);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case PLUS_MINUS: {
                    break;
                }
                case SLIDER: {
                    TILE.setBarBackgroundColor(Tile.FOREGROUND);
                    break;
                }
                case SPARK_LINE: {
                    TILE.setTextVisible(false);
                    TILE.setAnimated(false);
                    TILE.setAveragingEnabled(true);
                    TILE.setAveragingPeriod(10);
                    TILE.setDecimals(0);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case SWITCH: {
                    break;
                }
                case WORLDMAP: {
                    TILE.setPrefSize(380.0, 250.0);
                    break;
                }
                case TIMER_CONTROL: {
                    TILE.setSectionsVisible(true);
                    TILE.setHighlightSections(true);
                    TILE.setCheckSectionsForValue(true);
                    break;
                }
                case NUMBER: {
                    break;
                }
                case TEXT: {
                    break;
                }
                case TIME: {
                    break;
                }
                case CUSTOM: {
                    break;
                }
                case CUSTOM_SCROLLABLE: {
                    break;
                }
                case LEADER_BOARD: {
                    TILE.setItemSorting(Tile.ItemSorting.DESCENDING);
                    break;
                }
                case MAP: {
                    break;
                }
                case RADIAL_CHART: {
                    TILE.setAnimated(true);
                    break;
                }
                case DONUT_CHART: {
                    TILE.setItemSorting(Tile.ItemSorting.DESCENDING);
                    TILE.setAnimated(true);
                    break;
                }
                case CIRCULAR_PROGRESS: {
                    TILE.setBarBackgroundColor(TILE.getBackgroundColor().brighter());
                    TILE.setAnimated(true);
                    break;
                }
                case STOCK: {
                    TILE.setAnimated(false);
                    TILE.setAveragingPeriod(720);
                    TILE.setAveragingEnabled(true);
                    TILE.setDecimals(2);
                    TILE.setTickLabelDecimals(2);
                    TILE.setThresholdColor(Tile.GRAY);
                    TILE.setTextVisible(false);
                    break;
                }
                case GAUGE_SPARK_LINE: {
                    TILE.setBarBackgroundColor(Tile.BACKGROUND.brighter());
                    TILE.setBarColor(Tile.BLUE);
                    TILE.setAngleRange(270.0);
                    break;
                }
                case SMOOTH_AREA_CHART: {
                    TILE.setSmoothing(true);
                    TILE.setChartType(Tile.ChartType.AREA);
                    break;
                }
                case RADAR_CHART: {
                    break;
                }
                case RADAR_NODE_CHART: {
                    break;
                }
                case COUNTRY: {
                    break;
                }
                case CHARACTER: {
                    break;
                }
                case FLIP: {
                    break;
                }
                case SWITCH_SLIDER: {
                    TILE.setBarBackgroundColor(Tile.FOREGROUND);
                    break;
                }
                case DATE: {
                    TILE.setTitleAlignment(TextAlignment.CENTER);
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    break;
                }
                case CALENDAR: {
                    TILE.setTitleAlignment(TextAlignment.CENTER);
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    break;
                }
                case SUNBURST: {
                    break;
                }
                case MATRIX: {
                    break;
                }
                case MATRIX_ICON: {
                    break;
                }
                case RADIAL_PERCENTAGE: {
                    TILE.setBarBackgroundColor(TILE.getBackgroundColor().brighter());
                    TILE.setAnimated(true);
                    break;
                }
                case STATUS: {
                    TILE.setDescriptionAlignment(Pos.TOP_CENTER);
                    break;
                }
                case BAR_GAUGE: {
                    TILE.setBarBackgroundColor(Tile.BACKGROUND.brighter());
                    TILE.setBarColor(Tile.BLUE);
                    TILE.setAngleRange(180.0);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case IMAGE: {
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    break;
                }
                case IMAGE_COUNTER: {
                    TILE.setTextAlignment(TextAlignment.LEFT);
                    TILE.setDecimals(0);
                    break;
                }
                case TIMELINE: {
                    TILE.setDataPointsVisible(true);
                    TILE.setTextVisible(false);
                    TILE.setAnimated(false);
                    TILE.setAveragingEnabled(true);
                    TILE.setAveragingPeriod(Helper.calcNumberOfDatapointsForPeriod(TILE.getTimePeriod(), TILE.getTimePeriodResolution()));
                    TILE.setDecimals(0);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case CLUSTER_MONITOR: {
                    TILE.setTitle("");
                    TILE.setTextVisible(false);
                    TILE.setUnit("%");
                    TILE.setAnimated(false);
                    TILE.setDecimals(0);
                    TILE.setBarColor(Tile.BLUE);
                    break;
                }
                case LED: {
                    TILE.setActiveColor(Bright.GREEN);
                    break;
                }
                case COUNTDOWN_TIMER: {
                    TILE.setBarBackgroundColor(TILE.getBackgroundColor().brighter());
                    TILE.setAnimated(false);
                    TILE.setTimePeriod(Duration.ofSeconds(60L));
                    break;
                }
                case CYCLE_STEP: {
                    break;
                }
                case COLOR: {
                    TILE.setForegroundColor(Color.WHITE);
                    TILE.setUnit("%");
                    TILE.setDecimals(0);
                    TILE.setBarBackgroundColor(Tile.BACKGROUND);
                    break;
                }
                case FLUID: {
                    break;
                }
                case FIRE_SMOKE: {
                    break;
                }
                case TURNOVER: {
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    TILE.setImageMask(Tile.ImageMask.ROUND);
                    break;
                }
                case RADIAL_DISTRIBUTION: {
                    TILE.setStartAngle(330.0);
                    TILE.setAngleRange(240.0);
                    TILE.setAnimated(false);
                    TILE.setTickLabelDecimals(0);
                    TILE.setBarBackgroundColor(Tile.BACKGROUND.brighter());
                    break;
                }
            }
        } else {
            TILE = new Tile();
        }
        if (this.properties.keySet().contains("sectionsArray")) {
            TILE.setSections((Section[])((ObjectProperty)this.properties.get("sectionsArray")).get());
        }
        if (this.properties.keySet().contains("sectionsList")) {
            TILE.setSections((List)((ObjectProperty)this.properties.get("sectionsList")).get());
        }
        if (this.properties.keySet().contains("characterArray")) {
            TILE.setCharacters((String[])((ObjectProperty)this.properties.get("characterArray")).get());
        }
        if (this.properties.keySet().contains("foregroundBaseColor")) {
            TILE.setForegroundBaseColor((Color)((ObjectProperty)this.properties.get("foregroundBaseColor")).get());
        }
        if (this.properties.keySet().contains("maxValue")) {
            TILE.setMaxValue(((DoubleProperty)this.properties.get("maxValue")).get());
        }
        if (this.properties.keySet().contains("minValue")) {
            TILE.setMinValue(((DoubleProperty)this.properties.get("minValue")).get());
        }
        if (this.properties.keySet().contains("alarmsArray")) {
            TILE.setAlarms((Alarm[])((ObjectProperty)this.properties.get("alarmsArray")).get());
        }
        if (this.properties.keySet().contains("alarmsList")) {
            TILE.setAlarms((List)((ObjectProperty)this.properties.get("alarmsList")).get());
        }
        if (this.properties.keySet().contains("timeSectionsArray")) {
            TILE.setTimeSections((TimeSection[])((ObjectProperty)this.properties.get("timeSectionsArray")).get());
        }
        if (this.properties.keySet().contains("timeSectionsList")) {
            TILE.setTimeSections((List)((ObjectProperty)this.properties.get("timeSectionsList")).get());
        }
        if (this.properties.keySet().contains("seriesArray")) {
            TILE.setSeries((XYChart.Series[])((ObjectProperty)this.properties.get("seriesArray")).get());
        }
        if (this.properties.keySet().contains("seriesList")) {
            TILE.setSeries((List)((ObjectProperty)this.properties.get("seriesList")).get());
        }
        if (this.properties.keySet().contains("tilesFxSeriesArray")) {
            TILE.setTilesFXSeries((TilesFXSeries[])((ObjectProperty)this.properties.get("tilesFxSeriesArray")).get());
        }
        if (this.properties.keySet().contains("tilesFxSeriesList")) {
            TILE.setTilesFXSeries((List)((ObjectProperty)this.properties.get("tilesFxSeriesList")).get());
        }
        if (this.properties.keySet().contains("barChartItemsArray")) {
            for (Object item : items = (BarChartItem[])((ObjectProperty)this.properties.get("barChartItemsArray")).get()) {
                ((BarChartItem)item).getChartData().setAnimated(TILE.isAnimated());
            }
            TILE.setBarChartItems((BarChartItem[])items);
        }
        if (this.properties.keySet().contains("barChartItemsList")) {
            items = (List)((ObjectProperty)this.properties.get("barChartItemsList")).get();
            Iterator iterator = items.iterator();
            while (iterator.hasNext()) {
                BarChartItem item = (BarChartItem)iterator.next();
                item.getChartData().setAnimated(TILE.isAnimated());
            }
            TILE.setBarChartItems((List<BarChartItem>)items);
        }
        if (this.properties.keySet().contains("leaderBoardItemsArray")) {
            TILE.setLeaderBoardItems((LeaderBoardItem[])((ObjectProperty)this.properties.get("leaderBoardItemsArray")).get());
        }
        if (this.properties.keySet().contains("leaderBoardItemsList")) {
            TILE.setLeaderBoardItems((List)((ObjectProperty)this.properties.get("leaderBoardItemsList")).get());
        }
        if (this.properties.keySet().contains("gradientStopsArray")) {
            TILE.setGradientStops((Stop[])((ObjectProperty)this.properties.get("gradientStopsArray")).get());
        }
        if (this.properties.keySet().contains("gradientStopsList")) {
            TILE.setGradientStops((List)((ObjectProperty)this.properties.get("gradientStopsList")).get());
        }
        if (this.properties.keySet().contains("matrixIconsArray")) {
            TILE.setMatrixIcons((MatrixIcon[])((ObjectProperty)this.properties.get("matrixIconsArray")).get());
        }
        if (this.properties.keySet().contains("matrixIconsList")) {
            TILE.setMatrixIcons((List)((ObjectProperty)this.properties.get("matrixIconsList")).get());
        }
        if (this.properties.keySet().contains("chartDataArray")) {
            TILE.setChartData((ChartData[])((ObjectProperty)this.properties.get("chartDataArray")).get());
        }
        if (this.properties.keySet().contains("chartDataList")) {
            TILE.setChartData((List)((ObjectProperty)this.properties.get("chartDataList")).get());
        }
        if (this.properties.keySet().contains("poiArray")) {
            TILE.setPoiLocations((Location[])((ObjectProperty)this.properties.get("poiArray")).get());
        }
        if (this.properties.keySet().contains("poiList")) {
            TILE.setPoiList((List)((ObjectProperty)this.properties.get("poiList")).get());
        }
        if (this.properties.keySet().contains("trackArray")) {
            TILE.setTrack((Location[])((ObjectProperty)this.properties.get("trackArray")).get());
        }
        if (this.properties.keySet().contains("trackList")) {
            TILE.setTrack((List)((ObjectProperty)this.properties.get("trackList")).get());
        }
        for (String key : this.properties.keySet()) {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                TILE.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                TILE.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                TILE.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                TILE.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                TILE.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                TILE.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                TILE.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                TILE.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                TILE.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                TILE.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                TILE.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                TILE.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                TILE.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                TILE.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                TILE.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                TILE.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("styleClass".equals(key)) {
                TILE.getStyleClass().setAll((Object[])new String[]{"tile"});
                TILE.getStyleClass().addAll((Object[])((String[])((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("autoScale".equals(key)) {
                TILE.setAutoScale(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                TILE.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                TILE.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelDecimals".equals(key)) {
                TILE.setTickLabelDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelsXVisible".equals(key)) {
                TILE.setTickLabelsXVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelsYVisible".equals(key)) {
                TILE.setTickLabelsYVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minValueVisible".equals(key)) {
                TILE.setMinValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxValueVisible".equals(key)) {
                TILE.setMaxValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("title".equals(key)) {
                TILE.setTitle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleAlignment".equals(key)) {
                TILE.setTitleAlignment((TextAlignment)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("description".equals(key)) {
                TILE.setDescription((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("descriptionAlignment".equals(key)) {
                TILE.setDescriptionAlignment((Pos)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unit".equals(key)) {
                TILE.setUnit((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thumbColor".equals(key)) {
                TILE.setThumbColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("flatUI".equals(key)) {
                TILE.setFlatUI(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selected".equals(key)) {
                TILE.setActive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("averagingEnabled".equals(key)) {
                TILE.setAveragingEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("averagingPeriod".equals(key)) {
                TILE.setAveragingPeriod(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timePeriod".equals(key)) {
                TILE.setTimePeriod((Duration)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxTimePeriod".equals(key)) {
                TILE.setMaxTimePeriod((Duration)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timePeriodResolution".equals(key)) {
                TILE.setTimePeriodResolution((TimeUnit)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("fixedYScale".equals(key)) {
                TILE.setFixedYScale(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("startFromZero".equals(key)) {
                TILE.setStartFromZero(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("returnToZero".equals(key)) {
                TILE.setReturnToZero(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minMeasuredValueVisible".equals(key)) {
                TILE.setMinMeasuredValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxMeasuredValueVisible".equals(key)) {
                TILE.setMaxMeasuredValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("oldValueVisible".equals(key)) {
                TILE.setOldValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("valueVisible".equals(key)) {
                TILE.setValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("foregroundColor".equals(key)) {
                TILE.setForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                TILE.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("borderColor".equals(key)) {
                TILE.setBorderColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("borderWidth".equals(key)) {
                TILE.setBorderWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("knobColor".equals(key)) {
                TILE.setKnobColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animated".equals(key)) {
                TILE.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animationDuration".equals(key)) {
                TILE.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pauseDuration".equals(key)) {
                TILE.setPauseDuration(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("startAngle".equals(key)) {
                TILE.setStartAngle(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("angleRange".equals(key)) {
                TILE.setAngleRange(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("needleColor".equals(key)) {
                TILE.setNeedleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("barColor".equals(key)) {
                TILE.setBarColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("barBackgroundColor".equals(key)) {
                TILE.setBarBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("locale".equals(key)) {
                TILE.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("numberFormat".equals(key)) {
                TILE.setNumberFormat((NumberFormat)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("shadowsEnabled".equals(key)) {
                TILE.setShadowsEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("style".equals(key)) {
                TILE.setStyle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("innerShadowEnabled".equals(key)) {
                TILE.setInnerShadowEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thresholdVisible".equals(key)) {
                TILE.setThresholdVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerThresholdVisible".equals(key)) {
                TILE.setLowerThresholdVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("averageVisible".equals(key)) {
                TILE.setAverageVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionsVisible".equals(key)) {
                TILE.setSectionsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionsAlwaysVisible".equals(key)) {
                TILE.setSectionsAlwaysVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionTextVisible".equals(key)) {
                TILE.setSectionTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionIconsVisible".equals(key)) {
                TILE.setSectionIconsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("highlightSections".equals(key)) {
                TILE.setHighlightSections(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleColor".equals(key)) {
                TILE.setTitleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("descriptionColor".equals(key)) {
                TILE.setDescriptionColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unitColor".equals(key)) {
                TILE.setUnitColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("valueColor".equals(key)) {
                TILE.setValueColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thresholdColor".equals(key)) {
                TILE.setThresholdColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerThresholdColor".equals(key)) {
                TILE.setLowerThresholdColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("orientation".equals(key)) {
                TILE.setOrientation((Orientation)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("checkSectionsForValue".equals(key)) {
                TILE.setCheckSectionsForValue(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("checkThreshold".equals(key)) {
                TILE.setCheckThreshold(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("checkLowerThreshold".equals(key)) {
                TILE.setCheckLowerThreshold(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onValueChanged".equals(key)) {
                TILE.currentValueProperty().addListener((InvalidationListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("keepAspect".equals(key)) {
                TILE.setKeepAspect(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("threshold".equals(key)) {
                TILE.setThreshold(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerThreshold".equals(key)) {
                TILE.setLowerThreshold(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("referenceValue".equals(key)) {
                TILE.setReferenceValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("autoReferenceValue".equals(key)) {
                TILE.setAutoReferenceValue(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customFontEnabled".equals(key)) {
                TILE.setCustomFontEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customFont".equals(key)) {
                TILE.setCustomFont((Font)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customDecimalFormatEnabled".equals(key)) {
                TILE.setCustomDecimalFormatEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customDecimalFormat".equals(key)) {
                TILE.setCustomDecimalFormat((DecimalFormat)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alertMessage".equals(key)) {
                TILE.setAlertMessage((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("smoothing".equals(key)) {
                TILE.setSmoothing(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("time".equals(key)) {
                TILE.setTime((ZonedDateTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("text".equals(key)) {
                TILE.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textAlignment".equals(key)) {
                TILE.setTextAlignment((TextAlignment)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("discreteSeconds".equals(key)) {
                TILE.setDiscreteSeconds(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("discreteMinutes".equals(key)) {
                TILE.setDiscreteMinutes(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("discreteHours".equals(key)) {
                TILE.setDiscreteHours(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("secondsVisible".equals(key)) {
                TILE.setSecondsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textVisible".equals(key)) {
                TILE.setTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateVisible".equals(key)) {
                TILE.setDateVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                TILE.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateColor".equals(key)) {
                TILE.setDateColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hourTickMarkColor".equals(key)) {
                TILE.setHourTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minuteTickMarkColor".equals(key)) {
                TILE.setMinuteTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmColor".equals(key)) {
                TILE.setAlarmColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelColor".equals(key)) {
                TILE.setTickLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickMarkColor".equals(key)) {
                TILE.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hourTickMarksVisible".equals(key)) {
                TILE.setHourTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minuteTickMarksVisible".equals(key)) {
                TILE.setMinuteTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hourColor".equals(key)) {
                TILE.setHourColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minuteColor".equals(key)) {
                TILE.setMinuteColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("secondColor".equals(key)) {
                TILE.setSecondColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onAlarm".equals(key)) {
                TILE.setOnAlarm((AlarmEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onTimeEvent".equals(key)) {
                TILE.setOnTimeEvent((TimeEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onTileEvent".equals(key)) {
                TILE.setOnTileEvent((TileEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmsEnabled".equals(key)) {
                TILE.setAlarmsEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmsVisible".equals(key)) {
                TILE.setAlarmsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("running".equals(key)) {
                TILE.setRunning(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("increment".equals(key)) {
                TILE.setIncrement(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("activeColor".equals(key)) {
                TILE.setActiveColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("duration".equals(key)) {
                TILE.setDuration((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("strokeWithGradient".equals(key)) {
                TILE.setStrokeWithGradient(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fillWithGradient".equals(key)) {
                TILE.setFillWithGradient(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("image".equals(key)) {
                TILE.setImage((Image)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("imageMask".equals(key)) {
                TILE.setImageMask((Tile.ImageMask)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("graphic".equals(key)) {
                TILE.setGraphic((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("svgPath".equals(key)) {
                TILE.setSVGPath((SVGPath)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("roundedCorners".equals(key)) {
                TILE.setRoundedCorners(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textSize".equals(key)) {
                TILE.setTextSize((Tile.TextSize)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("currentLocation".equals(key)) {
                TILE.setCurrentLocation((Location)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("trackColor".equals(key)) {
                TILE.setTrackColor((Tile.TileColor)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("mapProvider".equals(key)) {
                TILE.setMapProvider((Tile.MapProvider)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("tooltipText".equals(key)) {
                TILE.setTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("xAxis".equals(key)) {
                TILE.setXAxis((Axis)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("yAxis".equals(key)) {
                TILE.setYAxis((Axis)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("radarChartMode".equals(key)) {
                TILE.setRadarChartMode((RadarChartMode)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("chartGridColor".equals(key)) {
                TILE.setChartGridColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("country".equals(key)) {
                TILE.setCountry((Country)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("countryGroup".equals(key)) {
                TILE.setCountryGroup((CountryGroup)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("flipTimeInMS".equals(key)) {
                TILE.setFlipTimeInMS(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("flipText".equals(key)) {
                TILE.setFlipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("itemSorting".equals(key)) {
                TILE.setItemSorting((Tile.ItemSorting)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("itemSortingTopic".equals(key)) {
                TILE.setItemSortingTopic((Tile.ItemSortingTopic)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("dataPointsVisible".equals(key)) {
                TILE.setDataPointsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstTree".equals(key)) {
                TILE.getSunburstChart().setTree((TreeNode)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstBackgroundColor".equals(key)) {
                TILE.getSunburstChart().setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstTextColor".equals(key)) {
                TILE.getSunburstChart().setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstUseColorFromParent".equals(key)) {
                TILE.getSunburstChart().setUseColorFromParent(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstTextOrientation".equals(key)) {
                TILE.getSunburstChart().setTextOrientation((SunburstChart.TextOrientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("sunburstVisibleData".equals(key)) {
                TILE.getSunburstChart().setVisibleData((SunburstChart.VisibleData)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("sunburstInteractive".equals(key)) {
                TILE.getSunburstChart().setInteractive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstAutoTextColor".equals(key)) {
                TILE.getSunburstChart().setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstUseChartDataTextColor".equals(key)) {
                TILE.getSunburstChart().setUseChartDataTextColor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("snapToTicks".equals(key)) {
                TILE.setSnapToTicks(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorTickCount".equals(key)) {
                TILE.setMinorTickCount(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorTickUnit".equals(key)) {
                TILE.setMajorTickUnit(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("matrixSize".equals(key)) {
                int COLS = ((IntegerProperty)this.properties.get("matrixColumns")).get();
                int ROWS = ((IntegerProperty)this.properties.get("matrixRows")).get();
                TILE.setMatrixSize(COLS, ROWS);
                continue;
            }
            if ("chartType".equals(key)) {
                TILE.setChartType((Tile.ChartType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("tooltipTimeout".equals(key)) {
                TILE.setTooltipTimeout(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("notifyRegionBackgroundColor".equals(key)) {
                TILE.setNotifyRegionBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("notifyRegionForegroundColor".equals(key)) {
                TILE.setNotifyRegionForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("notifyRegionTooltipText".equals(key)) {
                TILE.setNotifyRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showNotifyRegion".equals(key)) {
                TILE.showNotifyRegion(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionBackgroundColor".equals(key)) {
                TILE.setInfoRegionBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionForegroundColor".equals(key)) {
                TILE.setInfoRegionForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionTooltipText".equals(key)) {
                TILE.setInfoRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showInfoRegion".equals(key)) {
                TILE.showInfoRegion(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerRightRegionBackgroundColor".equals(key)) {
                TILE.setLowerRightRegionBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerRightRegionForegroundColor".equals(key)) {
                TILE.setLowerRightRegionForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerRightRegionTooltipText".equals(key)) {
                TILE.setLowerRightRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showLowerRightRegion".equals(key)) {
                TILE.showLowerRightRegion(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("leftText".equals(key)) {
                TILE.setLeftText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("middleText".equals(key)) {
                TILE.setMiddleText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rightText".equals(key)) {
                TILE.setRightText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("leftValue".equals(key)) {
                TILE.setLeftValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("middleValue".equals(key)) {
                TILE.setMiddleValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rightValue".equals(key)) {
                TILE.setRightValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("leftGraphics".equals(key)) {
                TILE.setLeftGraphics((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("middleGraphics".equals(key)) {
                TILE.setMiddleGraphics((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rightGraphics".equals(key)) {
                TILE.setRightGraphics((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("trendVisible".equals(key)) {
                TILE.setTrendVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timeoutMs".equals(key)) {
                TILE.setTimeoutMs(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rank".equals(key)) {
                TILE.setRank((Rank)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("interactive".equals(key)) {
                TILE.setInteractive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("numberOfValuesForTrendCalculation".equals(key)) {
                TILE.setNumberOfValuesForTrendCalculation(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundImage".equals(key)) {
                TILE.setBackgroundImage((Image)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundImageOpacity".equals(key)) {
                TILE.setBackgroundImageOpacity(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundImageKeepAspect".equals(key)) {
                TILE.setBackgroundImageKeepAspect(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionEventHandler".equals(key)) {
                TILE.setInfoRegionEventHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("infoRegionTooltipText".equals(key)) {
                TILE.setInfoRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"notifyRegionTooltipText".equals(key)) continue;
            TILE.setNotifyRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
        }
        this.properties.clear();
        return TILE;
    }
}

