/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import dev.langchain4j.mcp.client.transport.McpOperationHandler;
import dev.langchain4j.mcp.client.transport.http.StreamableHttpMcpTransport;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SseSubscriber
implements Flow.Subscriber<String> {
    private final CompletableFuture<JsonNode> future;
    private final Logger log = LoggerFactory.getLogger(SseSubscriber.class);
    private final boolean logResponses;
    private final McpOperationHandler operationHandler;
    private Flow.Subscription subscription;

    SseSubscriber(CompletableFuture<JsonNode> future, boolean logResponses, McpOperationHandler operationHandler) {
        this.future = future;
        this.logResponses = logResponses;
        this.operationHandler = operationHandler;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(String item) {
        if (this.logResponses) {
            this.log.info("SSE event received: " + item);
        }
        this.subscription.request(1L);
        if (item.startsWith("data:")) {
            try {
                this.operationHandler.handle(StreamableHttpMcpTransport.OBJECT_MAPPER.readTree(item.split("data:")[1]));
            }
            catch (JsonProcessingException e) {
                this.log.warn("Failed to parse SSE event: " + item, (Throwable)e);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.future.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.log.debug("SSE channel closed");
    }
}

