/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ReturnBehavior;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.ToolArgumentsException;
import dev.langchain4j.internal.DefaultExecutorProvider;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.HallucinatedToolNameStrategy;
import dev.langchain4j.service.tool.ToolArgumentsErrorHandler;
import dev.langchain4j.service.tool.ToolErrorContext;
import dev.langchain4j.service.tool.ToolErrorHandlerResult;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutionErrorHandler;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import dev.langchain4j.service.tool.ToolServiceContext;
import dev.langchain4j.service.tool.ToolServiceResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;

@Internal
public class ToolService {
    private static final ToolArgumentsErrorHandler DEFAULT_TOOL_ARGUMENTS_ERROR_HANDLER = (error, context) -> {
        if (error instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)error;
            throw re;
        }
        throw new RuntimeException(error);
    };
    private static final ToolExecutionErrorHandler DEFAULT_TOOL_EXECUTION_ERROR_HANDLER = (error, context) -> ToolErrorHandlerResult.text(error.getMessage());
    private final List<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
    private final Map<String, ToolExecutor> toolExecutors = new HashMap<String, ToolExecutor>();
    private final Set<String> immediateReturnTools = new HashSet<String>();
    private ToolProvider toolProvider;
    private Executor executor;
    private int maxSequentialToolsInvocations = 100;
    private ToolArgumentsErrorHandler argumentsErrorHandler;
    private ToolExecutionErrorHandler executionErrorHandler;
    private Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy = HallucinatedToolNameStrategy.THROW_EXCEPTION;

    public void hallucinatedToolNameStrategy(Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy) {
        this.toolHallucinationStrategy = toolHallucinationStrategy;
    }

    public void toolProvider(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    public void tools(Map<ToolSpecification, ToolExecutor> tools) {
        tools.forEach((toolSpecification, toolExecutor) -> {
            this.toolSpecifications.add((ToolSpecification)toolSpecification);
            this.toolExecutors.put(toolSpecification.name(), (ToolExecutor)toolExecutor);
        });
    }

    public void tools(Collection<Object> objectsWithTools) {
        for (Object objectWithTool : objectsWithTools) {
            if (objectWithTool instanceof Class) {
                throw IllegalConfigurationException.illegalConfiguration("Tool '%s' must be an object, not a class", objectWithTool);
            }
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                Utils.getAnnotatedMethod((Method)method, Tool.class).ifPresent(toolMethod -> this.processToolMethod(objectWithTool, (Method)toolMethod));
            }
        }
    }

    private void processToolMethod(Object object, Method method) {
        ToolSpecification toolSpecification = ToolSpecifications.toolSpecificationFrom((Method)method);
        if (this.toolExecutors.containsKey(toolSpecification.name())) {
            throw new IllegalConfigurationException("Duplicated definition for tool: " + toolSpecification.name());
        }
        this.toolSpecifications.add(toolSpecification);
        ToolExecutor toolExecutor = ToolService.createToolExecutor(object, method);
        this.toolExecutors.put(toolSpecification.name(), toolExecutor);
        if (method.getAnnotation(Tool.class).returnBehavior() == ReturnBehavior.IMMEDIATE) {
            this.immediateReturnTools.add(toolSpecification.name());
        }
    }

    private static ToolExecutor createToolExecutor(Object object, Method method) {
        return DefaultToolExecutor.builder().object(object).originalMethod(method).methodToInvoke(method).wrapToolArgumentsExceptions(true).propagateToolExecutionExceptions(true).build();
    }

    public void executeToolsConcurrently() {
        this.executor = ToolService.defaultExecutor();
    }

    public void executeToolsConcurrently(Executor executor) {
        this.executor = (Executor)Utils.getOrDefault((Object)executor, ToolService::defaultExecutor);
    }

    private static Executor defaultExecutor() {
        return DefaultExecutorProvider.getDefaultExecutorService();
    }

    public void maxSequentialToolsInvocations(int maxSequentialToolsInvocations) {
        this.maxSequentialToolsInvocations = maxSequentialToolsInvocations;
    }

    public void argumentsErrorHandler(ToolArgumentsErrorHandler handler) {
        this.argumentsErrorHandler = handler;
    }

    public ToolArgumentsErrorHandler argumentsErrorHandler() {
        return (ToolArgumentsErrorHandler)Utils.getOrDefault((Object)this.argumentsErrorHandler, (Object)DEFAULT_TOOL_ARGUMENTS_ERROR_HANDLER);
    }

    public void executionErrorHandler(ToolExecutionErrorHandler handler) {
        this.executionErrorHandler = handler;
    }

    public ToolExecutionErrorHandler executionErrorHandler() {
        return (ToolExecutionErrorHandler)Utils.getOrDefault((Object)this.executionErrorHandler, (Object)DEFAULT_TOOL_EXECUTION_ERROR_HANDLER);
    }

    public ToolServiceContext createContext(Object memoryId, UserMessage userMessage) {
        if (this.toolProvider == null) {
            return this.toolSpecifications.isEmpty() ? ToolServiceContext.Empty.INSTANCE : new ToolServiceContext(this.toolSpecifications, this.toolExecutors);
        }
        ArrayList<ToolSpecification> toolsSpecs = new ArrayList<ToolSpecification>(this.toolSpecifications);
        HashMap<String, ToolExecutor> toolExecs = new HashMap<String, ToolExecutor>(this.toolExecutors);
        ToolProviderRequest toolProviderRequest = new ToolProviderRequest(memoryId, userMessage);
        ToolProviderResult toolProviderResult = this.toolProvider.provideTools(toolProviderRequest);
        if (toolProviderResult != null) {
            for (Map.Entry<ToolSpecification, ToolExecutor> entry : toolProviderResult.tools().entrySet()) {
                if (toolExecs.putIfAbsent(entry.getKey().name(), entry.getValue()) == null) {
                    toolsSpecs.add(entry.getKey());
                    continue;
                }
                throw new IllegalConfigurationException("Duplicated definition for tool: " + entry.getKey().name());
            }
        }
        return new ToolServiceContext(toolsSpecs, toolExecs);
    }

    public ToolServiceResult executeInferenceAndToolsLoop(ChatResponse chatResponse, ChatRequestParameters parameters, List<ChatMessage> messages, ChatModel chatModel, ChatMemory chatMemory, Object memoryId, Map<String, ToolExecutor> toolExecutors, boolean isReturnTypeResult) {
        TokenUsage aggregateTokenUsage = chatResponse.metadata().tokenUsage();
        ArrayList<ToolExecution> toolExecutions = new ArrayList<ToolExecution>();
        ArrayList<ChatResponse> intermediateResponses = new ArrayList<ChatResponse>();
        int executionsLeft = this.maxSequentialToolsInvocations;
        while (true) {
            if (executionsLeft-- == 0) {
                throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{this.maxSequentialToolsInvocations});
            }
            AiMessage aiMessage = chatResponse.aiMessage();
            if (chatMemory != null) {
                chatMemory.add((ChatMessage)aiMessage);
            } else {
                messages = new ArrayList<ChatMessage>(messages);
                messages.add((ChatMessage)aiMessage);
            }
            if (!aiMessage.hasToolExecutionRequests()) break;
            intermediateResponses.add(chatResponse);
            Map<ToolExecutionRequest, ToolExecutionResultMessage> toolResults = this.execute(aiMessage.toolExecutionRequests(), toolExecutors, memoryId);
            boolean immediateToolReturn = true;
            for (Map.Entry<ToolExecutionRequest, ToolExecutionResultMessage> entry : toolResults.entrySet()) {
                ToolExecutionRequest toolExecutionRequest = entry.getKey();
                ToolExecutionResultMessage toolExecutionResultMessage = entry.getValue();
                ToolExecution toolExecution = ToolExecution.builder().request(toolExecutionRequest).result(toolExecutionResultMessage.text()).build();
                toolExecutions.add(toolExecution);
                if (chatMemory != null) {
                    chatMemory.add((ChatMessage)toolExecutionResultMessage);
                } else {
                    messages.add(toolExecutionResultMessage);
                }
                if (!immediateToolReturn) continue;
                if (this.isImmediateTool(toolExecutionRequest.name())) {
                    if (isReturnTypeResult) continue;
                    throw IllegalConfigurationException.illegalConfiguration("Tool '%s' with immediate return is not allowed on a AI service not returning Result.", toolExecutionRequest.name());
                }
                immediateToolReturn = false;
            }
            if (immediateToolReturn) {
                ChatResponse finalResponse = (ChatResponse)intermediateResponses.remove(intermediateResponses.size() - 1);
                return ToolServiceResult.builder().intermediateResponses(intermediateResponses).finalResponse(finalResponse).toolExecutions(toolExecutions).aggregateTokenUsage(aggregateTokenUsage).immediateToolReturn(true).build();
            }
            if (chatMemory != null) {
                messages = chatMemory.messages();
            }
            ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(parameters).build();
            chatResponse = chatModel.chat(chatRequest);
            aggregateTokenUsage = TokenUsage.sum((TokenUsage)aggregateTokenUsage, (TokenUsage)chatResponse.metadata().tokenUsage());
        }
        return ToolServiceResult.builder().intermediateResponses(intermediateResponses).finalResponse(chatResponse).toolExecutions(toolExecutions).aggregateTokenUsage(aggregateTokenUsage).build();
    }

    private Map<ToolExecutionRequest, ToolExecutionResultMessage> execute(List<ToolExecutionRequest> toolExecutionRequests, Map<String, ToolExecutor> toolExecutors, Object memoryId) {
        if (this.executor != null && toolExecutionRequests.size() > 1) {
            return this.executeConcurrently(toolExecutionRequests, toolExecutors, memoryId);
        }
        return this.executeSequentially(toolExecutionRequests, toolExecutors, memoryId);
    }

    private Map<ToolExecutionRequest, ToolExecutionResultMessage> executeConcurrently(List<ToolExecutionRequest> toolExecutionRequests, Map<String, ToolExecutor> toolExecutors, Object memoryId) {
        LinkedHashMap<ToolExecutionRequest, CompletableFuture<ToolExecutionResultMessage>> futures = new LinkedHashMap<ToolExecutionRequest, CompletableFuture<ToolExecutionResultMessage>>();
        for (ToolExecutionRequest toolExecutionRequest : toolExecutionRequests) {
            CompletableFuture<ToolExecutionResultMessage> future = CompletableFuture.supplyAsync(() -> {
                ToolExecutor toolExecutor = (ToolExecutor)toolExecutors.get(toolExecutionRequest.name());
                if (toolExecutor == null) {
                    return this.applyToolHallucinationStrategy(toolExecutionRequest);
                }
                return ToolService.executeWithErrorHandling(toolExecutionRequest, toolExecutor, memoryId, this.argumentsErrorHandler(), this.executionErrorHandler());
            }, this.executor);
            futures.put(toolExecutionRequest, future);
        }
        LinkedHashMap<ToolExecutionRequest, ToolExecutionResultMessage> results = new LinkedHashMap<ToolExecutionRequest, ToolExecutionResultMessage>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                results.put((ToolExecutionRequest)entry.getKey(), (ToolExecutionResultMessage)((CompletableFuture)entry.getValue()).get());
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)throwable;
                    throw re;
                }
                throw new RuntimeException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    private Map<ToolExecutionRequest, ToolExecutionResultMessage> executeSequentially(List<ToolExecutionRequest> toolExecutionRequests, Map<String, ToolExecutor> toolExecutors, Object memoryId) {
        LinkedHashMap<ToolExecutionRequest, ToolExecutionResultMessage> toolResults = new LinkedHashMap<ToolExecutionRequest, ToolExecutionResultMessage>();
        for (ToolExecutionRequest request : toolExecutionRequests) {
            ToolExecutor executor = toolExecutors.get(request.name());
            ToolExecutionResultMessage toolExecutionResultMessage = executor == null ? this.applyToolHallucinationStrategy(request) : ToolService.executeWithErrorHandling(request, executor, memoryId, this.argumentsErrorHandler(), this.executionErrorHandler());
            toolResults.put(request, toolExecutionResultMessage);
        }
        return toolResults;
    }

    public static ToolExecutionResultMessage executeWithErrorHandling(ToolExecutionRequest toolRequest, ToolExecutor executor, Object memoryId, ToolArgumentsErrorHandler argumentsErrorHandler, ToolExecutionErrorHandler executionErrorHandler) {
        String toolResult;
        try {
            toolResult = executor.execute(toolRequest, memoryId);
        }
        catch (Exception e) {
            ToolErrorContext errorContext = ToolErrorContext.builder().toolExecutionRequest(toolRequest).memoryId(memoryId).build();
            ToolErrorHandlerResult errorHandlerResult = e instanceof ToolArgumentsException ? argumentsErrorHandler.handle(e.getCause(), errorContext) : executionErrorHandler.handle(e.getCause(), errorContext);
            toolResult = errorHandlerResult.text();
        }
        return ToolExecutionResultMessage.from((ToolExecutionRequest)toolRequest, (String)toolResult);
    }

    public ToolExecutionResultMessage applyToolHallucinationStrategy(ToolExecutionRequest toolExecutionRequest) {
        return this.toolHallucinationStrategy.apply(toolExecutionRequest);
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> toolExecutors() {
        return this.toolExecutors;
    }

    public Executor executor() {
        return this.executor;
    }

    public ToolProvider toolProvider() {
        return this.toolProvider;
    }

    public boolean isImmediateTool(String toolName) {
        return this.immediateReturnTools.contains(toolName);
    }
}

