/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.HashMap;
import java.util.Map;

public class ToolProviderResult {
    private final Map<ToolSpecification, ToolExecutor> tools;
    private final Map<String, ToolSpecification> toolsByName;

    public ToolProviderResult(Map<ToolSpecification, ToolExecutor> tools) {
        this(tools, ToolProviderResult.indexTools(tools));
    }

    private ToolProviderResult(Map<ToolSpecification, ToolExecutor> tools, Map<String, ToolSpecification> toolsByName) {
        this.tools = Utils.copy(tools);
        this.toolsByName = Utils.copy(toolsByName);
    }

    private static Map<String, ToolSpecification> indexTools(Map<ToolSpecification, ToolExecutor> tools) {
        HashMap<String, ToolSpecification> toolsByName = new HashMap<String, ToolSpecification>();
        tools.keySet().forEach(toolSpecification -> {
            if (toolsByName.putIfAbsent(toolSpecification.name(), (ToolSpecification)toolSpecification) != null) {
                throw new IllegalConfigurationException("Duplicated definition for tool: " + toolSpecification.name());
            }
        });
        return toolsByName;
    }

    public ToolSpecification toolSpecificationByName(String name) {
        return this.toolsByName.get(name);
    }

    public ToolExecutor toolExecutorByName(String name) {
        ToolSpecification toolSpecification = this.toolSpecificationByName(name);
        return toolSpecification == null ? null : this.tools.get(toolSpecification);
    }

    public Map<ToolSpecification, ToolExecutor> tools() {
        return this.tools;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<ToolSpecification, ToolExecutor> tools = new HashMap<ToolSpecification, ToolExecutor>();
        private final Map<String, ToolSpecification> toolsByName = new HashMap<String, ToolSpecification>();

        public Builder add(ToolSpecification tool, ToolExecutor executor) {
            this.tools.put(tool, executor);
            if (this.toolsByName.putIfAbsent(tool.name(), tool) != null) {
                throw new IllegalConfigurationException("Duplicated definition for tool: " + tool.name());
            }
            return this;
        }

        public Builder addAll(Map<ToolSpecification, ToolExecutor> tools) {
            tools.forEach(this::add);
            return this;
        }

        public ToolProviderResult build() {
            return new ToolProviderResult(this.tools, this.toolsByName);
        }
    }
}

