/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class ToolErrorContext {
    private final ToolExecutionRequest toolExecutionRequest;
    private final Object memoryId;

    public ToolErrorContext(Builder builder) {
        this.toolExecutionRequest = (ToolExecutionRequest)ValidationUtils.ensureNotNull((Object)builder.toolExecutionRequest, (String)"toolExecutionRequest");
        this.memoryId = builder.memoryId;
    }

    public ToolExecutionRequest toolExecutionRequest() {
        return this.toolExecutionRequest;
    }

    public Object memoryId() {
        return this.memoryId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToolErrorContext that = (ToolErrorContext)object;
        return Objects.equals(this.toolExecutionRequest, that.toolExecutionRequest) && Objects.equals(this.memoryId, that.memoryId);
    }

    public int hashCode() {
        return Objects.hash(this.toolExecutionRequest, this.memoryId);
    }

    public String toString() {
        return "ToolErrorContext{toolExecutionRequest=" + String.valueOf(this.toolExecutionRequest) + ", memoryId=" + String.valueOf(this.memoryId) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ToolExecutionRequest toolExecutionRequest;
        private Object memoryId;

        public Builder toolExecutionRequest(ToolExecutionRequest toolExecutionRequest) {
            this.toolExecutionRequest = toolExecutionRequest;
            return this;
        }

        public Builder memoryId(Object memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public ToolErrorContext build() {
            return new ToolErrorContext(this);
        }
    }
}

