/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.base;

import de.odysseus.staxon.base.XMLStreamWriterScope;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractXMLStreamWriter<T>
implements XMLStreamWriter {
    private final Map<String, String> repairingNamespaces;
    private XMLStreamWriterScope<T> scope;
    private boolean startDocumentWritten;

    public AbstractXMLStreamWriter(T rootInfo, boolean repairingNamespaces) {
        this(rootInfo, repairingNamespaces ? Collections.emptyMap() : null);
    }

    public AbstractXMLStreamWriter(T rootInfo, Map<String, String> repairingNamespaces) {
        this.scope = new XMLStreamWriterScope<T>("", rootInfo);
        this.repairingNamespaces = repairingNamespaces;
        this.startDocumentWritten = false;
    }

    private void ensureStartTagClosed() throws XMLStreamException {
        if (!this.scope.isStartTagClosed()) {
            String namespaceURI;
            if (this.repairingNamespaces != null && !"".equals(namespaceURI = this.getScope().getNamespaceURI())) {
                String prefix = this.getScope().getPrefix();
                if (!namespaceURI.equals(this.getScope().getNamespaceURI(prefix))) {
                    this.writeNamespace(prefix, namespaceURI);
                }
            }
            this.writeStartElementTagEnd();
            this.scope.setStartTagClosed(true);
            if (this.scope.isEmptyElement()) {
                this.scope = this.scope.getParent();
            }
        }
    }

    private void writeStartElement(String prefix, String localPart, String namespaceURI, boolean emptyElement) throws XMLStreamException {
        if (localPart == null) {
            throw new XMLStreamException("Local name must not be null");
        }
        boolean writeNamespace = false;
        if (prefix == null) {
            if (this.repairingNamespaces != null) {
                prefix = this.repairingNamespaces.get(namespaceURI);
                if (prefix == null) {
                    if ("".equals(this.getScope().getNamespaceURI(""))) {
                        prefix = "";
                    } else {
                        int index = 1;
                        while (this.getScope().getNamespaceURI("ns" + index) == null) {
                            ++index;
                        }
                        prefix = index == 1 ? "ns" : "ns" + index;
                    }
                }
                writeNamespace = true;
            } else {
                throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
            }
        }
        this.ensureStartTagClosed();
        T scopeInfo = this.writeStartElementTag(prefix, localPart, namespaceURI);
        this.scope = new XMLStreamWriterScope<T>(this.scope, prefix, localPart, namespaceURI, emptyElement);
        this.scope.setInfo(scopeInfo);
        if (writeNamespace) {
            this.writeNamespace(prefix, namespaceURI);
        }
    }

    protected XMLStreamWriterScope<T> getScope() {
        return this.scope;
    }

    protected boolean isStartDocumentWritten() {
        return this.startDocumentWritten;
    }

    protected abstract T writeStartElementTag(String var1, String var2, String var3) throws XMLStreamException;

    protected abstract void writeStartElementTagEnd() throws XMLStreamException;

    protected abstract void writeEndElementTag() throws XMLStreamException;

    protected abstract void writeAttr(String var1, String var2, String var3, String var4) throws XMLStreamException;

    protected abstract void writeNsDecl(String var1, String var2) throws XMLStreamException;

    protected abstract void writeData(Object var1, int var2) throws XMLStreamException;

    protected abstract void writePI(String var1, String var2) throws XMLStreamException;

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        String namespaceURI = this.scope.getNamespaceURI("");
        if (namespaceURI == null) {
            throw new XMLStreamException("Default namespace URI has not been set");
        }
        this.writeStartElement("", localName, namespaceURI, false);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        String prefix = this.scope.getPrefix(namespaceURI);
        if (prefix == null && this.repairingNamespaces == null) {
            throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
        }
        this.writeStartElement(prefix, localName, namespaceURI, false);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (prefix == null) {
            throw new XMLStreamException("Prefix must not be null");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        this.writeStartElement(prefix, localName, namespaceURI, false);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.ensureStartTagClosed();
        if (this.scope.isRoot()) {
            throw new XMLStreamException("Cannot write end element in root scope");
        }
        this.writeEndElementTag();
        this.scope = this.scope.getParent();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        String namespaceURI = this.scope.getNamespaceURI("");
        if (namespaceURI == null) {
            throw new XMLStreamException("Default namespace URI has not been set");
        }
        this.writeStartElement("", localName, namespaceURI, true);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        String prefix = this.scope.getPrefix(namespaceURI);
        if (prefix == null && this.repairingNamespaces == null) {
            throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
        }
        this.writeStartElement(prefix, localName, namespaceURI, true);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (prefix == null) {
            throw new XMLStreamException("Prefix must not be null");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        this.writeStartElement(prefix, localName, namespaceURI, true);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, "", localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.scope.isStartTagClosed()) {
            throw new XMLStreamException("Cannot write attribute: element has children or text");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        if ("".equals(namespaceURI)) {
            if (prefix == null) {
                prefix = "";
            } else if (!"".equals(prefix)) {
                throw new XMLStreamException("Cannot write prefixed attribute without a namespace URI: " + prefix);
            }
        } else if (prefix == null) {
            prefix = this.scope.getNonEmptyPrefix(namespaceURI);
            if (prefix == null) {
                throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
            }
        } else if ("".equals(prefix)) {
            throw new XMLStreamException("Cannot write attribute without prefix for namespace URI: " + namespaceURI);
        }
        this.scope.addAttribute(prefix, localName, namespaceURI, value);
        this.writeAttr(prefix, localName, namespaceURI, value);
    }

    protected final void writeCharacters(Object data, int type) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeData(data, type);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writeCharacters(text, 4);
    }

    @Override
    public void writeCharacters(char[] text, int start, int length) throws XMLStreamException {
        this.writeCharacters(new String(text, start, length));
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writeCharacters(data, 12);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("UTF-8", null);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.startDocumentWritten || !this.scope.isRoot()) {
            throw new XMLStreamException("Cannot start document");
        }
        if (version == null) {
            version = "1.0";
        }
        if (encoding == null) {
            this.writePI("xml", String.format("version=\"%s\"", version));
        } else {
            this.writePI("xml", String.format("version=\"%s\" encoding=\"%s\"", version, encoding));
        }
        this.startDocumentWritten = true;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (!this.startDocumentWritten) {
            throw new XMLStreamException("Cannot end document");
        }
        if (!this.scope.isRoot()) {
            this.ensureStartTagClosed();
            while (!this.scope.isRoot()) {
                this.writeEndElement();
            }
        }
        this.startDocumentWritten = false;
    }

    @Override
    public void close() throws XMLStreamException {
        this.ensureStartTagClosed();
        this.flush();
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.scope.isStartTagClosed()) {
            throw new XMLStreamException("Cannot write namespace: element has children or text");
        }
        this.writeNsDecl(prefix, namespaceURI);
        this.scope.setPrefix(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writeNamespace("", namespaceURI);
    }

    @Override
    public String getPrefix(String namespaceURI) throws XMLStreamException {
        return this.scope.getPrefix(namespaceURI);
    }

    @Override
    public void setPrefix(String prefix, String namespaceURI) throws XMLStreamException {
        this.scope.setPrefix(prefix, namespaceURI);
    }

    @Override
    public void setDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.setPrefix("", namespaceURI);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (!this.scope.isRoot()) {
            throw new XMLStreamException("This method may only be called once at the start of the document");
        }
        this.scope = new XMLStreamWriterScope<T>(context, this.scope.getInfo());
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.scope;
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeData(data, 5);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writePI(target, null);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writePI(target, data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeData(dtd, 11);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeData(name, 9);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unsupported property: " + name);
    }
}

