/*
 * Copyright 2011, 2012 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.odysseus.staxon.base;

/**
 * Object pair.
 * @param <F> first type
 * @param <S> second type
 */
class Pair<F, S> {
	private final F first;
	private final S second;
	
	/**
	 * Create a new pair instance.
	 * @param first first object
	 * @param second second object
	 */
	Pair(F first, S second) {
		this.first = first;
		this.second = second;
	}
	
	/**
	 * @return first object
	 */
	F getFirst() {
		return first;
	}
	
	/**
	 * @return second object
	 */
	S getSecond() {
		return second;
	}
	
	@Override
	public int hashCode() {
		return (first == null ? 0 : first.hashCode()) ^ (second == null ? 0 : second.hashCode());
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null || getClass() != obj.getClass()) {
			return false;
		}
		Pair<?, ?> other = (Pair<?, ?>) obj;
		if (first == null) {
			if (other.first != null) {
				return false;
			}
		} else if (!first.equals(other.first)) {
			return false;
		}
		if (second == null) {
			if (other.second != null) {
				return false;
			}
		} else if (!second.equals(other.second)) {
			return false;
		}
		return true;
	}
	
	@Override
	public String toString() {
		return "Pair(" + first + "," + second + ")";
	}
}
