/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.util.regex.Pattern;

public class XmlGrammar {
    public static final String RE_XML_NAME_START_CHAR = "(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])";
    public static final String RE_XML_NAME_CHAR = "(?:(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])|-|\\.|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])";
    public static final String RE_XML_NAME = "((?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])(?:(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])|-|\\.|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*)";
    public static final String RE_XML_ENTITY_REF = "(?:&((?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])(?:(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])|-|\\.|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*);)";
    public static final String RE_XML_CHAR_REF = "(?:&#([0-9]+);|&#x([0-9a-fA-F]+);)";
    public static final String RE_XML_REFERENCE = "(?:(?:&((?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])(?:(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])|-|\\.|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*);)|(?:&#([0-9]+);|&#x([0-9a-fA-F]+);))";
    public static final String RE_XML_CHAR = "(?:[\\u0009\\u000A\\u000D\\u0020-\\uD7FF]|[\\uE000-\\uFFFD]|[\ud800\udc00-\udbff\udfff])";
    private static final String RE_XML_COMMENT_TEXT = "((?:(?!-)(?:[\\u0009\\u000A\\u000D\\u0020-\\uD7FF]|[\\uE000-\\uFFFD]|[\ud800\udc00-\udbff\udfff])|-(?!-)(?:[\\u0009\\u000A\\u000D\\u0020-\\uD7FF]|[\\uE000-\\uFFFD]|[\ud800\udc00-\udbff\udfff]))*)";
    private static Pattern xmlName = null;
    private static Pattern xmlReference = null;
    private static Pattern xmlCommentText = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern xmlName() {
        if (xmlName != null) return xmlName;
        Class<XmlGrammar> clazz = XmlGrammar.class;
        synchronized (XmlGrammar.class) {
            if (xmlName != null) return xmlName;
            xmlName = Pattern.compile(RE_XML_NAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmlName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern xmlReference() {
        if (xmlReference != null) return xmlReference;
        Class<XmlGrammar> clazz = XmlGrammar.class;
        synchronized (XmlGrammar.class) {
            if (xmlReference != null) return xmlReference;
            xmlReference = Pattern.compile(RE_XML_REFERENCE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmlReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pattern xmlCommentText() {
        if (xmlCommentText != null) return xmlCommentText;
        Class<XmlGrammar> clazz = XmlGrammar.class;
        synchronized (XmlGrammar.class) {
            if (xmlCommentText != null) return xmlCommentText;
            xmlCommentText = Pattern.compile(RE_XML_COMMENT_TEXT);
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmlCommentText;
        }
    }

    public static boolean isChar(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint >= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static boolean isNameStartChar(int codePoint) {
        return codePoint == 58 || codePoint == 95 || codePoint >= 65 && codePoint <= 90 || codePoint >= 97 && codePoint <= 122 || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    public static boolean isNameChar(int codePoint) {
        return XmlGrammar.isNameStartChar(codePoint) || codePoint == 45 || codePoint == 46 || codePoint >= 48 && codePoint <= 57 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }
}

