/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingBuffer<T>
implements Iterable<T> {
    private final T[] buffer;
    private int fill = 0;
    private int start = 0;

    public RingBuffer(int capacity) {
        this.buffer = new Object[capacity];
    }

    public void add(T x) {
        this.buffer[(this.start + this.fill) % this.buffer.length] = x;
        if (this.willOverwrite()) {
            ++this.start;
            this.start %= this.buffer.length;
        } else {
            ++this.fill;
        }
    }

    public boolean willOverwrite() {
        return this.fill == this.buffer.length;
    }

    public T getOldest() {
        if (this.fill == 0) {
            throw new UnsupportedOperationException();
        }
        return this.buffer[this.start];
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < RingBuffer.this.fill;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RingBuffer.this.buffer[(RingBuffer.this.start + this.i++) % RingBuffer.this.buffer.length];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.fill;
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    public void clear() {
        this.start = 0;
        this.fill = 0;
    }
}

