/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.RingBuffer;

public class MovingAverage {
    private int movingAvgBucketSizeMs;
    private boolean firstUpdateValid = false;
    private long firstUpdate = 0L;
    private int firstBucket = 0;
    private long currentBucketSum = 0L;
    private long currentBucketCount = 0L;
    private final RingBuffer<Double> buffer;
    private double bufferSum = 0.0;
    private long bufferCount = 0L;

    public MovingAverage(int movingAvgWindowMs, int movingAvgBucketSizeMs) {
        this.movingAvgBucketSizeMs = movingAvgBucketSizeMs;
        this.buffer = new RingBuffer(movingAvgWindowMs / movingAvgBucketSizeMs);
    }

    public static long startTimeNs() {
        return System.nanoTime();
    }

    public void stopTime(long startTimeNs) {
        long now = System.nanoTime();
        this.update(now, this.delta(startTimeNs, now));
    }

    public double stopTime(long startTimeNs, double factor) {
        long now = System.nanoTime();
        double delta = (double)this.delta(startTimeNs, now) * factor;
        this.update(now, (long)delta);
        return delta / 1000000.0;
    }

    public double getAverageInSec() {
        return this.getAverage() / 1.0E9;
    }

    public synchronized double getAverage() {
        long count = this.bufferCount;
        double sum = this.bufferSum;
        if (this.currentBucketCount > 0L) {
            sum += (double)this.currentBucketSum / (double)this.currentBucketCount;
            ++count;
        }
        if (count == 0L) {
            return 0.0;
        }
        return sum / (double)count;
    }

    public synchronized void update(long nowNs, long value) {
        if (this.firstUpdateValid) {
            long sinceFirstUpdate = this.delta(this.firstUpdate, nowNs) / 1000000L;
            int bucket = (int)(sinceFirstUpdate / (long)this.movingAvgBucketSizeMs);
            int advance = bucket - this.firstBucket;
            if (advance > this.buffer.getCapacity()) {
                this.reset();
            } else if (advance > 0) {
                this.firstBucket += advance;
                if (this.currentBucketCount > 0L) {
                    this.nextBucket((double)this.currentBucketSum / (double)this.currentBucketCount);
                    --advance;
                    this.currentBucketSum = 0L;
                    this.currentBucketCount = 0L;
                }
                for (int i = 0; i < advance; ++i) {
                    this.nextBucket(null);
                }
            }
        } else {
            this.firstUpdate = nowNs;
            this.firstUpdateValid = true;
        }
        this.currentBucketSum += value;
        ++this.currentBucketCount;
    }

    public synchronized void reset() {
        this.buffer.clear();
        this.bufferSum = 0.0;
        this.bufferCount = 0L;
        this.currentBucketSum = 0L;
        this.currentBucketCount = 0L;
        this.firstUpdateValid = false;
        this.firstBucket = 0;
    }

    private void nextBucket(Double average) {
        Double oldest = null;
        if (this.buffer.willOverwrite()) {
            oldest = this.buffer.getOldest();
        }
        this.buffer.add(average);
        if (average != null) {
            this.bufferSum += average.doubleValue();
            ++this.bufferCount;
        }
        if (oldest != null) {
            this.bufferSum -= oldest.doubleValue();
            --this.bufferCount;
        }
    }

    private long delta(long startTime, long now) {
        return now - startTime;
    }
}

