/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.comparer;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.comparer.AstComparisonException;
import de.fau.cs.osr.utils.StringTools;
import java.io.IOException;
import java.io.Writer;

public class DeepComparisonException
extends AstComparisonException {
    private static final long serialVersionUID = 1L;
    private final Object a;
    private final Object b;

    public DeepComparisonException(Object a, Object b) {
        this.a = a;
        this.b = b;
    }

    public DeepComparisonException(AstComparisonException e, AstNode<?> a, AstNode<?> b) {
        super(e);
        this.a = a;
        this.b = b;
    }

    public Object getObjectA() {
        return this.a;
    }

    public Object getObjectB() {
        return this.b;
    }

    @Override
    public Writer toString(Writer w) throws IOException {
        if (this.getCause() != null) {
            ((AstComparisonException)((Object)this.getCause())).toString(w);
        }
        w.append(String.format("Values during deep comparison differed (%s vs. %s):\n", this.a == null ? "-" : this.a.getClass().getName(), this.b == null ? "-" : this.b.getClass().getName()));
        this.printValue("a", this.a, w);
        this.printValue("b", this.b, w);
        return w;
    }

    private void printValue(String which, Object value, Writer w) throws IOException {
        w.append("\t");
        w.append(which);
        w.append(": ");
        if (value == null) {
            w.append("null\n");
        } else {
            w.append("\"\"\"");
            w.append(StringTools.escJava((String)value.toString()));
            w.append("\"\"\"\n");
        }
    }
}

