/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodeList;
import de.fau.cs.osr.ptk.common.ast.AstParserEntity;
import de.fau.cs.osr.ptk.common.ast.AstText;
import de.fau.cs.osr.utils.visitor.VisitingException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class NodeTypeAstVisitor<T extends AstNode<T>> {
    public static final Object REMOVE = new Object();

    public Object go(T node) {
        return this.dispatch(node);
    }

    protected final Object dispatch(T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        try {
            return this.resolveAndVisit(node, node.getNodeType());
        }
        catch (VisitingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitingException(node, (Throwable)e);
        }
    }

    protected final void iterate(T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        for (AstNode n : node) {
            this.dispatch(n);
        }
    }

    protected final List<Object> map(T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        ArrayList<Object> result = new ArrayList<Object>(node.size());
        for (AstNode n : node) {
            result.add(this.dispatch(n));
        }
        return result;
    }

    protected final void mapInPlace(T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node.isList()) {
            ListIterator i = node.listIterator();
            while (i.hasNext()) {
                AstNode current = (AstNode)i.next();
                Object result = this.dispatch(current);
                if (result == null) {
                    throw new NullPointerException();
                }
                if (result == REMOVE) {
                    i.remove();
                    continue;
                }
                if (result == current) continue;
                AstNode resultNode = (AstNode)result;
                if (resultNode.getNodeType() == 2) {
                    i.remove();
                    i.add(resultNode);
                    continue;
                }
                i.set(resultNode);
            }
        } else {
            ListIterator i = node.listIterator();
            while (i.hasNext()) {
                AstNode current = (AstNode)i.next();
                AstNode result = (AstNode)this.dispatch(current);
                if (result == current) continue;
                i.set(result);
            }
        }
    }

    protected Object resolveAndVisit(T node, int type) throws Exception {
        switch (type) {
            case 4097: {
                return this.visit((AstText)node);
            }
            case 2: {
                return this.visit((AstNodeList)node);
            }
            case 5: {
                return this.visit((AstParserEntity)node);
            }
        }
        return this.visitUnspecific((AstNode<T>)node);
    }

    protected Object visitUnspecific(AstNode<T> node) throws Exception {
        return node;
    }

    protected Object visit(AstText<T> node) throws Exception {
        return this.visitUnspecific(node);
    }

    protected Object visit(AstNodeList<T> node) throws Exception {
        return this.visitUnspecific(node);
    }

    protected Object visit(AstParserEntity<T> node) throws Exception {
        return this.visitUnspecific(node);
    }
}

