/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.jdbc.PgConnection;
import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class TopologyAwareLoadBalancer
extends ClusterAwareLoadBalancer {
    private final String placements;
    private final Set<CloudPlacement> allowedPlacements;

    public TopologyAwareLoadBalancer(String placementvalues) {
        this.placements = placementvalues;
        this.allowedPlacements = new HashSet<CloudPlacement>();
        this.populatePlacementSet();
    }

    @Override
    protected String loadBalancingNodes() {
        return this.placements;
    }

    private void populatePlacementSet() {
        String[] placementstrings;
        for (String pl : placementstrings = this.placements.split(",")) {
            String[] placementParts = pl.split("\\.");
            if (placementParts.length != 3) {
                LOGGER.log(Level.WARNING, this.getLoadBalancerType() + ": Ignoring malformed topology-key property value: " + pl);
                continue;
            }
            CloudPlacement cp = new CloudPlacement(placementParts[0], placementParts[1], placementParts[2]);
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Adding placement " + cp + " to allowed list");
            this.allowedPlacements.add(cp);
        }
    }

    @Override
    protected ArrayList<String> getCurrentServers(Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Getting the list of servers in: " + this.placements);
        ResultSet rs = st.executeQuery("select * from yb_servers()");
        ArrayList<String> currentPrivateIps = new ArrayList<String>();
        ArrayList<String> currentPublicIps = new ArrayList<String>();
        String hostConnectedTo = ((PgConnection)conn).getQueryExecutor().getHostSpec().getHost();
        Boolean useHostColumn = null;
        while (rs.next()) {
            String host = rs.getString("host");
            String publicIp = rs.getString("public_ip");
            String cloud = rs.getString("cloud");
            String region = rs.getString("region");
            String zone = rs.getString("zone");
            String port = rs.getString("port");
            this.hostPortMap.put(host, port);
            this.hostPortMapPublic.put(publicIp, port);
            if (hostConnectedTo.equals(host)) {
                useHostColumn = Boolean.TRUE;
            } else if (hostConnectedTo.equals(publicIp)) {
                useHostColumn = Boolean.FALSE;
            }
            CloudPlacement cp = new CloudPlacement(cloud, region, zone);
            if (this.allowedPlacements.contains(cp)) {
                LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": allowedPlacements set: " + this.allowedPlacements + " returned contains true for cp: " + cp);
                currentPrivateIps.add(host);
                currentPublicIps.add(publicIp);
                continue;
            }
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": allowedPlacements set: " + this.allowedPlacements + " returned contains false for cp: " + cp);
        }
        return this.getPrivateOrPublicServers(useHostColumn, currentPrivateIps, currentPublicIps);
    }

    @Override
    protected String getLoadBalancerType() {
        return "TopologyAwareLoadBalancer";
    }

    static class CloudPlacement {
        private final String cloud;
        private final String region;
        private final String zone;

        CloudPlacement(String cloud, String region, String zone) {
            this.cloud = cloud;
            this.region = region;
            this.zone = zone;
        }

        public int hashCode() {
            return this.cloud.hashCode() ^ this.region.hashCode() ^ this.zone.hashCode();
        }

        public boolean equals(Object other) {
            boolean equal = false;
            ClusterAwareLoadBalancer.LOGGER.log(Level.FINE, "equals called for this: " + this + " and other = " + other);
            if (other instanceof CloudPlacement) {
                CloudPlacement o = (CloudPlacement)other;
                equal = this.cloud.equalsIgnoreCase(o.cloud) && this.region.equalsIgnoreCase(o.region) && this.zone.equalsIgnoreCase(o.zone);
            }
            ClusterAwareLoadBalancer.LOGGER.log(Level.FINE, "equals returning: " + equal);
            return equal;
        }

        public String toString() {
            return "Placement: " + this.cloud + "." + this.region + "." + this.zone;
        }
    }
}

