/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.httpclient;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.spring.TLogSpringAware;
import com.yomahub.tlog.utils.LocalhostUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogHttpClient5Interceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TLogHttpClient5Interceptor.class);

    public void process(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            request.addHeader("tlogTraceId", (Object)traceId);
            request.addHeader("tlogSpanId", (Object)SpanIdGenerator.generateNextSpanId());
            request.addHeader("preIvkApp", (Object)appName);
            request.addHeader("preIvkHost", (Object)LocalhostUtil.getHostName());
            request.addHeader("preIp", (Object)LocalhostUtil.getHostIp());
        } else {
            log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
    }
}

