/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.utils;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public final class Base64ToImage {
    private static final Logger log = LoggerFactory.getLogger(Base64ToImage.class);

    public static String imageToBase64ByLocal(String imgFile) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            log.info("\u672c\u5730\u56fe\u7247\u8f6c\u6362\u6210base64\u5b57\u7b26\u4e32\u53d1\u751f\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
        }
        return Base64Utils.encodeToString((byte[])data);
    }

    public static String imageToBase64ByOnline(String imgUrl) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            URL url = new URL(imgUrl);
            byte[] by = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            log.info("\u5728\u7ebf\u56fe\u7247\u8f6c\u6362\u6210base64\u5b57\u7b26\u4e32\u53d1\u751f\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
        }
        return Base64Utils.encodeToString((byte[])data.toByteArray());
    }

    public static synchronized boolean base64ToImage(String imgStr, String imgFilePath) {
        if (StringUtils.isEmpty((CharSequence)imgStr)) {
            return false;
        }
        try {
            byte[] b = Base64Utils.decodeFromString((String)imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            log.info("\u5728base64\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u56fe\u7247\u53d1\u751f\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
            return false;
        }
    }
}

