/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.image;

import com.yishuifengxiao.common.tool.image.entity.ImageMeta;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.springframework.util.Assert;

public class ImageProcessor {
    public OutputStream convert2Stream(ImageMeta imageMeta) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.convert2Image(imageMeta), "jpg", outputStream);
        return outputStream;
    }

    public BufferedImage convert2Image(ImageMeta imageMeta) throws IOException {
        Assert.notNull((Object)imageMeta, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        BufferedImage image = new BufferedImage(imageMeta.getImageWidth(), imageMeta.getImageHeight(), 1);
        BufferedImage src = ImageIO.read(imageMeta.getInputStream());
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, imageMeta.getImageWidth() + imageMeta.getCompensateWidth(), imageMeta.getImageHeight() + imageMeta.getCompensateHeight(), null);
        if (imageMeta.getFileMetas() != null) {
            imageMeta.getFileMetas().parallelStream().filter(t -> t != null).forEach(t -> {
                if (t.onlyText().booleanValue()) {
                    g.setColor(t.getColor());
                    g.setFont(t.getFont());
                    g.drawString(t.getText(), t.getxPoint(), t.getyPoint());
                } else {
                    g.drawImage(image, t.getxPoint(), t.getyPoint(), t.getFillWidth(), t.getFillHeight(), null);
                }
            });
        }
        g.dispose();
        return image;
    }
}

