/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.collections;

import com.yishuifengxiao.common.tool.collections.EmptyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CollectionUtil {
    public static <T> List<T> toList(T[] objs) {
        if (EmptyUtil.isEmpty(objs)) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : objs) {
            list.add(t);
        }
        return list;
    }

    public static <T> Set<T> toSet(T[] objs) {
        if (EmptyUtil.isEmpty(objs)) {
            return null;
        }
        HashSet<T> set = new HashSet<T>();
        for (T t : objs) {
            set.add(t);
        }
        return set;
    }

    public static <T> T first(List<T> data) {
        if (data == null || data.size() == 0) {
            return null;
        }
        return data.get(0);
    }

    public static <T> T first(Set<T> data) {
        if (data == null || data.size() == 0) {
            return null;
        }
        Iterator<T> it = data.iterator();
        return it.next();
    }

    public static <T> T first(T[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return data[0];
    }

    public static <T> T first(Collection<T> data) {
        if (data == null || data.size() == 0) {
            return null;
        }
        Iterator<T> it = data.iterator();
        return it.next();
    }
}

