/*
 * Decompiled with CFR 0.152.
 */
package com.yishuifengxiao.common.tool.bean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public final class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static <S, T> T copy(S source, T target) {
        if (source == null || target == null) {
            return null;
        }
        BeanUtils.copyProperties(source, target);
        return target;
    }

    public static <T> T setNullValue(T source) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields;
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (!"class java.lang.String".equals(field.getGenericType().toString())) continue;
            field.setAccessible(true);
            Object obj = field.get(source);
            if (obj != null && obj.equals("")) {
                field.set(source, null);
                continue;
            }
            if (obj == null) continue;
            field.set(source, StringEscapeUtils.escapeJava((String)obj.toString()).replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)").replace("%", "\\%").replace("*", "\\*").replace("[", "\\[").replace("]", "\\]").replace("|", "\\|").replace(".", "\\.").replace("$", "\\$").replace("+", "\\+").trim());
        }
        return source;
    }

    public static byte[] objectToByte(Object obj) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            bytes = bo.toByteArray();
            bo.close();
            oo.close();
        }
        catch (Exception e) {
            log.info(" \u5bf9\u8c61\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
        }
        return bytes;
    }

    public static Object byteToObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bi);
            obj = oi.readObject();
            bi.close();
            oi.close();
        }
        catch (Exception e) {
            log.info("\u5bf9\u8c61\u53cd\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
        }
        return obj;
    }

    public static <T> T byteToObject(T t, byte[] bytes) {
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bi);
            t = oi.readObject();
            bi.close();
            oi.close();
        }
        catch (Exception e) {
            log.info(" \u5bf9\u8c61\u53cd\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
        }
        return t;
    }
}

