/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.http.http;

import com.xxl.tool.core.AssertTool;
import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.MapTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.http.HttpTool;
import com.xxl.tool.http.http.HttpResponse;
import com.xxl.tool.http.http.enums.ContentType;
import com.xxl.tool.http.http.enums.Header;
import com.xxl.tool.http.http.enums.Method;
import com.xxl.tool.http.http.iface.HttpInterceptor;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    private String url;
    private Method method = Method.POST;
    private ContentType contentType = ContentType.JSON;
    private Map<String, String> headers;
    private Map<String, String> cookies;
    private int connectTimeout = 3000;
    private int readTimeout = 3000;
    private boolean useCaches = false;
    private String body;
    private Map<String, String> form;
    private String auth;
    private List<HttpInterceptor> interceptors;
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};

    public HttpRequest url(String url) {
        this.url = url;
        return this;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequest contentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public HttpRequest header(Map<String, String> header) {
        if (MapTool.isEmpty(header)) {
            return this;
        }
        if (MapTool.isNotEmpty(this.headers)) {
            this.headers.clear();
        }
        for (String key : header.keySet()) {
            this.header(key, header.get(key));
        }
        return this;
    }

    public HttpRequest header(String key, String value) {
        if (StringTool.isBlank(key) || Objects.isNull(value)) {
            return this;
        }
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpRequest cookie(Map<String, String> cookie) {
        if (MapTool.isEmpty(cookie)) {
            return this;
        }
        if (MapTool.isNotEmpty(this.cookies)) {
            this.cookies.clear();
        }
        for (String key : cookie.keySet()) {
            this.cookie(key, cookie.get(key));
        }
        return this;
    }

    public HttpRequest cookie(String key, String value) {
        if (StringTool.isBlank(key) || Objects.isNull(value)) {
            return this;
        }
        if (null == this.cookies) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(key, value);
        return this;
    }

    public HttpRequest connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpRequest readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpRequest useCaches(boolean useCaches) {
        this.useCaches = useCaches;
        return this;
    }

    public HttpRequest body(String body) {
        this.body = body;
        return this;
    }

    public HttpRequest request(Object request) {
        if (Objects.nonNull(request)) {
            this.body = GsonTool.toJson(request);
        }
        return this;
    }

    public HttpRequest form(String key, String value) {
        if (StringTool.isBlank(key) || Objects.isNull(value)) {
            return this;
        }
        if (null == this.form) {
            this.form = new HashMap<String, String>();
        }
        this.form.put(key, value);
        return this;
    }

    public HttpRequest form(String key, List<String> value) {
        if (CollectionTool.isEmpty(value)) {
            return this;
        }
        return this.form(key, StringTool.join(value, ","));
    }

    public HttpRequest form(Map<String, String> form) {
        if (MapTool.isEmpty(form)) {
            return this;
        }
        if (MapTool.isNotEmpty(this.form)) {
            this.form.clear();
        }
        for (String key : form.keySet()) {
            this.form(key, form.get(key));
        }
        return this;
    }

    public HttpRequest auth(String auth) {
        this.auth = auth;
        return this;
    }

    public HttpRequest interceptor(List<HttpInterceptor> interceptors) {
        if (CollectionTool.isEmpty(interceptors)) {
            return this;
        }
        if (CollectionTool.isNotEmpty(this.interceptors)) {
            this.interceptors.clear();
        }
        for (HttpInterceptor interceptor : interceptors) {
            this.interceptor(interceptor);
        }
        return this;
    }

    public HttpRequest interceptor(HttpInterceptor interceptor) {
        if (Objects.isNull(interceptor)) {
            return this;
        }
        if (null == this.interceptors) {
            this.interceptors = new ArrayList<HttpInterceptor>();
        }
        this.interceptors.add(interceptor);
        return this;
    }

    public String getCookieString() {
        if (MapTool.isEmpty(this.cookies)) {
            return null;
        }
        StringBuilder cookieHeader = new StringBuilder();
        for (String key : this.cookies.keySet()) {
            if (!cookieHeader.isEmpty() && !cookieHeader.toString().endsWith("; ")) {
                cookieHeader.append("; ");
            }
            cookieHeader.append(key).append("=").append(this.cookies.get(key));
        }
        return cookieHeader.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public Method getMethod() {
        return this.method;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeader() {
        return this.headers;
    }

    public Map<String, String> getCookie() {
        return this.cookies;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getForm() {
        return this.form;
    }

    public String getAuth() {
        return this.auth;
    }

    public HttpResponse execute() {
        AssertTool.isTrue(StringTool.isNotBlank(this.url), "http-request url is null");
        AssertTool.isTrue(Objects.nonNull((Object)this.method), "http-request method is null");
        AssertTool.isTrue(Objects.nonNull((Object)this.contentType), "http-request contentType is null");
        HttpURLConnection connection = null;
        FilterOutputStream dataOutputStream = null;
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream;
            String formParam;
            if (CollectionTool.isNotEmpty(this.interceptors)) {
                for (HttpInterceptor interceptor : this.interceptors) {
                    interceptor.before(this);
                }
            }
            Object finalUrl = this.url;
            if (Method.GET == this.method && StringTool.isNotBlank(formParam = HttpTool.generateUrlParam(this.form))) {
                finalUrl = (String)finalUrl + (((String)finalUrl).contains("?") ? "&" : "?") + formParam;
            }
            URL finalUrlURL = new URL((String)finalUrl);
            connection = (HttpURLConnection)finalUrlURL.openConnection();
            if (HttpTool.isHttps((String)finalUrl)) {
                HttpsURLConnection https = (HttpsURLConnection)connection;
                this.trustAllHosts(https);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty(Header.CONNECTION.getValue(), "Keep-Alive");
            connection.setRequestProperty(Header.ACCEPT_CHARSET.getValue(), StandardCharsets.UTF_8.toString());
            connection.setRequestMethod(this.method.toString());
            connection.setRequestProperty(Header.CONTENT_TYPE.getValue(), this.contentType.getValue(StandardCharsets.UTF_8));
            connection.setReadTimeout(this.readTimeout);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setUseCaches(this.useCaches);
            if (MapTool.isNotEmpty(this.headers)) {
                for (String key : this.headers.keySet()) {
                    connection.setRequestProperty(key, this.headers.get(key));
                }
            }
            if (MapTool.isNotEmpty(this.cookies)) {
                String cookieString = this.getCookieString();
                connection.setRequestProperty(Header.COOKIE.getValue(), cookieString);
            }
            if (StringTool.isNotBlank(this.auth)) {
                connection.setRequestProperty(Header.AUTHORIZATION.getValue(), this.auth);
            }
            connection.connect();
            if (Method.GET != this.method) {
                String requestBody = null;
                if (StringTool.isNotBlank(this.body)) {
                    requestBody = this.body;
                } else if (MapTool.isNotEmpty(this.form)) {
                    requestBody = HttpTool.generateUrlParam(this.form);
                }
                if (StringTool.isNotBlank(requestBody)) {
                    dataOutputStream = new DataOutputStream(connection.getOutputStream());
                    dataOutputStream.write(requestBody.getBytes(StandardCharsets.UTF_8));
                    ((DataOutputStream)dataOutputStream).flush();
                    dataOutputStream.close();
                }
            }
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.setUrl(this.url);
            httpResponse.setStatusCode(connection.getResponseCode());
            InputStream inputStream2 = inputStream = httpResponse.isSuccess() ? connection.getInputStream() : connection.getErrorStream();
            if (inputStream != null) {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                StringBuilder result = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                }
                String responseBody = result.toString();
                httpResponse.setResponse(responseBody);
            }
            Map<String, String> cookieMap = this.parseResponseCookieData(connection);
            httpResponse.setCookies(cookieMap);
            if (CollectionTool.isNotEmpty(this.interceptors)) {
                for (HttpInterceptor interceptor : this.interceptors) {
                    interceptor.after(this, httpResponse);
                }
            }
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            throw new RuntimeException("Http Request Error (" + e.getMessage() + "). for url : " + this.url, e);
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private Map<String, String> parseResponseCookieData(HttpURLConnection connection) {
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        List<String> setCookieHeaders = headerFields.get(Header.SET_COOKIE.getValue());
        if (CollectionTool.isEmpty(setCookieHeaders)) {
            return null;
        }
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        for (String setCookieHeader : setCookieHeaders) {
            String cookiePart;
            String[] cookieKeyValue;
            String[] parts = setCookieHeader.split(";");
            if (parts.length <= 0 || (cookieKeyValue = (cookiePart = parts[0]).split("=", 2)).length != 2) continue;
            cookieMap.put(cookieKeyValue[0], cookieKeyValue[1]);
        }
        return cookieMap;
    }

    private void trustAllHosts(HttpsURLConnection connection) {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        connection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
}

