/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.MapTool;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StringTool {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringTool.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !StringTool.isBlank(str);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringTool.trim(str);
        return StringTool.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int countMatches(String str, String sub) {
        if (StringTool.isEmpty(str) || StringTool.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String upperCaseFirst(String text) {
        if (StringTool.isBlank(text)) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    public static String lowerCaseFirst(String text) {
        if (StringTool.isBlank(text)) {
            return text;
        }
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    public static String underlineToCamelCase(String underscoreText) {
        if (StringTool.isBlank(underscoreText)) {
            return underscoreText;
        }
        StringBuilder result = new StringBuilder();
        boolean flag = false;
        for (int i = 0; i < underscoreText.length(); ++i) {
            char ch = underscoreText.charAt(i);
            if ("_".charAt(0) == ch) {
                flag = true;
                continue;
            }
            if (flag) {
                result.append(Character.toUpperCase(ch));
                flag = false;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        return str.substring(start, end);
    }

    public static List<String> split(String str, String separator) {
        return StringTool.split(str, separator, true, true);
    }

    public static List<String> split(String str, String separator, boolean trimTokens, boolean ignoreBlackTokens) {
        if (StringTool.isBlank(str)) {
            return null;
        }
        if (StringTool.isBlank(separator)) {
            return List.of(str.trim());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String item : str.split(separator)) {
            if (trimTokens) {
                item = item.trim();
            }
            if (ignoreBlackTokens && StringTool.isBlank(item)) continue;
            list.add(item);
        }
        return list;
    }

    public static String join(List<String> list, String separator) {
        return StringTool.join(list, separator, true, true);
    }

    public static String join(List<String> list, String separator, boolean trimTokens, boolean ignoreBlackTokens) {
        if (CollectionTool.isEmpty(list)) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            String token;
            if (ignoreBlackTokens && StringTool.isBlank(item)) continue;
            String string = token = trimTokens ? item.trim() : item;
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(token);
        }
        return buf.toString();
    }

    public static String format(String template, Object ... params) {
        return MessageFormat.format(template, params);
    }

    public static String formatWithMap(String template, Map<String, Object> params) {
        if (StringTool.isBlank(template) || MapTool.isEmpty(params)) {
            return template;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            String oldPattern = "{" + entry.getKey() + "}";
            String newPattern = entry.getValue().toString();
            template = StringTool.replace(template, oldPattern, newPattern);
        }
        return template;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringTool.isEmpty(inString) || StringTool.isEmpty(oldPattern) || newPattern == null) {
            return inString;
        }
        return inString.replace(oldPattern, newPattern);
    }

    public static String removePrefix(String str, String prefix) {
        if (str == null || StringTool.isBlank(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (str == null || StringTool.isBlank(suffix)) {
            return str;
        }
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }
}

