/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.concurrent;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyclicThread {
    private static Logger logger = LoggerFactory.getLogger(CyclicThread.class);
    private final String name;
    private final boolean daemon;
    private final Runnable cyclicRunnable;
    private final long cyclicInterval;
    private final boolean alignTime;
    private volatile boolean isRunning = false;
    private final Object lock = new Object();
    private final Thread workerThread;

    public CyclicThread(String name, Runnable runnable, long cyclicInterval) {
        this(name, true, runnable, cyclicInterval, false);
    }

    public CyclicThread(String name, Runnable runnable, long cyclicInterval, boolean alignTime) {
        this(name, true, runnable, cyclicInterval, alignTime);
    }

    public CyclicThread(String name, boolean daemon, Runnable runnable, long cyclicInterval) {
        this(name, daemon, runnable, cyclicInterval, false);
    }

    public CyclicThread(String name, boolean daemon, Runnable runnable, long cyclicInterval, boolean alignTime) {
        this.name = name;
        this.daemon = daemon;
        this.cyclicRunnable = new CycleRunnable(runnable, this);
        this.cyclicInterval = cyclicInterval;
        this.alignTime = alignTime;
        this.isRunning = false;
        this.workerThread = new Thread(this.cyclicRunnable);
        this.workerThread.setDaemon(daemon);
        this.workerThread.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                this.isRunning = true;
                this.workerThread.start();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                this.isRunning = false;
                if (this.workerThread.getState() != Thread.State.TERMINATED) {
                    this.workerThread.interrupt();
                    try {
                        this.workerThread.join();
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
        }
    }

    private static class CycleRunnable
    implements Runnable {
        private final Runnable runnable;
        private final CyclicThread cyclicThread;

        public CycleRunnable(Runnable runnable, CyclicThread cyclicThread) {
            this.runnable = runnable;
            this.cyclicThread = cyclicThread;
        }

        @Override
        public void run() {
            logger.info(">>>>>>>>>>> CyclicThread[name = " + this.cyclicThread.name + "] start.");
            while (this.cyclicThread.isRunning) {
                block6: {
                    try {
                        this.runnable.run();
                    }
                    catch (Throwable e) {
                        if (!this.cyclicThread.isRunning) break block6;
                        logger.error(">>>>>>>>>>> CyclicThread[name = " + this.cyclicThread.name + "] run error:{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                if (!this.cyclicThread.isRunning) continue;
                try {
                    if (this.cyclicThread.alignTime) {
                        long startTime = System.currentTimeMillis();
                        TimeUnit.MILLISECONDS.sleep(this.cyclicThread.cyclicInterval - startTime % this.cyclicThread.cyclicInterval);
                        continue;
                    }
                    TimeUnit.MILLISECONDS.sleep(this.cyclicThread.cyclicInterval);
                }
                catch (Throwable e) {
                    if (!this.cyclicThread.isRunning) continue;
                    logger.error(">>>>>>>>>>> CyclicThread[name = " + this.cyclicThread.name + "] run error2:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            logger.info(">>>>>>>>>>> CyclicThread[name = " + this.cyclicThread.name + "] stop.");
        }
    }
}

