/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.captcha;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Kernel;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class CaptchaTool {
    private TextCreator textCreator = new DefaultTextCreator();
    private Integer width = 180;
    private Integer height = 60;
    private List<Color> colors = Arrays.asList(new Color(12073822), new Color(15764061), new Color(16751104), new Color(47273), new Color(19068), new Color(4031656), new Color(5378658));
    private Integer fontSize = 40;
    private List<Font> fonts = Arrays.asList(new Font("Arial", 1, 40), new Font("Courier", 1, 40));
    private Integer charSpace = 8;
    private Color backgroundColorFrom = Color.LIGHT_GRAY;
    private Color backgroundColorTo = Color.WHITE;
    private Boolean isBorderDrawn = false;
    private Color borderColor = Color.WHITE;
    private Integer borderThickness = 1;
    private Color noiseColor = Color.WHITE;
    private List<DistortedEngine> distortedEngines = Arrays.asList(new NoneDistorted(), new ShadowDistorted(), new WaterRippleDistorted(), new FishEyeDistorted(), new RippleDistorted());
    public static final String TEXT_NUMBER = "0123456789";
    public static final String TEXT_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String TEXT_NUMBER_AND_LOWERCASE = "0123456789abcdefghijklmnopqrstuvwxyz";

    public TextCreator getTextCreator() {
        return this.textCreator;
    }

    public CaptchaTool setTextCreator(TextCreator textCreator) {
        this.textCreator = textCreator;
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public CaptchaTool setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public CaptchaTool setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public CaptchaTool setColors(List<Color> colors) {
        this.colors = colors;
        return this;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public CaptchaTool setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public List<Font> getFonts() {
        return this.fonts;
    }

    public CaptchaTool setFonts(List<Font> fonts) {
        this.fonts = fonts;
        return this;
    }

    public Integer getCharSpace() {
        return this.charSpace;
    }

    public CaptchaTool setCharSpace(Integer charSpace) {
        this.charSpace = charSpace;
        return this;
    }

    public Color getBackgroundColorFrom() {
        return this.backgroundColorFrom;
    }

    public CaptchaTool setBackgroundColorFrom(Color backgroundColorFrom) {
        this.backgroundColorFrom = backgroundColorFrom;
        return this;
    }

    public Color getBackgroundColorTo() {
        return this.backgroundColorTo;
    }

    public CaptchaTool setBackgroundColorTo(Color backgroundColorTo) {
        this.backgroundColorTo = backgroundColorTo;
        return this;
    }

    public Boolean getIsBorderDrawn() {
        return this.isBorderDrawn;
    }

    public CaptchaTool setIsBorderDrawn(Boolean isBorderDrawn) {
        this.isBorderDrawn = isBorderDrawn;
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public CaptchaTool setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Integer getBorderThickness() {
        return this.borderThickness;
    }

    public CaptchaTool setBorderThickness(Integer borderThickness) {
        this.borderThickness = borderThickness;
        return this;
    }

    public Color getNoiseColor() {
        return this.noiseColor;
    }

    public CaptchaTool setNoiseColor(Color noiseColor) {
        this.noiseColor = noiseColor;
        return this;
    }

    public List<DistortedEngine> getDistortedEngines() {
        return this.distortedEngines;
    }

    public CaptchaTool setDistortedEngines(List<DistortedEngine> distortedEngines) {
        this.distortedEngines = distortedEngines;
        return this;
    }

    public static CaptchaTool build() {
        return new CaptchaTool();
    }

    public TextResult createText() {
        CaptchaTool.assertNotNull(this.textCreator, "textCreator is null");
        return this.textCreator.create();
    }

    public static void assertNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public BufferedImage createImage(TextResult textResult) {
        CaptchaTool.assertNotNull(textResult, "textResult is null");
        CaptchaTool.assertNotNull(this.width, "width is null");
        CaptchaTool.assertNotNull(this.height, "height is null");
        CaptchaTool.assertNotNull(this.backgroundColorFrom, "backgroundColorFrom is null");
        CaptchaTool.assertNotNull(this.backgroundColorTo, "backgroundColorTo is null");
        CaptchaTool.assertNotNull(this.colors, "color is null");
        CaptchaTool.assertNotNull(this.fontSize, "fontSize is null");
        CaptchaTool.assertNotNull(this.charSpace, "charSpace is null");
        CaptchaTool.assertNotNull(this.fonts, "fonts is null");
        CaptchaTool.assertNotNull(this.isBorderDrawn, "isBorderDrawn is null");
        CaptchaTool.assertNotNull(this.borderColor, "borderColor is null");
        CaptchaTool.assertNotNull(this.borderThickness, "borderThickness is null");
        CaptchaTool.assertNotNull(this.distortedEngines, "distortedEngine is null");
        CaptchaTool.assertNotNull(this.noiseColor, "noiseColor is null");
        String text = textResult.getText();
        Color color = this.colors.size() == 1 ? this.colors.get(0) : this.colors.get(new Random().nextInt(this.colors.size()));
        Font font = this.fonts.size() == 1 ? this.fonts.get(0) : this.fonts.get(new Random().nextInt(this.fonts.size()));
        BufferedImage bi = this.renderWord(text, this.width, this.height, this.fontSize, font, color, this.charSpace);
        DistortedEngine distortedEngine = this.distortedEngines.size() == 1 ? this.distortedEngines.get(0) : this.distortedEngines.get(new Random().nextInt(this.distortedEngines.size()));
        bi = distortedEngine.getDistortedImage(bi);
        this.makeNoise(bi, this.noiseColor, 0.1f, 0.1f, 0.25f, 0.25f);
        this.makeNoise(bi, this.noiseColor, 0.1f, 0.25f, 0.5f, 0.9f);
        bi = this.addBackground(bi, this.backgroundColorFrom, this.backgroundColorTo);
        if (this.isBorderDrawn.booleanValue()) {
            this.drawBox(bi, this.borderColor, this.borderThickness, this.width, this.height);
        }
        return bi;
    }

    private BufferedImage renderWord(String word, int width, int height, int fontSize, Font font, Color color, int charSpace) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2D = image.createGraphics();
        g2D.setColor(color);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2D.setRenderingHints(hints);
        FontRenderContext frc = g2D.getFontRenderContext();
        Random random = new Random();
        int startPosY = (height - fontSize) / 5 + fontSize;
        char[] wordChars = word.toCharArray();
        Font[] chosenFonts = new Font[wordChars.length];
        int[] charWidths = new int[wordChars.length];
        int widthNeeded = 0;
        for (int i = 0; i < wordChars.length; ++i) {
            chosenFonts[i] = font;
            char[] charToDraw = new char[]{wordChars[i]};
            GlyphVector gv = chosenFonts[i].createGlyphVector(frc, charToDraw);
            charWidths[i] = (int)gv.getVisualBounds().getWidth();
            if (i > 0) {
                widthNeeded += charSpace;
            }
            widthNeeded += charWidths[i];
        }
        int startPosX = (width - widthNeeded) / 2;
        for (int i = 0; i < wordChars.length; ++i) {
            g2D.setFont(chosenFonts[i]);
            char[] charToDraw = new char[]{wordChars[i]};
            g2D.drawChars(charToDraw, 0, charToDraw.length, startPosX, startPosY);
            startPosX = startPosX + charWidths[i] + charSpace;
        }
        return image;
    }

    private void makeNoise(BufferedImage image, Color noiseColor, float factorOne, float factorTwo, float factorThree, float factorFour) {
        int width = image.getWidth();
        int height = image.getHeight();
        Point2D[] pts = null;
        SecureRandom rand = new SecureRandom();
        CubicCurve2D.Float cc = new CubicCurve2D.Float((float)width * factorOne, (float)height * rand.nextFloat(), (float)width * factorTwo, (float)height * rand.nextFloat(), (float)width * factorThree, (float)height * rand.nextFloat(), (float)width * factorFour, (float)height * rand.nextFloat());
        PathIterator pi = cc.getPathIterator(null, 2.0);
        Point2D[] tmp = new Point2D[200];
        int i = 0;
        while (!pi.isDone()) {
            float[] coords = new float[6];
            switch (pi.currentSegment(coords)) {
                case 0: 
                case 1: {
                    tmp[i] = new Point2D.Float(coords[0], coords[1]);
                }
            }
            ++i;
            pi.next();
        }
        pts = new Point2D[i];
        System.arraycopy(tmp, 0, pts, 0, i);
        Graphics2D graph = (Graphics2D)image.getGraphics();
        graph.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graph.setColor(noiseColor);
        for (i = 0; i < pts.length - 1; ++i) {
            if (i < 3) {
                graph.setStroke(new BasicStroke(0.9f * (float)(4 - i)));
            }
            graph.drawLine((int)pts[i].getX(), (int)pts[i].getY(), (int)pts[i + 1].getX(), (int)pts[i + 1].getY());
        }
        graph.dispose();
    }

    private BufferedImage addBackground(BufferedImage baseImage, Color colorFrom, Color colorTo) {
        int width = baseImage.getWidth();
        int height = baseImage.getHeight();
        BufferedImage imageWithBackground = new BufferedImage(width, height, 1);
        Graphics2D graph = (Graphics2D)imageWithBackground.getGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graph.setRenderingHints(hints);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, colorFrom, width, height, colorTo);
        graph.setPaint(paint);
        graph.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        graph.drawImage((Image)baseImage, 0, 0, null);
        return imageWithBackground;
    }

    private void drawBox(BufferedImage baseImage, Color borderColor, int borderThickness, int width, int height) {
        Graphics2D graphics = baseImage.createGraphics();
        graphics.setColor(borderColor);
        if (borderThickness != 1) {
            BasicStroke stroke = new BasicStroke(borderThickness);
            graphics.setStroke(stroke);
        }
        graphics.draw(new Line2D.Double(0.0, 0.0, 0.0, width));
        graphics.draw(new Line2D.Double(0.0, 0.0, width, 0.0));
        graphics.draw(new Line2D.Double(0.0, height - 1, width, height - 1));
        graphics.draw(new Line2D.Double(width - 1, height - 1, width - 1, 0.0));
    }

    public static class DefaultTextCreator
    implements TextCreator {
        private final int length;
        private final String str;

        public DefaultTextCreator() {
            this(4);
        }

        public DefaultTextCreator(int length) {
            this(length, CaptchaTool.TEXT_NUMBER_AND_LOWERCASE);
        }

        public DefaultTextCreator(String str) {
            this(4, str);
        }

        public DefaultTextCreator(int length, String str) {
            this.length = length;
            this.str = str;
        }

        @Override
        public TextResult create() {
            return this.create(this.length);
        }

        public TextResult create(int length) {
            char[] chars = this.str.toCharArray();
            Random rand = new Random();
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                text.append(chars[rand.nextInt(chars.length)]);
            }
            String result = text.toString();
            return new TextResult(result, result);
        }
    }

    public static interface TextCreator {
        public TextResult create();
    }

    public static interface DistortedEngine {
        public BufferedImage getDistortedImage(BufferedImage var1);
    }

    public static class NoneDistorted
    implements DistortedEngine {
        @Override
        public BufferedImage getDistortedImage(BufferedImage baseImage) {
            return baseImage;
        }
    }

    public static class ShadowDistorted
    implements DistortedEngine {
        @Override
        public BufferedImage getDistortedImage(BufferedImage baseImage) {
            BufferedImage effectImage = baseImage;
            effectImage = this.shadowFilter(effectImage);
            BufferedImage distortedImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
            Graphics2D graph = (Graphics2D)distortedImage.getGraphics();
            graph.drawImage(effectImage, 0, 0, null, null);
            graph.dispose();
            return distortedImage;
        }

        private BufferedImage shadowFilter(BufferedImage src) {
            float angle = 4.712389f;
            float radius = 10.0f;
            float distance = 5.0f;
            float opacity = 1.0f;
            int width = src.getWidth();
            int height = src.getHeight();
            float xOffset = distance * (float)Math.cos(angle);
            float yOffset = -distance * (float)Math.sin(angle);
            float shadowR = 0.0f;
            float shadowG = 0.0f;
            float shadowB = 0.0f;
            float[][] extractAlpha = new float[][]{{0.0f, 0.0f, 0.0f, shadowR}, {0.0f, 0.0f, 0.0f, shadowG}, {0.0f, 0.0f, 0.0f, shadowB}, {0.0f, 0.0f, 0.0f, opacity}};
            BufferedImage shadow = new BufferedImage(width, height, 2);
            new BandCombineOp(extractAlpha, null).filter(src.getRaster(), shadow.getRaster());
            shadow = this.gaussianFilter(shadow, radius);
            BufferedImage dst = WaterRippleDistorted.createCompatibleDestImage(src);
            Graphics2D graphics2D = dst.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3, opacity));
            graphics2D.drawRenderedImage(shadow, AffineTransform.getTranslateInstance(xOffset, yOffset));
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawRenderedImage(src, null);
            graphics2D.dispose();
            return dst;
        }

        public BufferedImage gaussianFilter(BufferedImage src, float radius) {
            int width = src.getWidth();
            int height = src.getHeight();
            int[] inPixels = new int[width * height];
            int[] outPixels = new int[width * height];
            src.getRGB(0, 0, width, height, inPixels, 0, width);
            if (radius > 0.0f) {
                Kernel kernel = ShadowDistorted.makeKernel(radius);
                ShadowDistorted.convolveAndTranspose(kernel, inPixels, outPixels, width, height, true, false);
                ShadowDistorted.convolveAndTranspose(kernel, outPixels, inPixels, height, width, false, true);
            }
            BufferedImage dst = WaterRippleDistorted.createCompatibleDestImage(src);
            dst.setRGB(0, 0, width, height, inPixels, 0, width);
            return dst;
        }

        public static Kernel makeKernel(float radius) {
            int r = (int)Math.ceil(radius);
            int rows = r * 2 + 1;
            float[] matrix = new float[rows];
            float sigma = radius / 3.0f;
            float sigma22 = 2.0f * sigma * sigma;
            float sigmaPi2 = (float)Math.PI * 2 * sigma;
            float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
            float radius2 = radius * radius;
            float total = 0.0f;
            int index = 0;
            for (int row = -r; row <= r; ++row) {
                float distance = row * row;
                matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
                total += matrix[index];
                ++index;
            }
            int i = 0;
            while (i < rows) {
                int n = i++;
                matrix[n] = matrix[n] / total;
            }
            return new Kernel(rows, 1, matrix);
        }

        public static void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean premultiply, boolean unpremultiply) {
            float[] matrix = kernel.getKernelData(null);
            int cols = kernel.getWidth();
            int cols2 = cols / 2;
            for (int y = 0; y < height; ++y) {
                int index = y;
                int ioffset = y * width;
                for (int x = 0; x < width; ++x) {
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    float a = 0.0f;
                    for (int col = -cols2; col <= cols2; ++col) {
                        float f = matrix[cols2 + col];
                        if (f == 0.0f) continue;
                        int ix = x + col;
                        if (ix < 0) {
                            ix = 0;
                        } else if (ix >= width) {
                            ix = width - 1;
                        }
                        int rgb = inPixels[ioffset + ix];
                        int pa = rgb >> 24 & 0xFF;
                        int pr = rgb >> 16 & 0xFF;
                        int pg = rgb >> 8 & 0xFF;
                        int pb = rgb & 0xFF;
                        if (premultiply) {
                            float a255 = (float)pa * 0.003921569f;
                            pr *= (int)a255;
                            pg *= (int)a255;
                            pb *= (int)a255;
                        }
                        a += f * (float)pa;
                        r += f * (float)pr;
                        g += f * (float)pg;
                        b += f * (float)pb;
                    }
                    if (unpremultiply && a != 0.0f && a != 255.0f) {
                        float f = 255.0f / a;
                        r *= f;
                        g *= f;
                        b *= f;
                    }
                    int ia = WaterRippleDistorted.clamp((int)((double)a + 0.5));
                    int ir = WaterRippleDistorted.clamp((int)((double)r + 0.5));
                    int ig = WaterRippleDistorted.clamp((int)((double)g + 0.5));
                    int ib = WaterRippleDistorted.clamp((int)((double)b + 0.5));
                    outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                    index += height;
                }
            }
        }
    }

    public static class WaterRippleDistorted
    implements DistortedEngine {
        public static final float TWO_PI = (float)Math.PI * 2;

        @Override
        public BufferedImage getDistortedImage(BufferedImage baseImage) {
            BufferedImage effectImage = this.waterFilter(baseImage);
            BufferedImage distortedImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
            Graphics2D graphics = (Graphics2D)distortedImage.getGraphics();
            graphics.drawImage(effectImage, 0, 0, null, null);
            graphics.dispose();
            return distortedImage;
        }

        public BufferedImage waterFilter(BufferedImage src) {
            float amplitude = 1.5f;
            float phase = 10.0f;
            float wavelength = 2.0f;
            float centreX = 0.5f;
            float centreY = 0.5f;
            float radius = 50.0f;
            float icentreX = (float)src.getWidth() * centreX;
            float icentreY = (float)src.getHeight() * centreY;
            float radius2 = radius * radius;
            int width = src.getWidth();
            int height = src.getHeight();
            Rectangle transformedSpace = new Rectangle(0, 0, width, height);
            ColorModel dstCM = src.getColorModel();
            BufferedImage dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(transformedSpace.width, transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
            int[] inPixels = WaterRippleDistorted.getRGB(src, 0, 0, width, height, null);
            int srcWidth1 = width - 1;
            int srcHeight1 = height - 1;
            int outWidth = transformedSpace.width;
            int outHeight = transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = transformedSpace.x;
            int outY = transformedSpace.y;
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    int se;
                    int sw;
                    int ne;
                    int nw;
                    this.transformInverse4water(outX + x, outY + y, out, icentreX, icentreY, radius2, amplitude, phase, wavelength, radius);
                    int srcX = (int)Math.floor(out[0]);
                    int srcY = (int)Math.floor(out[1]);
                    float xWeight = out[0] - (float)srcX;
                    float yWeight = out[1] - (float)srcY;
                    if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                        int i = width * srcY + srcX;
                        nw = inPixels[i];
                        ne = inPixels[i + 1];
                        sw = inPixels[i + width];
                        se = inPixels[i + width + 1];
                    } else {
                        nw = WaterRippleDistorted.getPixel(inPixels, srcX, srcY, width, height);
                        ne = WaterRippleDistorted.getPixel(inPixels, srcX + 1, srcY, width, height);
                        sw = WaterRippleDistorted.getPixel(inPixels, srcX, srcY + 1, width, height);
                        se = WaterRippleDistorted.getPixel(inPixels, srcX + 1, srcY + 1, width, height);
                    }
                    outPixels[x] = WaterRippleDistorted.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
                }
                WaterRippleDistorted.setRGB(dst, 0, y, transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        protected void transformInverse4water(int x, int y, float[] out, float icentreX, float icentreY, float radius2, float amplitude, float phase, float wavelength, float radius) {
            float dx = (float)x - icentreX;
            float dy = (float)y - icentreY;
            float distance2 = dx * dx + dy * dy;
            if (distance2 > radius2) {
                out[0] = x;
                out[1] = y;
            } else {
                float distance = (float)Math.sqrt(distance2);
                float amount = amplitude * (float)Math.sin(distance / wavelength * ((float)Math.PI * 2) - phase);
                amount *= (radius - distance) / radius;
                if (distance != 0.0f) {
                    amount *= wavelength / distance;
                }
                out[0] = (float)x + dx * amount;
                out[1] = (float)y + dy * amount;
            }
        }

        public static int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
            }
            return image.getRGB(x, y, width, height, pixels, 0, width);
        }

        public static void setRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                image.getRaster().setDataElements(x, y, width, height, pixels);
            } else {
                image.setRGB(x, y, width, height, pixels, 0, width);
            }
        }

        public static int getPixel(int[] pixels, int x, int y, int width, int height) {
            if (x < 0 || x >= width || y < 0 || y >= height) {
                return pixels[WaterRippleDistorted.clamp(y, 0, height - 1) * width + WaterRippleDistorted.clamp(x, 0, width - 1)];
            }
            return pixels[y * width + x];
        }

        public static BufferedImage createCompatibleDestImage(BufferedImage src) {
            ColorModel dstCM = src.getColorModel();
            return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
        }

        public static int clamp(int x, int a, int b) {
            return x < a ? a : Math.min(x, b);
        }

        public static int clamp(int c) {
            if (c < 0) {
                return 0;
            }
            return Math.min(c, 255);
        }

        public static int bilinearInterpolate(float x, float y, int nw, int ne, int sw, int se) {
            int a0 = nw >> 24 & 0xFF;
            int r0 = nw >> 16 & 0xFF;
            int g0 = nw >> 8 & 0xFF;
            int b0 = nw & 0xFF;
            int a1 = ne >> 24 & 0xFF;
            int r1 = ne >> 16 & 0xFF;
            int g1 = ne >> 8 & 0xFF;
            int b1 = ne & 0xFF;
            int a2 = sw >> 24 & 0xFF;
            int r2 = sw >> 16 & 0xFF;
            int g2 = sw >> 8 & 0xFF;
            int b2 = sw & 0xFF;
            int a3 = se >> 24 & 0xFF;
            int r3 = se >> 16 & 0xFF;
            int g3 = se >> 8 & 0xFF;
            int b3 = se & 0xFF;
            float cx = 1.0f - x;
            float cy = 1.0f - y;
            float m0 = cx * (float)a0 + x * (float)a1;
            float m1 = cx * (float)a2 + x * (float)a3;
            int a = (int)(cy * m0 + y * m1);
            m0 = cx * (float)r0 + x * (float)r1;
            m1 = cx * (float)r2 + x * (float)r3;
            int r = (int)(cy * m0 + y * m1);
            m0 = cx * (float)g0 + x * (float)g1;
            m1 = cx * (float)g2 + x * (float)g3;
            int g = (int)(cy * m0 + y * m1);
            m0 = cx * (float)b0 + x * (float)b1;
            m1 = cx * (float)b2 + x * (float)b3;
            int b = (int)(cy * m0 + y * m1);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }

    public static class FishEyeDistorted
    implements DistortedEngine {
        @Override
        public BufferedImage getDistortedImage(BufferedImage baseImage) {
            int imageHeight = baseImage.getHeight();
            int imageWidth = baseImage.getWidth();
            int[] pix = new int[imageHeight * imageWidth];
            int j = 0;
            for (int j1 = 0; j1 < imageWidth; ++j1) {
                for (int k1 = 0; k1 < imageHeight; ++k1) {
                    pix[j] = baseImage.getRGB(j1, k1);
                    ++j;
                }
            }
            double distance = this.randomInt(imageWidth / 4, imageWidth / 3);
            int widthMiddle = baseImage.getWidth() / 2;
            int heightMiddle = baseImage.getHeight() / 2;
            for (int x = 0; x < baseImage.getWidth(); ++x) {
                for (int y = 0; y < baseImage.getHeight(); ++y) {
                    int relX = x - widthMiddle;
                    int relY = y - heightMiddle;
                    double d1 = Math.sqrt(relX * relX + relY * relY);
                    if (!(d1 < distance)) continue;
                    int j2 = widthMiddle + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(x - widthMiddle));
                    int k2 = heightMiddle + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(y - heightMiddle));
                    baseImage.setRGB(x, y, pix[j2 * imageHeight + k2]);
                }
            }
            return baseImage;
        }

        private int randomInt(int i, int j) {
            double d = Math.random();
            return (int)((double)i + (double)(j - i + 1) * d);
        }

        private double fishEyeFormula(double s) {
            if (s < 0.0) {
                return 0.0;
            }
            if (s > 1.0) {
                return s;
            }
            return -0.75 * s * s * s + 1.5 * s * s + 0.25 * s;
        }
    }

    public static class RippleDistorted
    implements DistortedEngine {
        @Override
        public BufferedImage getDistortedImage(BufferedImage baseImage) {
            BufferedImage effectImage = this.rippleFilter(baseImage);
            BufferedImage distortedImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
            Graphics2D graph = (Graphics2D)distortedImage.getGraphics();
            graph.drawImage(effectImage, 0, 0, null, null);
            graph.dispose();
            return distortedImage;
        }

        public BufferedImage rippleFilter(BufferedImage src) {
            Random rand = new Random();
            float xAmplitude = 7.6f;
            float yAmplitude = rand.nextFloat() + 1.0f;
            float xWavelength = rand.nextInt(7) + 8;
            float yWavelength = rand.nextInt(3) + 2;
            int width = src.getWidth();
            int height = src.getHeight();
            Rectangle transformedSpace = new Rectangle(0, 0, width, height);
            ColorModel dstCM = src.getColorModel();
            BufferedImage dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(transformedSpace.width, transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
            int[] inPixels = WaterRippleDistorted.getRGB(src, 0, 0, width, height, null);
            int srcWidth1 = width - 1;
            int srcHeight1 = height - 1;
            int outWidth = transformedSpace.width;
            int outHeight = transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = transformedSpace.x;
            int outY = transformedSpace.y;
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    int se;
                    int sw;
                    int ne;
                    int nw;
                    this.transformInverseForRipple(outX + x, outY + y, out, xWavelength, yWavelength, xAmplitude, yAmplitude);
                    int srcX = (int)Math.floor(out[0]);
                    int srcY = (int)Math.floor(out[1]);
                    float xWeight = out[0] - (float)srcX;
                    float yWeight = out[1] - (float)srcY;
                    if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                        int i = width * srcY + srcX;
                        nw = inPixels[i];
                        ne = inPixels[i + 1];
                        sw = inPixels[i + width];
                        se = inPixels[i + width + 1];
                    } else {
                        nw = WaterRippleDistorted.getPixel(inPixels, srcX, srcY, width, height);
                        ne = WaterRippleDistorted.getPixel(inPixels, srcX + 1, srcY, width, height);
                        sw = WaterRippleDistorted.getPixel(inPixels, srcX, srcY + 1, width, height);
                        se = WaterRippleDistorted.getPixel(inPixels, srcX + 1, srcY + 1, width, height);
                    }
                    outPixels[x] = WaterRippleDistorted.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
                }
                WaterRippleDistorted.setRGB(dst, 0, y, transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        protected void transformInverseForRipple(int x, int y, float[] out, float xWavelength, float yWavelength, float xAmplitude, float yAmplitude) {
            float nx = (float)y / xWavelength;
            float ny = (float)x / yWavelength;
            float fx = (float)Math.sin(nx);
            float fy = (float)Math.sin(ny);
            out[0] = (float)x + xAmplitude * fx;
            out[1] = (float)y + yAmplitude * fy;
        }
    }

    public static class TextResult {
        private final String text;
        private final String result;

        public TextResult(String text, String result) {
            this.text = text;
            this.result = result;
        }

        public String getText() {
            return this.text;
        }

        public String getResult() {
            return this.result;
        }

        public String toString() {
            return "TextCreatorResult{text='" + this.text + "', result='" + this.result + "'}";
        }
    }

    public static class ArithmeticTextCreator
    implements TextCreator {
        private static final String[] Number = "0,1,2,3,4,5,6,7,8,9,10".split(",");

        @Override
        public TextResult create() {
            int result;
            Random random = new Random();
            int x = random.nextInt(10);
            int y = random.nextInt(10);
            StringBuilder text = new StringBuilder();
            int randomOperand = random.nextInt(4);
            if (randomOperand == 0) {
                text.append(Number[x]);
                text.append("+");
                text.append(Number[y]);
                result = x + y;
            } else if (randomOperand == 1) {
                if (x >= y) {
                    text.append(Number[x]);
                    text.append("-");
                    text.append(Number[y]);
                    result = x - y;
                } else {
                    text.append(Number[y]);
                    text.append("-");
                    text.append(Number[x]);
                    result = y - x;
                }
            } else if (randomOperand == 2) {
                text.append(Number[x]);
                text.append("*");
                text.append(Number[y]);
                result = x * y;
            } else if (x != 0) {
                text.append(Number[y]);
                text.append("/");
                text.append(Number[x]);
                result = y / x;
            } else {
                text.append(Number[x]);
                text.append("+");
                text.append(Number[y]);
                result = x + y;
            }
            text.append("=?");
            return new TextResult(text.toString(), String.valueOf(result));
        }
    }
}

