/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.cache;

import com.xxl.tool.cache.CacheType;
import com.xxl.tool.cache.iface.Cache;
import com.xxl.tool.cache.iface.CacheListener;
import com.xxl.tool.cache.iface.CacheLoader;
import com.xxl.tool.cache.impl.FIFOCache;
import com.xxl.tool.cache.impl.LFUCache;
import com.xxl.tool.cache.impl.LRUCache;
import com.xxl.tool.cache.impl.NoCache;
import com.xxl.tool.cache.impl.UnlimitedCache;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheTool<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CacheTool.class);
    protected long timeout = 0L;
    protected boolean expireType = false;
    protected int capacity = 0;
    protected CacheType cacheType;
    protected CacheLoader<K, V> loader;
    protected CacheListener<K, V> listener;
    protected long pruneInterval = 0L;
    protected ScheduledFuture<?> pruneJobFuture;
    protected Cache<K, V> cache;
    private static final ScheduledExecutorService pruneTimer = new ScheduledThreadPoolExecutor(1);

    public static <K, V> CacheTool<K, V> newCache() {
        return CacheTool.newLRUCache();
    }

    public static <K, V> CacheTool<K, V> newFIFOCache() {
        return CacheTool.newFIFOCache(1000);
    }

    public static <K, V> CacheTool<K, V> newFIFOCache(int capacity) {
        return new CacheTool<K, V>().cache(CacheType.FIFO).capacity(capacity);
    }

    public static <K, V> CacheTool<K, V> newLRUCache() {
        return CacheTool.newLRUCache(1000);
    }

    public static <K, V> CacheTool<K, V> newLRUCache(int capacity) {
        return new CacheTool<K, V>().cache(CacheType.LRU).capacity(capacity);
    }

    public static <K, V> CacheTool<K, V> newLFUCache() {
        return CacheTool.newLFUCache(1000);
    }

    public static <K, V> CacheTool<K, V> newLFUCache(int capacity) {
        return new CacheTool<K, V>().cache(CacheType.LFU).capacity(capacity);
    }

    public static <K, V> CacheTool<K, V> newUnlimitedCache() {
        return CacheTool.newUnlimitedCache(0);
    }

    public static <K, V> CacheTool<K, V> newUnlimitedCache(int timeout) {
        return new CacheTool<K, V>().cache(CacheType.UNLIMITED).expireAfterWrite(timeout);
    }

    public CacheTool<K, V> expireAfterWrite(long timeout) {
        this.timeout = timeout;
        this.expireType = true;
        return this;
    }

    public CacheTool<K, V> expireAfterAccess(long timeout) {
        this.timeout = timeout;
        this.expireType = false;
        return this;
    }

    public CacheTool<K, V> capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public CacheTool<K, V> cache(CacheType cacheType) {
        this.cacheType = cacheType;
        return this;
    }

    public CacheTool<K, V> loader(CacheLoader<K, V> cacheLoader) {
        this.loader = cacheLoader;
        return this;
    }

    public CacheTool<K, V> listener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    public CacheTool<K, V> pruneInterval(long pruneInterval) {
        this.pruneInterval = pruneInterval;
        return this;
    }

    public <K, V> Cache<K, V> build() {
        if (this.cacheType == CacheType.NONE) {
            this.cache = new NoCache();
        } else if (this.cacheType == CacheType.FIFO) {
            this.cache = new FIFOCache(this.capacity, this.timeout, this.expireType);
        } else if (this.cacheType == CacheType.LFU) {
            this.cache = new LFUCache(this.capacity, this.timeout, this.expireType);
        } else if (this.cacheType == CacheType.LRU) {
            this.cache = new LRUCache(this.capacity, this.timeout, this.expireType);
        } else if (this.cacheType == CacheType.UNLIMITED) {
            this.cache = new UnlimitedCache(this.timeout, this.expireType);
            if (this.pruneInterval <= 0L) {
                this.pruneInterval = 5000L;
            }
        } else {
            throw new RuntimeException("cacheType invalid.");
        }
        if (this.listener != null) {
            this.cache.setListener(this.listener);
        }
        if (this.loader != null) {
            this.cache.setLoader(this.loader);
        }
        if (this.pruneInterval > 0L) {
            this.pruneJobFuture = this.schedule(() -> {
                try {
                    this.cache.prune();
                }
                catch (Exception e) {
                    logger.error("prune cache error", (Throwable)e);
                }
            }, this.pruneInterval);
        }
        return this.cache;
    }

    public void stop() {
        if (this.pruneJobFuture != null) {
            this.pruneJobFuture.cancel(true);
        }
    }

    private ScheduledFuture<?> schedule(Runnable task, long delay) {
        return pruneTimer.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(pruneTimer::shutdownNow));
    }
}

