/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.helper;

import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.store.LoginStore;
import com.xxl.sso.core.token.TokenHelper;
import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.http.CookieTool;
import com.xxl.tool.id.UUIDTool;
import com.xxl.tool.response.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlSsoHelper {
    private static final Logger logger = LoggerFactory.getLogger(XxlSsoHelper.class);
    private static XxlSsoHelper instance;
    private final LoginStore loginStore;
    private String tokenKey;
    private long tokenTimeout;

    public static void init(LoginStore loginStore, String tokenKey, long tokenTimeout) {
        instance = new XxlSsoHelper(loginStore, tokenKey, tokenTimeout);
    }

    public static XxlSsoHelper getInstance() {
        return instance;
    }

    public XxlSsoHelper(LoginStore loginStore, String tokenKey, long tokenTimeout) {
        this.loginStore = loginStore;
        this.tokenKey = tokenKey;
        this.tokenTimeout = tokenTimeout;
        if (StringTool.isBlank((String)this.tokenKey)) {
            this.tokenKey = "xxl_sso_token";
        }
        if (this.tokenTimeout <= 0L) {
            this.tokenTimeout = 315360000000L;
        }
    }

    public LoginStore getLoginStore() {
        return this.loginStore;
    }

    public String getTokenKey() {
        return this.tokenKey;
    }

    public long getTokenTimeout() {
        return this.tokenTimeout;
    }

    public static Response<String> login(LoginInfo loginInfo) {
        Response<String> tokenResponse = TokenHelper.generateToken(loginInfo);
        if (!tokenResponse.isSuccess()) {
            return tokenResponse;
        }
        loginInfo.setExpireTime(System.currentTimeMillis() + XxlSsoHelper.getInstance().getTokenTimeout());
        Response<String> setResponse = XxlSsoHelper.getInstance().getLoginStore().set(loginInfo);
        if (!setResponse.isSuccess()) {
            return setResponse;
        }
        return Response.ofSuccess((Object)((String)tokenResponse.getData()));
    }

    public static Response<String> loginWithCookie(LoginInfo loginInfo, HttpServletResponse response, boolean ifRemember) {
        Response<String> loginResult = XxlSsoHelper.login(loginInfo);
        if (loginResult.isSuccess()) {
            String token = (String)loginResult.getData();
            CookieTool.set((HttpServletResponse)response, (String)XxlSsoHelper.getInstance().getTokenKey(), (String)token, (boolean)ifRemember);
        }
        return loginResult;
    }

    public static Response<String> loginUpdate(LoginInfo loginInfo) {
        if (loginInfo != null) {
            loginInfo.setExpireTime(System.currentTimeMillis() + XxlSsoHelper.getInstance().getTokenTimeout());
        }
        return XxlSsoHelper.getInstance().getLoginStore().update(loginInfo);
    }

    public static Response<String> logout(String token) {
        LoginInfo loginInfoForToken = TokenHelper.parseToken(token);
        if (loginInfoForToken == null) {
            return Response.ofFail((String)"token is invalid");
        }
        return XxlSsoHelper.getInstance().getLoginStore().remove(loginInfoForToken.getUserId());
    }

    public static Response<String> logoutWithCookie(HttpServletRequest request, HttpServletResponse response) {
        String token = CookieTool.getValue((HttpServletRequest)request, (String)XxlSsoHelper.getInstance().getTokenKey());
        if (StringTool.isBlank((String)token)) {
            return Response.ofSuccess();
        }
        Response<String> logoutResult = XxlSsoHelper.logout(token);
        CookieTool.remove((HttpServletRequest)request, (HttpServletResponse)response, (String)XxlSsoHelper.getInstance().getTokenKey());
        return logoutResult;
    }

    public static Response<LoginInfo> loginCheck(String token) {
        LoginInfo loginInfoForToken = TokenHelper.parseToken(token);
        if (loginInfoForToken == null || StringTool.isBlank((String)loginInfoForToken.getSignature())) {
            return Response.ofFail((String)"token is invalid");
        }
        Response<LoginInfo> loginInfoResponse = XxlSsoHelper.getInstance().getLoginStore().get(loginInfoForToken.getUserId());
        if (!loginInfoResponse.isSuccess()) {
            return loginInfoResponse;
        }
        LoginInfo loginInfo = (LoginInfo)loginInfoResponse.getData();
        if (!loginInfoForToken.getSignature().equals(loginInfo.getSignature())) {
            return Response.ofFail((String)"token signature is invalid");
        }
        return Response.ofSuccess((Object)loginInfo);
    }

    public static Response<LoginInfo> loginCheckWithHeader(HttpServletRequest request) {
        String token = request.getHeader(XxlSsoHelper.getInstance().getTokenKey());
        return XxlSsoHelper.loginCheck(token);
    }

    public static Response<LoginInfo> loginCheckWithCookie(HttpServletRequest request, HttpServletResponse response) {
        String token = CookieTool.getValue((HttpServletRequest)request, (String)XxlSsoHelper.getInstance().getTokenKey());
        Response<LoginInfo> result = XxlSsoHelper.loginCheck(token);
        if (result == null || !result.isSuccess()) {
            CookieTool.remove((HttpServletRequest)request, (HttpServletResponse)response, (String)XxlSsoHelper.getInstance().getTokenKey());
        }
        return result;
    }

    public static Response<LoginInfo> loginCheckWithAttr(HttpServletRequest request) {
        LoginInfo loginInfo = (LoginInfo)request.getAttribute("xxl_sso_user");
        return loginInfo != null ? Response.ofSuccess((Object)loginInfo) : Response.ofFail((String)"not login.");
    }

    public static Response<String> createTicket(HttpServletRequest request) {
        String token = CookieTool.getValue((HttpServletRequest)request, (String)XxlSsoHelper.getInstance().getTokenKey());
        LoginInfo loginInfoForToken = TokenHelper.parseToken(token);
        if (loginInfoForToken == null) {
            return Response.ofFail((String)"not login.");
        }
        String ticket = loginInfoForToken.getUserId().concat("_").concat(UUIDTool.getSimpleUUID());
        long ticketTimeout = 60000L;
        return XxlSsoHelper.getInstance().getLoginStore().createTicket(ticket, token, ticketTimeout);
    }

    public static Response<LoginInfo> validTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("xxl_sso_ticket");
        if (StringTool.isBlank((String)ticket)) {
            return Response.ofFail((String)"ticket is null.");
        }
        Response<String> validTicketResult = XxlSsoHelper.getInstance().getLoginStore().validTicket(ticket);
        if (!validTicketResult.isSuccess()) {
            return Response.ofFail((String)validTicketResult.getMsg());
        }
        String token = (String)validTicketResult.getData();
        Response<LoginInfo> result = XxlSsoHelper.loginCheck(token);
        if (result.isSuccess()) {
            CookieTool.set((HttpServletResponse)response, (String)XxlSsoHelper.getInstance().getTokenKey(), (String)token, (boolean)false);
        }
        return XxlSsoHelper.loginCheck(token);
    }

    public static Response<String> hasRole(LoginInfo loginInfo, String role) {
        if (StringTool.isBlank((String)role)) {
            return Response.ofSuccess();
        }
        if (CollectionTool.isEmpty(loginInfo.getRoleList())) {
            return Response.ofFail((String)"roleList is null.");
        }
        return loginInfo.getRoleList().contains(role) ? Response.ofSuccess() : Response.ofFail((String)"has no role.");
    }

    public static Response<String> hasPermission(LoginInfo loginInfo, String permission) {
        if (StringTool.isBlank((String)permission)) {
            return Response.ofSuccess();
        }
        if (CollectionTool.isEmpty(loginInfo.getPermissionList())) {
            return Response.ofFail((String)"permissionList is null.");
        }
        return loginInfo.getPermissionList().contains(permission) ? Response.ofSuccess() : Response.ofFail((String)"has no permission.");
    }
}

