/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.json.support.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xkcoding.json.config.JsonConfig;
import com.xkcoding.json.exception.SimpleJsonException;
import com.xkcoding.json.support.AbstractJsonAdapter;
import com.xkcoding.json.util.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JacksonJsonAdapter
extends AbstractJsonAdapter {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonJsonAdapter() {
        this(new JsonConfig());
    }

    public JacksonJsonAdapter(JsonConfig jsonConfig) {
        super(jsonConfig);
        this.configureJackson(jsonConfig);
    }

    @Override
    public void setJsonConfig(JsonConfig jsonConfig) {
        super.setJsonConfig(jsonConfig);
        this.configureJackson(jsonConfig);
    }

    private void configureJackson(JsonConfig jsonConfig) {
        if (StringUtil.isNotEmpty(jsonConfig.getDateFormat())) {
            this.objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(jsonConfig.getDateFormat()));
        }
    }

    @Override
    public String serialize(Object obj) throws SimpleJsonException {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new SimpleJsonException(e);
        }
    }

    @Override
    public <T> T deserialize(String jsonStr, Class<T> clazz) throws SimpleJsonException {
        try {
            return (T)this.objectMapper.readValue(jsonStr, clazz);
        }
        catch (JsonProcessingException e) {
            throw new SimpleJsonException(e);
        }
    }
}

