/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.hadoop.common.utils;

import com.webank.wedatasphere.linkis.common.conf.Configuration$;
import com.webank.wedatasphere.linkis.hadoop.common.conf.HadoopConf$;
import java.io.File;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class HDFSUtils$ {
    public static final HDFSUtils$ MODULE$;

    static {
        new HDFSUtils$();
    }

    public Configuration getConfiguration(String user) {
        return this.getConfiguration(user, Configuration$.MODULE$.hadoopConfDir());
    }

    public Configuration getConfiguration(String user, String hadoopConfDir) {
        File confPath = new File(hadoopConfDir);
        if (confPath.exists() && !confPath.isFile()) {
            Configuration conf = new Configuration();
            conf.addResource(new Path(Paths.get(hadoopConfDir, "core-site.xml").toAbsolutePath().toFile().getAbsolutePath()));
            conf.addResource(new Path(Paths.get(hadoopConfDir, "hdfs-site.xml").toAbsolutePath().toFile().getAbsolutePath()));
            conf.addResource(new Path(Paths.get(hadoopConfDir, "yarn-site.xml").toAbsolutePath().toFile().getAbsolutePath()));
            return conf;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create hadoop configuration failed, path ", " not exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hadoopConfDir})));
    }

    public FileSystem getHDFSRootUserFileSystem() {
        return this.getHDFSRootUserFileSystem(this.getConfiguration((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue()));
    }

    public FileSystem getHDFSRootUserFileSystem(Configuration conf) {
        return this.getHDFSUserFileSystem((String)HadoopConf$.MODULE$.HADOOP_ROOT_USER().getValue(), conf);
    }

    public FileSystem getHDFSUserFileSystem(String userName) {
        return this.getHDFSUserFileSystem(userName, this.getConfiguration(userName));
    }

    public FileSystem getHDFSUserFileSystem(String userName, Configuration conf) {
        return (FileSystem)this.getUserGroupInformation(userName).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(conf){
            private final Configuration conf$1;

            public FileSystem run() {
                return FileSystem.get((Configuration)this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public UserGroupInformation getUserGroupInformation(String userName) {
        UserGroupInformation userGroupInformation;
        if (BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KERBEROS_ENABLE().getValue())) {
            String path = new File((String)HadoopConf$.MODULE$.KEYTAB_FILE().getValue(), new StringBuilder().append((Object)userName).append((Object)".keytab").toString()).getPath();
            String user = this.getKerberosUser(userName);
            UserGroupInformation.setConfiguration((Configuration)this.getConfiguration(userName));
            userGroupInformation = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)path);
        } else {
            userGroupInformation = UserGroupInformation.createRemoteUser((String)userName);
        }
        return userGroupInformation;
    }

    /*
     * WARNING - void declaration
     */
    public String getKerberosUser(String userName) {
        void var2_2;
        String user = userName;
        if (BoxesRunTime.unboxToBoolean((Object)HadoopConf$.MODULE$.KEYTAB_HOST_ENABLED().getValue())) {
            user = new StringBuilder().append((Object)user).append((Object)"/").append(HadoopConf$.MODULE$.KEYTAB_HOST().getValue()).toString();
        }
        return var2_2;
    }

    private HDFSUtils$() {
        MODULE$ = this;
    }
}

