/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ProfileCreateSpec;
import com.vmware.vim25.ProfilePolicyMetadata;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.Profile;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class ProfileManager
extends ManagedObject {
    public ProfileManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public Profile[] getProfile() {
        ManagedObjectReference[] mors = (ManagedObjectReference[])this.getCurrentProperty("profile");
        return this.convert2Profiles(mors);
    }

    public Profile createProfile(ProfileCreateSpec createSpec) throws DuplicateName, RuntimeFault, RemoteException {
        ManagedObjectReference profileMor = this.getVimService().createProfile(this.getMOR(), createSpec);
        return new Profile(this.getServerConnection(), profileMor);
    }

    public Profile[] findAssociatedProfile(ManagedEntity entity) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().findAssociatedProfile(this.getMOR(), entity.getMOR());
        return this.convert2Profiles(mors);
    }

    public ProfilePolicyMetadata[] queryPolicyMetadata(String[] policyName) throws RuntimeFault, RemoteException {
        return this.queryPolicyMetadata(policyName, null);
    }

    public ProfilePolicyMetadata[] queryPolicyMetadata(String[] policyName, Profile profile) throws RuntimeFault, RemoteException {
        return this.getVimService().queryPolicyMetadata(this.getMOR(), policyName, profile == null ? null : profile.getMOR());
    }

    private Profile[] convert2Profiles(ManagedObjectReference[] mors) {
        Profile[] pfs = new Profile[mors.length];
        int i = 0;
        while (i < mors.length) {
            pfs[i] = new Profile(this.getServerConnection(), mors[i]);
            ++i;
        }
        return pfs;
    }
}

