/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.deserializer.impl.DateDeserializerImpl;
import com.vertica.deserializer.impl.IntervalDeserializerImpl;
import com.vertica.deserializer.impl.IntervalYMDeserializerImpl;
import com.vertica.deserializer.impl.NumericDeserializerImpl;
import com.vertica.deserializer.impl.StructDeserializerImpl;
import com.vertica.deserializer.impl.TimeDeserializerImpl;
import com.vertica.deserializer.impl.TimestampTZDeserializerImpl;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.DefaultParamException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.ParamAlreadyPushedException;
import com.vertica.jdbc.VerticaDayTimeInterval;
import com.vertica.jdbc.VerticaYearMonthInterval;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.BaseDataOID;
import com.vertica.util.ClientErrorException;
import com.vertica.util.ProtocolUtils;
import com.vertica.util.VerticaStruct;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.SimpleTimeZone;
import java.util.UUID;

public final class TypeUtils {
    private static final int INTERVAL_MASK_MONTH = 131072;
    private static final int INTERVAL_MASK_YEAR = 262144;
    private static final int INTERVAL_MASK_DAY = 524288;
    private static final int INTERVAL_MASK_HOUR = 0x4000000;
    private static final int INTERVAL_MASK_MINUTE = 0x8000000;
    private static final int INTERVAL_MASK_SECOND = 0x10000000;
    private static final int INTERVAL_MASK_YEAR2MONTH = 393216;
    private static final int INTERVAL_MASK_DAY2HOUR = 0x4080000;
    private static final int INTERVAL_MASK_DAY2MIN = 0xC080000;
    private static final int INTERVAL_MASK_DAY2SEC = 470286336;
    private static final int INTERVAL_MASK_HOUR2MIN = 0xC000000;
    private static final int INTERVAL_MASK_HOUR2SEC = 0x1C000000;
    private static final int INTERVAL_MASK_MIN2SEC = 0x18000000;
    private static final byte BACKSLASH = 92;
    private static final byte[] BACKSLASH_ESCAPE = new byte[]{92, 49, 51, 52};
    private static final long MILLIS_PER_MIN = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long POSITIVE_INFINITY_MILLISECONDS = 9223372036825200000L;
    private static final long NEGATIVE_INFINITY_MILLISECONDS = -9223372036832400000L;
    private static final int ASCII_OFFSET = 48;
    public static final int MAX_LONG_STRING_LEN = 32000000;
    public static final int MAX_STRING_LEN = 65000;

    public static HashMap<String, Object> getSessionParametersForDeserialize(VConnection vConnection) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sessiontimezone", vConnection.getSessionTimezone());
        return hashMap;
    }

    public static boolean oidMapsToResultSet_getArray(int n) {
        return BaseDataOID.isArrayType(n) || BaseDataOID.isSetType(n);
    }

    public static ColumnDescription getArrayTypeColumnDescription(ColumnDescription columnDescription) throws ClientErrorException {
        if (!TypeUtils.oidMapsToResultSet_getArray(columnDescription.getTypeOID())) {
            throw new ClientErrorException("Invalid type of ColumnDescription. Must be an array type.");
        }
        ListIterator<ColumnDescription> listIterator = columnDescription.getChildColumnIterator();
        if (listIterator == null) {
            throw new ClientErrorException("Complex Nested Array should have childrenColumnDescription");
        }
        ColumnDescription columnDescription2 = listIterator.next();
        return columnDescription2;
    }

    public static Class<?> getClassForColumn(ColumnDescription columnDescription) throws ClientErrorException {
        switch (columnDescription.getTypeOID()) {
            case 5: {
                return Boolean.class;
            }
            case 6: {
                return Long.class;
            }
            case 7: {
                return Double.class;
            }
            case 10: {
                return Date.class;
            }
            case 11: 
            case 15: {
                return Time.class;
            }
            case 12: {
                return Timestamp.class;
            }
            case 13: {
                return TimestampTz.class;
            }
            case 14: {
                return VerticaDayTimeInterval.class;
            }
            case 114: {
                return VerticaYearMonthInterval.class;
            }
            case 20: {
                return UUID.class;
            }
            case 16: {
                return BigDecimal.class;
            }
            case 8: 
            case 9: 
            case 115: {
                return String.class;
            }
            case 17: 
            case 116: 
            case 117: {
                return byte[].class;
            }
            case 300: 
            case 302: {
                return VerticaStruct.class;
            }
            case 301: {
                return TypeUtils.getArrayClassForColumn(columnDescription);
            }
            case 1505: 
            case 2705: {
                return Boolean[].class;
            }
            case 1506: 
            case 2706: {
                return Long[].class;
            }
            case 1507: 
            case 2707: {
                return Double[].class;
            }
            case 1510: 
            case 2710: {
                return Date[].class;
            }
            case 1511: 
            case 1515: 
            case 2711: 
            case 2715: {
                return Time[].class;
            }
            case 1512: 
            case 2712: {
                return Timestamp[].class;
            }
            case 1513: 
            case 2713: {
                return TimestampTz[].class;
            }
            case 1514: 
            case 2714: {
                return VerticaDayTimeInterval[].class;
            }
            case 1521: 
            case 2721: {
                return VerticaYearMonthInterval[].class;
            }
            case 1520: 
            case 2720: {
                return UUID[].class;
            }
            case 1516: 
            case 2716: {
                return BigDecimal[].class;
            }
            case 1508: 
            case 1509: 
            case 1519: 
            case 2708: 
            case 2709: 
            case 2719: {
                return String[].class;
            }
            case 1517: 
            case 1518: 
            case 1522: 
            case 2717: 
            case 2718: 
            case 2722: {
                return byte[][].class;
            }
        }
        return Object.class;
    }

    private static Class<?> getArrayClassForColumn(ColumnDescription columnDescription) throws ClientErrorException {
        ColumnDescription columnDescription2 = TypeUtils.getArrayTypeColumnDescription(columnDescription);
        if (columnDescription2 == null) {
            throw new RuntimeException("ColumnDescription OID must be ArrayOid. Currently is null");
        }
        switch (columnDescription2.getTypeOID()) {
            case 5: {
                return Boolean[].class;
            }
            case 6: {
                return Long[].class;
            }
            case 7: {
                return Double[].class;
            }
            case 10: {
                return Date[].class;
            }
            case 11: 
            case 15: {
                return Time[].class;
            }
            case 12: {
                return Timestamp[].class;
            }
            case 13: {
                return TimestampTz[].class;
            }
            case 14: {
                return VerticaDayTimeInterval[].class;
            }
            case 114: {
                return VerticaYearMonthInterval[].class;
            }
            case 20: {
                return UUID[].class;
            }
            case 16: {
                return BigDecimal[].class;
            }
            case 8: 
            case 9: 
            case 115: {
                return String[].class;
            }
            case 17: 
            case 116: 
            case 117: {
                return byte[][].class;
            }
            case 300: 
            case 302: {
                return VerticaStruct[].class;
            }
            case 301: {
                return Object[].class;
            }
        }
        throw new ClientErrorException("ColumnDescription oid must be an ArrayOid. Currently is " + columnDescription2.getTypeOID());
    }

    public static Object parseJsonElement(ColumnDescription columnDescription, JsonElement jsonElement) throws ClientErrorException, UnsupportedEncodingException {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        int n = columnDescription.getTypeOID();
        switch (n) {
            case 5: {
                return jsonElement.getAsBoolean();
            }
            case 6: {
                return jsonElement.getAsLong();
            }
            case 7: {
                return jsonElement.getAsDouble();
            }
            case 10: {
                return DateDeserializerImpl.deserializeDate(null, jsonElement.getAsString().getBytes(), 0);
            }
            case 12: {
                byte[] byArray = jsonElement.getAsString().getBytes();
                if (TypeUtils.isInfinityTimestamp(byArray)) {
                    return TypeUtils.getInfinityTimestamp(byArray);
                }
                Calendar calendar = Calendar.getInstance();
                DateDeserializerImpl.setCalendar(12, calendar, byArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(TimestampTZDeserializerImpl.getNano(byArray));
                return timestamp;
            }
            case 13: {
                return TypeUtils.deserializeTimestampTZ_JsonFormat(jsonElement.getAsString().getBytes());
            }
            case 14: {
                VerticaDayTimeInterval verticaDayTimeInterval = IntervalDeserializerImpl.parseInterval(TypeUtils.getSQLTypeFromOID(n, -1), -1, jsonElement.getAsString().getBytes(), 0);
                return verticaDayTimeInterval;
            }
            case 114: {
                VerticaYearMonthInterval verticaYearMonthInterval = IntervalYMDeserializerImpl.parseIntervalYM(TypeUtils.getSQLTypeFromOID(n, -1), jsonElement.getAsString().getBytes(), 0);
                return verticaYearMonthInterval;
            }
            case 20: {
                return UUID.fromString(jsonElement.getAsString());
            }
            case 16: {
                return new BigDecimal(jsonElement.getAsString());
            }
            case 11: 
            case 15: {
                return TypeUtils.deserializeTimeFromTextEncoding(n, jsonElement.getAsString().getBytes());
            }
            case 17: 
            case 116: 
            case 117: {
                return jsonElement.getAsString().getBytes();
            }
            case 300: 
            case 302: {
                return StructDeserializerImpl.parseStruct(columnDescription, jsonElement);
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: 
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: {
                return TypeUtils.parseArray(columnDescription, jsonElement);
            }
        }
        return jsonElement.getAsString();
    }

    public static Object[] parseArray(ColumnDescription columnDescription, JsonElement jsonElement) throws ClientErrorException, UnsupportedEncodingException {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ColumnDescription columnDescription2 = TypeUtils.getArrayTypeColumnDescription(columnDescription);
        Class<?> clazz = TypeUtils.getArrayClassForColumn(columnDescription);
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz == null || clazz2 == null) {
            throw new ClientErrorException("Internal Error: Column " + columnDescription.getName() + " does not have array type information.");
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz2, jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Array.set(objectArray, i, TypeUtils.parseJsonElement(columnDescription2, jsonArray.get(i)));
        }
        return objectArray;
    }

    private static boolean isInfinityTimestamp(byte[] byArray) {
        return byArray[0] == 105 || byArray[0] == 45 && byArray[1] == 105;
    }

    private static TimestampTz getInfinityTimestamp(byte[] byArray) {
        Calendar calendar = Calendar.getInstance();
        Timestamp timestamp = new Timestamp(byArray[0] == 45 ? -9223372036832400000L : 9223372036825200000L);
        timestamp.setNanos(0);
        return new TimestampTz(timestamp, calendar);
    }

    public static TimestampTz deserializeTimestampTZ_JsonFormat(byte[] byArray) throws UnsupportedEncodingException {
        if (TypeUtils.isInfinityTimestamp(byArray)) {
            return TypeUtils.getInfinityTimestamp(byArray);
        }
        Calendar calendar = TimestampTZDeserializerImpl.getTimeZoneCalendar(byArray);
        DateDeserializerImpl.setCalendar(13, calendar, byArray);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(TimestampTZDeserializerImpl.getNano(byArray));
        return new TimestampTz(timestamp, calendar);
    }

    public static List<byte[]> serialize(ParameterInputValue parameterInputValue, int n, int n2, boolean bl, List<DataWrapper> list, boolean bl2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            block37: {
                block36: {
                    if (!parameterInputValue.isPushed()) break block36;
                    switch (n) {
                        case -4: 
                        case -3: 
                        case -2: {
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    byte[] byArray = (byte[])list.get(i).getObject();
                                    if (byArray == null) continue;
                                    arrayList.add(TypeUtils.binaryToString(byArray));
                                }
                            }
                            break block37;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            TypeUtils.serializeChar(list, arrayList);
                            break;
                        }
                        default: {
                            TypeUtils.serializeChar(list, arrayList);
                            break;
                        }
                    }
                    break block37;
                }
                DataWrapper dataWrapper = parameterInputValue.getData();
                String string = null;
                if (dataWrapper.isNull()) {
                    return arrayList;
                }
                if (parameterInputValue.getMetadata().shouldConvertInputToString()) {
                    string = (String)dataWrapper.getObject();
                } else {
                    switch (n) {
                        case -7: {
                            string = dataWrapper.getBit() != false ? "1" : "0";
                            break;
                        }
                        case -5: {
                            string = dataWrapper.getInteger().toString();
                            break;
                        }
                        case 1: {
                            string = dataWrapper.getChar();
                            break;
                        }
                        case 12: {
                            string = dataWrapper.getVarChar();
                            break;
                        }
                        case -2: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getBinary()));
                            break;
                        }
                        case -3: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getVarBinary()));
                            break;
                        }
                        case -4: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getLongVarBinary()));
                            break;
                        }
                        case 91: {
                            string = dataWrapper.getDate().toString();
                            break;
                        }
                        case 8: {
                            string = dataWrapper.getDouble().toString();
                            break;
                        }
                        case 2: {
                            string = dataWrapper.getNumeric().toString();
                            break;
                        }
                        case -11: {
                            string = dataWrapper.getGuid().toString();
                            break;
                        }
                        case 92: {
                            TimeTz timeTz = dataWrapper.getTimeTz();
                            if (timeTz != null) {
                                Calendar calendar = timeTz.getTimezoneCalendar();
                                calendar.setTimeInMillis(timeTz.getTime());
                                StringBuilder stringBuilder = new StringBuilder(21);
                                TypeUtils.appendTime(stringBuilder, calendar, calendar.get(14) * 1000000);
                                if (n2 == 15 || bl) {
                                    TypeUtils.appendTimeZone(stringBuilder, calendar, timeTz.getTime());
                                }
                                string = stringBuilder.toString();
                                break;
                            }
                            string = dataWrapper.getTime().toString();
                            break;
                        }
                        case 93: {
                            TimestampTz timestampTz = dataWrapper.getTimestampTz();
                            if (timestampTz != null) {
                                Calendar calendar = timestampTz.getTimezoneCalendar();
                                Timestamp timestamp = timestampTz.getAdjustedTimestamp();
                                StringBuilder stringBuilder = new StringBuilder(32);
                                stringBuilder.append(timestamp.toString());
                                stringBuilder.append(' ');
                                if (n2 == 13 || bl) {
                                    TypeUtils.appendTimeZone(stringBuilder, calendar, timestamp.getTime());
                                }
                                string = stringBuilder.toString();
                                break;
                            }
                            string = dataWrapper.getTime().toString();
                            break;
                        }
                        case 101: 
                        case 102: 
                        case 107: {
                            DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)dataWrapper.getInterval();
                            String string2 = dSIMonthSpan.isNegative() ? "-" : "";
                            string = String.format("%s%d-%d", string2, dSIMonthSpan.getYear(), dSIMonthSpan.getMonth());
                            break;
                        }
                        case 103: 
                        case 108: 
                        case 109: 
                        case 110: {
                            DSITimeSpan dSITimeSpan = (DSITimeSpan)dataWrapper.getInterval();
                            String string3 = dSITimeSpan.isNegative() ? "-" : "";
                            string = String.format("%s%d %d:%d:%d.%d", string3, dSITimeSpan.getDay(), dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                            break;
                        }
                        case 104: 
                        case 105: 
                        case 106: 
                        case 111: 
                        case 112: 
                        case 113: {
                            DSITimeSpan dSITimeSpan = (DSITimeSpan)dataWrapper.getInterval();
                            String string4 = dSITimeSpan.isNegative() ? "-" : "";
                            string = String.format("%s%d:%d:%d.%d", string4, dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                            break;
                        }
                        default: {
                            string = dataWrapper.getObject().toString();
                        }
                    }
                }
                if (arrayList.size() == 0) {
                    arrayList.add(ProtocolUtils.encodeUTF8(string));
                }
            }
            return arrayList;
        }
        catch (ParamAlreadyPushedException paramAlreadyPushedException) {
            throw new RuntimeException("Logic error: pushed parameter handled as a non-pushed parameter.");
        }
        catch (DefaultParamException defaultParamException) {
            throw new RuntimeException("No default parameter support yet");
        }
        catch (IncorrectTypeException incorrectTypeException) {
            incorrectTypeException.printStackTrace();
            throw new RuntimeException("Bind not implemented for this type");
        }
    }

    private static void serializeChar(List<DataWrapper> list, List<byte[]> list2) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i).getObject();
                if (string == null) continue;
                list2.add(ProtocolUtils.encodeUTF8(string));
            }
        }
    }

    private static void appendTime(StringBuilder stringBuilder, Calendar calendar, int n) {
        int n2 = calendar.get(11);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        int n3 = calendar.get(12);
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append(':');
        int n4 = calendar.get(13);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        if (n > 0) {
            char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
            char[] cArray2 = Integer.toString(n).toCharArray();
            System.arraycopy(cArray2, 0, cArray, cArray.length - cArray2.length, cArray2.length);
            stringBuilder.append('.');
            stringBuilder.append(cArray, 0, 6);
        }
    }

    private static void appendTimeZone(StringBuilder stringBuilder, Calendar calendar, long l) {
        int n = calendar.getTimeZone().getOffset(l) / 1000 / 60;
        int n2 = Math.abs(n);
        int n3 = n2 / 60;
        int n4 = n2 - n3 * 60;
        stringBuilder.append(n >= 0 ? " +" : " -");
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
    }

    public static int getColumnSize(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: {
                return 20;
            }
            case 7: {
                return 15;
            }
            case 16: {
                return TypeUtils.getPrecision(n, n2);
            }
            case 10: {
                return 10;
            }
            case 11: 
            case 15: {
                int n3 = TypeUtils.getPrecision(n, n2);
                if (n3 == 0) {
                    return 8;
                }
                return 9 + n3;
            }
            case 12: 
            case 13: {
                int n4 = TypeUtils.getPrecision(n, n2);
                if (n4 == 0) {
                    return 19;
                }
                return 20 + n4;
            }
            case 14: 
            case 114: {
                int n5 = TypeUtils.getIntervalLeadingPrecision(n, n2);
                int n6 = TypeUtils.getPrecision(n, n2);
                int n7 = TypeUtils.getSQLTypeFromOID(n, n2);
                switch (n7) {
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: {
                        return n5;
                    }
                    case 107: 
                    case 108: 
                    case 111: {
                        return 3 + n5;
                    }
                    case 109: {
                        return 6 + n5;
                    }
                    case 106: {
                        if (n6 == 0) {
                            return n5;
                        }
                        return n5 + 1 + n6;
                    }
                    case 110: {
                        if (n6 == 0) {
                            return 9 + n5;
                        }
                        return 9 + n5 + 1 + n6;
                    }
                    case 112: {
                        if (n6 == 0) {
                            return 6 + n5;
                        }
                        return 6 + n5 + 1 + n6;
                    }
                    case 113: {
                        if (n6 == 0) {
                            return 3 + n5;
                        }
                        return 3 + n5 + 1 + n6;
                    }
                }
                throw new ClientErrorException("Invalid interval range");
            }
            case 115: 
            case 116: {
                if (n2 <= -1) {
                    return 32000000;
                }
                return n2 - 4;
            }
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 117: {
                if (n2 <= -1) {
                    return 65000;
                }
                return n2 - 4;
            }
            case 20: {
                return 16;
            }
        }
        if (n2 <= -1) {
            return 65000;
        }
        return n2 - 4;
    }

    public static String getTypeName(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 5: {
                return "Boolean";
            }
            case 6: {
                return "Integer";
            }
            case 7: {
                return "Float";
            }
            case 8: {
                return "Char";
            }
            case 4: 
            case 9: {
                return "Varchar";
            }
            case 115: {
                return "Long Varchar";
            }
            case 10: {
                return "Date";
            }
            case 11: {
                return "Time";
            }
            case 15: {
                return "TimeTz";
            }
            case 12: {
                return "Timestamp";
            }
            case 13: {
                return "TimestampTz";
            }
            case 14: 
            case 114: {
                int n3 = TypeUtils.getIntervalRange(n, n2);
                switch (n3) {
                    case 101: {
                        return "Interval Year";
                    }
                    case 107: {
                        return "Interval Year to Month";
                    }
                    case 102: {
                        return "Interval Month";
                    }
                    case 103: {
                        return "Interval Day";
                    }
                    case 108: {
                        return "Interval Day to Hour";
                    }
                    case 109: {
                        return "Interval Day to Minute";
                    }
                    case 110: {
                        return "Interval Day to Second";
                    }
                    case 104: {
                        return "Interval Hour";
                    }
                    case 111: {
                        return "Interval Hour to Minute";
                    }
                    case 112: {
                        return "Interval Hour to Second";
                    }
                    case 105: {
                        return "Interval Minute";
                    }
                    case 113: {
                        return "Interval Minute to Second";
                    }
                    case 106: {
                        return "Interval Second";
                    }
                    case 10: {
                        return "Interval";
                    }
                }
                throw new ClientErrorException("Invalid interval range: " + n3);
            }
            case 117: {
                return "Binary";
            }
            case 17: {
                return "Varbinary";
            }
            case 116: {
                return "Long Varbinary";
            }
            case 16: {
                return "Numeric";
            }
            case 20: {
                return "Uuid";
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: {
                return "Array";
            }
            case 300: 
            case 302: {
                return "Struct";
            }
        }
        return "Unknown";
    }

    public static int getSQLTypeFromOID(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 4: {
                return 12;
            }
            case 5: {
                return -7;
            }
            case 6: {
                return -5;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 12;
            }
            case 115: {
                return -1;
            }
            case 10: {
                return 91;
            }
            case 11: 
            case 15: {
                return 92;
            }
            case 12: 
            case 13: {
                return 93;
            }
            case 14: 
            case 114: {
                return TypeUtils.getIntervalRange(n, n2);
            }
            case 117: {
                return -2;
            }
            case 17: {
                return -3;
            }
            case 116: {
                return -4;
            }
            case 16: {
                return 2;
            }
            case 20: {
                return -11;
            }
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: 
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: {
                return 2003;
            }
            case 300: 
            case 302: {
                return 2002;
            }
        }
        return 12;
    }

    public static int getOIDFromSQLType(int n) {
        switch (n) {
            case -7: {
                return 5;
            }
            case -5: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case -1: {
                return 115;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 11;
            }
            case 93: {
                return 12;
            }
            case -2: {
                return 117;
            }
            case -3: {
                return 17;
            }
            case -4: {
                return 116;
            }
            case 2: {
                return 16;
            }
            case 101: 
            case 102: 
            case 107: {
                return 114;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 14;
            }
            case -11: {
                return 20;
            }
        }
        return 4;
    }

    public static int getPrecision(int n, int n2) throws ClientErrorException {
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: {
                return 19;
            }
            case 7: {
                return 15;
            }
            case 16: {
                if (n2 == -1) {
                    return 1024;
                }
                return n2 - 4 >> 16 & 0xFFFF;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 114: {
                if (n2 == -1) {
                    return 6;
                }
                return n2 & 0xF;
            }
        }
        return TypeUtils.getColumnSize(n, n2);
    }

    private static boolean isStringType(int n) {
        switch (n) {
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 115: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private static int getIntervalLeadingPrecision(int n, int n2) throws ClientErrorException {
        if (n != 14 && n != 114) {
            throw new ClientErrorException("Invalid OID: " + n);
        }
        int n3 = TypeUtils.getIntervalRange(n, n2);
        if (n2 == -1) {
            if (n == 14) {
                n3 = 110;
            } else if (n == 114) {
                n3 = 107;
            }
        }
        switch (n3) {
            case 101: 
            case 107: {
                return 18;
            }
            case 102: {
                return 19;
            }
            case 103: 
            case 108: 
            case 109: 
            case 110: {
                return 9;
            }
            case 104: 
            case 111: 
            case 112: {
                return 10;
            }
            case 105: 
            case 113: {
                return 12;
            }
            case 106: {
                return 13;
            }
        }
        throw new ClientErrorException("Unexpected SQL type [" + n3 + "]");
    }

    private static int getIntervalRange(int n, int n2) throws ClientErrorException {
        if (n2 == -1) {
            if (n == 114) {
                return 107;
            }
            if (n == 14) {
                return 110;
            }
        }
        if (n == 114) {
            if ((n2 & 0x60000) == 393216) {
                return 107;
            }
            if ((n2 & 0x40000) == 262144) {
                return 101;
            }
            if ((n2 & 0x20000) == 131072) {
                return 102;
            }
            return 107;
        }
        if (n == 14) {
            if ((n2 & 0x1C080000) == 470286336) {
                return 110;
            }
            if ((n2 & 0xC080000) == 0xC080000) {
                return 109;
            }
            if ((n2 & 0x4080000) == 0x4080000) {
                return 108;
            }
            if ((n2 & 0x80000) == 524288) {
                return 103;
            }
            if ((n2 & 0x1C000000) == 0x1C000000) {
                return 112;
            }
            if ((n2 & 0xC000000) == 0xC000000) {
                return 111;
            }
            if ((n2 & 0x4000000) == 0x4000000) {
                return 104;
            }
            if ((n2 & 0x18000000) == 0x18000000) {
                return 113;
            }
            if ((n2 & 0x8000000) == 0x8000000) {
                return 105;
            }
            if ((n2 & 0x10000000) == 0x10000000) {
                return 106;
            }
            return 110;
        }
        throw new ClientErrorException("Invalid OID: " + n);
    }

    private static boolean isSigned(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 14: 
            case 16: 
            case 114: {
                return true;
            }
        }
        return false;
    }

    public static TypeMetadata createTypeMetadata(int n, int n2, String string) throws ClientErrorException {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(TypeUtils.getSQLTypeFromOID(n, n2), TypeUtils.isSigned(n));
            short s = 0;
            if (!TypeUtils.isStringType(n)) {
                s = (short)TypeUtils.getPrecision(n, n2);
            }
            typeMetadata.setPrecision(s);
            if (!TypeUtils.isStringType(n)) {
                if (n == 16) {
                    short s2 = (short)NumericDeserializerImpl.getNumericScale(n2);
                    typeMetadata.setScale(s2);
                } else if (n == 14 || n == 114) {
                    typeMetadata.setScale(s);
                    typeMetadata.setIntervalPrecision(TypeUtils.getIntervalLeadingPrecision(n, n2));
                }
            }
            typeMetadata.setTypeName(string);
            return typeMetadata;
        }
        catch (ErrorException errorException) {
            throw new ClientErrorException(errorException.getMessage());
        }
    }

    public static byte[] stringBytesToBinary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 92) {
                int n3;
                byte by2;
                if ((by2 = byArray[++i]) == 92) {
                    byArray2[n2++] = 92;
                    continue;
                }
                if ((n3 = (by2 - 48) * 64 + (byArray[++i] - 48) * 8 + (byArray[++i] - 48)) > 127) {
                    n3 -= 256;
                }
                byArray2[n2++] = (byte)n3;
                continue;
            }
            byArray2[n2++] = by;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    private static byte[] binaryToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 3 * (byArray.length / 256));
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            byteArrayOutputStream.write(byArray, n, i - n);
            byteArrayOutputStream.write(BACKSLASH_ESCAPE, 0, BACKSLASH_ESCAPE.length);
            n = i + 1;
        }
        if (n == 0) {
            return byArray;
        }
        if (n < byArray.length) {
            byteArrayOutputStream.write(byArray, n, byArray.length - n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Time deserializeTimeFromTextEncoding(int n, byte[] byArray) throws UnsupportedEncodingException, ClientErrorException {
        int n2;
        int[] nArray = new int[4];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] == 58 || byArray[n2] == 58 || byArray[n2] == 32) {
                ++n3;
                continue;
            }
            if (byArray[n2] == 46) {
                ++n3;
                n4 = n2 + 1;
                continue;
            }
            if (byArray[n2] == 43 || byArray[n2] == 45) {
                n5 = n2;
                bl = true;
                break;
            }
            nArray[n3] = byArray[n2] - 48 + nArray[n3] * 10;
        }
        if (n5 == 0) {
            n5 = byArray.length;
        }
        long l = (long)nArray[0] * 3600000L + (long)nArray[1] * 60000L + (long)(nArray[2] * 1000);
        for (int i = n5 - n4; i < 9; ++i) {
            nArray[3] = nArray[3] * 10;
        }
        l += (long)((nArray[3] + 500000) / 1000000);
        Calendar calendar = null;
        if (bl) {
            if (n != 15) {
                throw new ClientErrorException("Invalid timetz type " + n);
            }
            int n6 = n2;
            int n7 = TimeDeserializerImpl.getTimeZoneOffSet(byArray, n6);
            calendar = Calendar.getInstance(new SimpleTimeZone(n7, new String(byArray, n6, byArray.length - n6, VConnection.VERTICA_CHARSET)));
            TimeTz timeTz = new TimeTz(new Time(l -= (long)n7), calendar);
            return timeTz;
        }
        long l2 = Calendar.getInstance().getTimeZone().getOffset(0L);
        l -= l2;
        if (n != 11) {
            throw new ClientErrorException("Invalid time type " + n);
        }
        Time time = new Time(l);
        return time;
    }
}

