/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.vertica.jdbc.jdbc42.S42ResultSetMetaData;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import com.vertica.utilities.conversion.TypeConverter;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42UpdatableForwardResultSet
extends S41UpdatableForwardResultSet {
    public S42UpdatableForwardResultSet(SStatement statement, IResultSet resultSet, ILogger logger) throws SQLException {
        super(statement, resultSet, logger);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue, SQLType targetSqlType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, targetSqlType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            this.clearStream(columnIndex);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(columnIndex - 1).getTypeMetadata();
            int targetIntSqlType = targetSqlType.getVendorTypeNumber();
            DataWrapper data = new DataWrapper();
            if (null == columnValue) {
                data.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper valueData = new DataWrapper();
                    valueData.setData(TypeConverter.getSqlType(columnValue), columnValue);
                    data = TypeConverter.toType(valueData, columnValue, targetIntSqlType, this.m_warningListener);
                    data = TypeConverter.toType(data, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException e) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(columnValue));
                }
            }
            this.m_updateValues.set(columnIndex - 1, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue, SQLType targetSqlType, int scale) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, targetSqlType, scale);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            this.clearStream(columnIndex);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(columnIndex - 1).getTypeMetadata();
            int targetIntSqlType = targetSqlType.getVendorTypeNumber();
            DataWrapper data = new DataWrapper();
            if (null == columnValue) {
                data.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper valueData = new DataWrapper();
                    valueData.setData(TypeConverter.getSqlType(columnValue), columnValue);
                    data = TypeConverter.toType(valueData, columnValue, targetIntSqlType, this.m_warningListener);
                    data = TypeConverter.toType(data, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException e) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(columnValue));
                }
                if (JDBCType.NUMERIC.getVendorTypeNumber().intValue() == data.getType() || JDBCType.DECIMAL.getVendorTypeNumber().intValue() == data.getType()) {
                    BigDecimal decimalValue = (BigDecimal)data.getObject();
                    data.setData(data.getType(), decimalValue.setScale(scale, 4));
                }
            }
            this.m_updateValues.set(columnIndex - 1, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(String columnName, Object columnValue, SQLType targetSqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, targetSqlType);
        this.updateObject(this.findColumn(columnName), columnValue, targetSqlType);
    }

    @Override
    public void updateObject(String columnName, Object columnValue, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, targetSqlType, scale);
        this.updateObject(this.findColumn(columnName), columnValue, targetSqlType, scale);
    }
}

