/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContext;
import com.vertica.dsi.dataengine.utilities.ExecutionContextStatus;
import com.vertica.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterOutputValue;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ExecutionContexts {
    private int m_paramSetCount;
    private int m_outputParamCount;
    private ArrayList<ParameterMetadata> m_metadata;
    private ArrayList<ArrayList<DataWrapper>> m_outputData;
    private ArrayList<ExecutionContext> m_contexts;

    public ExecutionContexts(ArrayList<ParameterMetadata> metadata, ArrayList<ArrayList<ParameterInputValue>> inputData) {
        this(metadata, inputData, null);
    }

    public ExecutionContexts(ArrayList<ParameterMetadata> metadata, ArrayList<ArrayList<ParameterInputValue>> inputData, ParameterGeneratedValues generatedParams) {
        this.m_paramSetCount = inputData.size();
        this.m_metadata = metadata;
        ArrayList<Integer> outputParams = new ArrayList<Integer>();
        this.m_outputParamCount = 0;
        int parameterCount = metadata.size();
        for (int i = 0; i < parameterCount; ++i) {
            ParameterMetadata paramMetadata = metadata.get(i);
            if (paramMetadata.getParameterType() != ParameterType.OUTPUT && paramMetadata.getParameterType() != ParameterType.RETURN_VALUE && paramMetadata.getParameterType() != ParameterType.INPUT_OUTPUT) continue;
            ++this.m_outputParamCount;
            outputParams.add(i);
        }
        this.m_outputData = new ArrayList(this.m_paramSetCount);
        this.m_contexts = new ArrayList(this.m_paramSetCount);
        for (int j = 0; j < this.m_paramSetCount; ++j) {
            ArrayList<DataWrapper> outputSet = new ArrayList<DataWrapper>(this.m_outputParamCount);
            ArrayList<ParameterOutputValue> outputValues = new ArrayList<ParameterOutputValue>(this.m_outputParamCount);
            for (int k = 0; k < this.m_outputParamCount; ++k) {
                ParameterMetadata paramMetadata = metadata.get((Integer)outputParams.get(k));
                ParameterOutputValue outputValue = new ParameterOutputValue(paramMetadata);
                outputValues.add(outputValue);
                outputSet.add(outputValue.getData());
            }
            this.m_outputData.add(outputSet);
            this.m_contexts.add(new ExecutionContext(new ArrayList<ParameterInputValue>((Collection)inputData.get(j)), outputValues, generatedParams));
        }
    }

    public Iterator<ExecutionContext> contextIterator() {
        return this.m_contexts.iterator();
    }

    public ExecutionContextStatus getContextStatus(int paramSet) {
        return this.m_contexts.get(paramSet).getStatus();
    }

    public int getCount() {
        return this.m_paramSetCount;
    }

    public ArrayList<ParameterMetadata> getMetadata() {
        return this.m_metadata;
    }

    public Iterator<ArrayList<DataWrapper>> outputIterator() {
        return this.m_outputData.iterator();
    }
}

