/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.security;

import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.security.ISecurityContext;
import com.vertica.support.security.SimbaCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class SimbaSecurityContext
implements ISecurityContext {
    private final SimbaCredentials m_credentials;
    private final GSSManager m_manager;
    private final String m_spn;
    private final ILogger m_logger;
    private GSSContext m_context;
    private static Oid GSS_KRB5_MECH_OID;
    private boolean m_requestMutualAuthentication = false;
    private boolean m_requestDelegation = false;

    public SimbaSecurityContext(SimbaCredentials credentials, ILogger logger, String spn, GSSManager gssManager) throws GSSException {
        if (null == GSS_KRB5_MECH_OID) {
            GSS_KRB5_MECH_OID = new Oid("1.2.840.113554.1.2.2");
        }
        this.m_manager = gssManager;
        this.m_credentials = credentials;
        this.m_spn = spn;
        this.m_logger = logger;
        LogUtilities.logFunctionEntrance(this.m_logger, credentials, logger, spn, gssManager);
    }

    @Override
    public byte[] getToken() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.updateToken(null);
    }

    @Override
    public byte[] updateToken(byte[] in_token) throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{in_token});
        if (null == in_token) {
            GSSName gssname = this.m_manager.createName(this.m_spn, null, GSS_KRB5_MECH_OID);
            this.m_context = this.m_manager.createContext(gssname, GSS_KRB5_MECH_OID, this.m_credentials.getCredentialHandle(), 0);
            this.m_context.requestMutualAuth(this.m_requestMutualAuthentication);
            this.m_context.requestCredDeleg(this.m_requestDelegation);
            in_token = new byte[]{};
        }
        return this.m_context.initSecContext(in_token, 0, in_token.length);
    }

    @Override
    public void setRequestMutualAuthentication(boolean reqMutualAuth) throws Exception {
        if (null != this.m_context) {
            this.m_context.requestMutualAuth(reqMutualAuth);
        }
        this.m_requestMutualAuthentication = reqMutualAuth;
    }

    @Override
    public boolean getRequestMutualAuthentication() {
        return this.m_requestMutualAuthentication;
    }

    @Override
    public void setRequestDelegation(boolean reqDelegation) throws Exception {
        if (null != this.m_context) {
            this.m_context.requestCredDeleg(reqDelegation);
        }
        this.m_requestDelegation = reqDelegation;
    }

    @Override
    public boolean getRequestDelegation() {
        return this.m_requestDelegation;
    }
}

