/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.exceptions.OptionalFeatureNotImplementedException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.security.ICredentials;
import javax.naming.OperationNotSupportedException;

public abstract class DSIEnvironment
implements IEnvironment {
    private final AttributeDataMap m_settings = new AttributeDataMap();
    private IDriver m_parentDriver = null;
    private IWarningListener m_warningListener = null;

    public DSIEnvironment(IDriver parent) throws ErrorException {
        this.m_parentDriver = parent;
        LogUtilities.logFunctionEntrance(this.getLog(), parent);
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
    }

    @Override
    public IConnection createConnection(ICredentials credentials) throws ErrorException, OperationNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLog(), credentials);
        throw new OperationNotSupportedException();
    }

    @Override
    public IMessageSource getMessageSource() {
        return this.m_parentDriver.getMessageSource();
    }

    public AttributeDataMap getAllProperties() {
        return this.m_settings;
    }

    @Override
    public Variant getProperty(int propKey) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey);
        if (this.m_settings.isProperty(propKey)) {
            return this.m_settings.getProperty(propKey);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(propKey));
    }

    @Override
    public void registerWarningListener(IWarningListener listener) {
        this.m_warningListener = listener;
    }

    @Override
    public void setProperty(int propKey, Variant propValue) throws OptionalFeatureNotImplementedException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey, propValue);
        if (1 == propKey && propValue.getType() == 6) {
            try {
                if (propValue.getLong() == 0L) {
                    throw new OptionalFeatureNotImplementedException(2, DSIMessageKey.OPTIONAL_FEAT_NOT_IMPL.name(), String.valueOf(propKey));
                }
            }
            catch (IncorrectTypeException e) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
            }
            catch (NumericOverflowException e) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
            }
        }
        this.m_settings.setProperty(propKey, propValue);
    }

    public ILogger getLog() {
        return this.m_parentDriver.getDriverLog();
    }

    public IDriver getParentDriver() {
        return this.m_parentDriver;
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(1, 3, 1L);
        this.m_settings.setProperty(2, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(3, 6, 3);
        this.m_settings.setProperty(4, 6, 1);
        this.m_settings.setProperty(5, 0, "");
        this.m_settings.setProperty(6, 0, "");
        this.m_settings.setProperty(7, 6, 40);
        this.m_settings.setProperty(4, 6, 1);
    }
}

