/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.DefaultParamException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.ParamAlreadyPushedException;
import com.vertica.jdbc.VerticaDayTimeInterval;
import com.vertica.jdbc.VerticaYearMonthInterval;
import com.vertica.localization.VMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.ProtocolUtils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.UUID;

public final class TypeUtils {
    private static final int INTERVAL_MASK_MONTH = 131072;
    private static final int INTERVAL_MASK_YEAR = 262144;
    private static final int INTERVAL_MASK_DAY = 524288;
    private static final int INTERVAL_MASK_HOUR = 0x4000000;
    private static final int INTERVAL_MASK_MINUTE = 0x8000000;
    private static final int INTERVAL_MASK_SECOND = 0x10000000;
    private static final int INTERVAL_MASK_YEAR2MONTH = 393216;
    private static final int INTERVAL_MASK_DAY2HOUR = 0x4080000;
    private static final int INTERVAL_MASK_DAY2MIN = 0xC080000;
    private static final int INTERVAL_MASK_DAY2SEC = 470286336;
    private static final int INTERVAL_MASK_HOUR2MIN = 0xC000000;
    private static final int INTERVAL_MASK_HOUR2SEC = 0x1C000000;
    private static final int INTERVAL_MASK_MIN2SEC = 0x18000000;
    private static final byte BACKSLASH = 92;
    private static final byte[] BACKSLASH_ESCAPE = new byte[]{92, 49, 51, 52};
    private static final long MILLIS_PER_MIN = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long POSITIVE_INFINITY_MILLISECONDS = 9223372036825200000L;
    private static final long NEGATIVE_INFINITY_MILLISECONDS = -9223372036832400000L;
    private static final int ASCII_OFFSET = 48;
    public static final int MAX_LONG_STRING_LEN = 32000000;
    public static final int MAX_STRING_LEN = 65000;

    public static boolean deserialize(int n, int n2, int n3, long l, long l2, DataWrapper dataWrapper, byte[] byArray) throws ErrorException {
        try {
            if (null == byArray) {
                dataWrapper.setNull(n);
                return false;
            }
            switch (n2) {
                case 4: 
                case 8: 
                case 9: 
                case 115: {
                    return TypeUtils.deserializeString(byArray, l, l2, dataWrapper);
                }
                case 11: 
                case 15: {
                    TypeUtils.deserializeTime(n2, dataWrapper, byArray);
                    return false;
                }
                case 5: 
                case 7: 
                case 16: {
                    dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    return false;
                }
                case 6: {
                    dataWrapper.setLongVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    return false;
                }
                case 12: {
                    if (!TypeUtils.deserializeInfinityTimestamp(dataWrapper, byArray)) {
                        dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
                    }
                    return false;
                }
                case 10: {
                    TypeUtils.deserializeDate(dataWrapper, byArray);
                    return false;
                }
                case 13: {
                    TypeUtils.deserializeTimestampTZ(dataWrapper, byArray);
                    return false;
                }
                case 17: 
                case 116: 
                case 117: {
                    if (l2 == -1L || l2 >= (long)byArray.length) {
                        if (0L != l) {
                            byte[] byArray2 = new byte[byArray.length - (int)l];
                            System.arraycopy(byArray, (int)l, byArray2, 0, (int)((long)byArray.length - l));
                            dataWrapper.setVarBinary(byArray2);
                        } else {
                            dataWrapper.setVarBinary(byArray);
                        }
                        return false;
                    }
                    byte[] byArray3 = new byte[Math.min((int)l2, byArray.length - (int)l)];
                    System.arraycopy(byArray, (int)l, byArray3, 0, byArray3.length);
                    dataWrapper.setVarBinary(byArray3);
                    return l + l2 < (long)byArray.length;
                }
                case 20: {
                    dataWrapper.setGuid(UUID.fromString(new String(byArray)));
                    return false;
                }
                case 114: {
                    VerticaYearMonthInterval verticaYearMonthInterval = TypeUtils.parseIntervalYM(n, byArray);
                    dataWrapper.setInterval(verticaYearMonthInterval);
                    return false;
                }
                case 14: {
                    VerticaDayTimeInterval verticaDayTimeInterval = TypeUtils.parseInterval(n, n3, byArray);
                    dataWrapper.setInterval(verticaDayTimeInterval);
                    return false;
                }
            }
            return TypeUtils.deserializeString(byArray, l, l2, dataWrapper);
        }
        catch (NumberFormatException numberFormatException) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_TYPE_CONVERSION_FAILED.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_TYPE_CONVERSION_FAILED.toString());
        }
    }

    private static int getYearWidth(byte[] byArray) {
        int n = 0;
        for (n = 0; byArray[n] != 45 && n < byArray.length; ++n) {
        }
        if (n == byArray.length) {
            n = -1;
        }
        return n;
    }

    private static int intFromBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 *= 10;
            n3 += byArray[i] - 48;
        }
        return n3;
    }

    public static boolean deserializeString(byte[] byArray, long l, long l2, DataWrapper dataWrapper) throws UnsupportedEncodingException {
        int n = 0;
        n = l2 > 0L && l2 < (long)byArray.length ? byArray.length : (int)l2;
        boolean bl = true;
        if (l2 == -1L || n > 0 && l + (long)n >= (long)byArray.length) {
            n = byArray.length - (int)l;
            bl = false;
        }
        String string = new String(byArray, (int)l, n, VConnection.VERTICA_CHARSET);
        dataWrapper.setLongVarChar(string);
        return bl;
    }

    private static void deserializeDate(DataWrapper dataWrapper, byte[] byArray) throws UnsupportedEncodingException {
        Calendar calendar = Calendar.getInstance();
        TypeUtils.setCalendar(10, calendar, byArray);
        int n = calendar.get(1);
        if (n > 9999 && calendar.get(0) == 1) {
            dataWrapper.setVarChar(new String(byArray, 0, byArray.length, VConnection.VERTICA_CHARSET));
        } else {
            dataWrapper.setDate(new Date(calendar.getTimeInMillis()));
        }
    }

    private static boolean deserializeInfinityTimestamp(DataWrapper dataWrapper, byte[] byArray) {
        if (byArray[0] == 105 || byArray[0] == 45 && byArray[1] == 105) {
            Calendar calendar = Calendar.getInstance();
            Timestamp timestamp = new Timestamp(byArray[0] == 45 ? -9223372036832400000L : 9223372036825200000L);
            timestamp.setNanos(0);
            dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
            return true;
        }
        return false;
    }

    private static void deserializeTimestampTZ(DataWrapper dataWrapper, byte[] byArray) throws UnsupportedEncodingException {
        int n;
        if (TypeUtils.deserializeInfinityTimestamp(dataWrapper, byArray)) {
            return;
        }
        for (n = byArray.length - 1; n >= 0 && byArray[n] != 43 && byArray[n] != 45; --n) {
        }
        String string = new String(byArray, n, byArray.length - n, VConnection.VERTICA_CHARSET);
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(TypeUtils.getTimeZoneOffSet(byArray, n), string));
        TypeUtils.setCalendar(13, calendar, byArray);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(TypeUtils.getNano(byArray));
        dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
    }

    private static void setCalendar(int n, Calendar calendar, byte[] byArray) {
        int n2 = TypeUtils.getYearWidth(byArray);
        calendar.set(1, TypeUtils.intFromBytes(byArray, 0, n2));
        calendar.set(2, TypeUtils.intFromBytes(byArray, n2 + 1, 2) - 1);
        calendar.set(5, TypeUtils.intFromBytes(byArray, n2 + 4, 2));
        if (n != 10) {
            calendar.set(11, TypeUtils.intFromBytes(byArray, n2 + 7, 2));
            calendar.set(12, TypeUtils.intFromBytes(byArray, n2 + 10, 2));
            calendar.set(13, TypeUtils.intFromBytes(byArray, n2 + 13, 2));
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        if (byArray[byArray.length - 2] == 66 && byArray[byArray.length - 1] == 67) {
            calendar.set(0, 0);
        }
    }

    private static void deserializeTime(int n, DataWrapper dataWrapper, byte[] byArray) throws UnsupportedEncodingException {
        int n2;
        int[] nArray = new int[4];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] == 58 || byArray[n2] == 58 || byArray[n2] == 32) {
                ++n3;
                continue;
            }
            if (byArray[n2] == 46) {
                ++n3;
                n4 = n2 + 1;
                continue;
            }
            if (byArray[n2] == 43 || byArray[n2] == 45) {
                n5 = n2;
                bl = true;
                break;
            }
            nArray[n3] = byArray[n2] - 48 + nArray[n3] * 10;
        }
        if (n5 == 0) {
            n5 = byArray.length;
        }
        long l = (long)nArray[0] * 3600000L + (long)nArray[1] * 60000L + (long)(nArray[2] * 1000);
        for (int i = n5 - n4; i < 9; ++i) {
            nArray[3] = nArray[3] * 10;
        }
        l += (long)((nArray[3] + 500000) / 1000000);
        Calendar calendar = null;
        if (bl) {
            assert (n == 15);
            int n6 = n2;
            int n7 = TypeUtils.getTimeZoneOffSet(byArray, n6);
            calendar = Calendar.getInstance(new SimpleTimeZone(n7, new String(byArray, n6, byArray.length - n6, VConnection.VERTICA_CHARSET)));
            TimeTz timeTz = new TimeTz(new Time(l -= (long)n7), calendar);
            dataWrapper.setTime(timeTz);
        } else {
            long l2 = Calendar.getInstance().getTimeZone().getOffset(0L);
            l -= l2;
            assert (n == 11);
            Time time = new Time(l);
            dataWrapper.setTime(time);
        }
    }

    private static int getTimeZoneOffSet(byte[] byArray, int n) {
        int n2 = byArray[n] == 45 ? -1 : 1;
        ++n;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[3];
        while (n < byArray.length) {
            if (byArray[n] == 58) {
                ++n3;
            } else {
                nArray[n3] = byArray[n] - 48 + nArray[n3] * 10;
            }
            ++n;
        }
        n4 = nArray[0] * 60 * 60 * 1000 + nArray[1] * 60 * 1000 + nArray[2] * 1000;
        return n4 *= n2;
    }

    public static List<byte[]> serialize(ParameterInputValue parameterInputValue, int n, int n2, boolean bl, List<DataWrapper> list, boolean bl2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            block40: {
                block39: {
                    if (!parameterInputValue.isPushed()) break block39;
                    switch (n) {
                        case -4: 
                        case -3: 
                        case -2: {
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    byte[] byArray = (byte[])list.get(i).getObject();
                                    if (byArray == null) continue;
                                    arrayList.add(TypeUtils.binaryToString(byArray));
                                }
                            }
                            break block40;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            TypeUtils.serializeChar(list, arrayList);
                            break;
                        }
                        default: {
                            TypeUtils.serializeChar(list, arrayList);
                            break;
                        }
                    }
                    break block40;
                }
                DataWrapper dataWrapper = parameterInputValue.getData();
                String string = null;
                if (dataWrapper.isNull()) {
                    return arrayList;
                }
                if (parameterInputValue.getMetadata().shouldConvertInputToString()) {
                    string = (String)dataWrapper.getObject();
                } else {
                    switch (n) {
                        case -7: {
                            string = dataWrapper.getBit() != false ? "1" : "0";
                            break;
                        }
                        case -5: {
                            string = dataWrapper.getInteger().toString();
                            break;
                        }
                        case 1: {
                            string = dataWrapper.getChar();
                            break;
                        }
                        case 12: {
                            string = dataWrapper.getVarChar();
                            break;
                        }
                        case -2: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getBinary()));
                            break;
                        }
                        case -3: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getVarBinary()));
                            break;
                        }
                        case -4: {
                            arrayList.add(TypeUtils.binaryToString(dataWrapper.getLongVarBinary()));
                            break;
                        }
                        case 91: {
                            string = dataWrapper.getDate().toString();
                            break;
                        }
                        case 8: {
                            string = dataWrapper.getDouble().toString();
                            break;
                        }
                        case 2: {
                            string = dataWrapper.getNumeric().toString();
                            break;
                        }
                        case -11: {
                            string = dataWrapper.getGuid().toString();
                            break;
                        }
                        case 92: {
                            TimeTz timeTz = dataWrapper.getTimeTz();
                            if (timeTz != null) {
                                Calendar calendar = timeTz.getTimezoneCalendar();
                                calendar.setTimeInMillis(timeTz.getTime());
                                StringBuilder stringBuilder = new StringBuilder(21);
                                TypeUtils.appendTime(stringBuilder, calendar, calendar.get(14) * 1000000);
                                if (n2 == 15 || bl) {
                                    TypeUtils.appendTimeZone(stringBuilder, calendar, timeTz.getTime());
                                }
                                string = stringBuilder.toString();
                                break;
                            }
                            string = dataWrapper.getTime().toString();
                            break;
                        }
                        case 93: {
                            TimestampTz timestampTz = dataWrapper.getTimestampTz();
                            if (timestampTz != null) {
                                Calendar calendar = timestampTz.getTimezoneCalendar();
                                Timestamp timestamp = timestampTz.getAdjustedTimestamp();
                                StringBuilder stringBuilder = new StringBuilder(32);
                                stringBuilder.append(timestamp.toString());
                                stringBuilder.append(' ');
                                if (n2 == 13 || bl) {
                                    TypeUtils.appendTimeZone(stringBuilder, calendar, timestamp.getTime());
                                }
                                string = stringBuilder.toString();
                                break;
                            }
                            string = dataWrapper.getTime().toString();
                            break;
                        }
                        case 101: 
                        case 102: 
                        case 107: {
                            DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)dataWrapper.getInterval();
                            if (dSIMonthSpan.isNegative()) {
                                string = String.format("-%d-%d", dSIMonthSpan.getYear(), dSIMonthSpan.getMonth());
                                break;
                            }
                            string = String.format("%d-%d", dSIMonthSpan.getYear(), dSIMonthSpan.getMonth());
                            break;
                        }
                        case 103: 
                        case 108: 
                        case 109: 
                        case 110: {
                            DSITimeSpan dSITimeSpan = (DSITimeSpan)dataWrapper.getInterval();
                            if (dSITimeSpan.isNegative()) {
                                string = String.format("-%d %d:%d:%d.%d", dSITimeSpan.getDay(), dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                                break;
                            }
                            string = String.format("%d %d:%d:%d.%d", dSITimeSpan.getDay(), dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                            break;
                        }
                        case 104: 
                        case 105: 
                        case 106: 
                        case 111: 
                        case 112: 
                        case 113: {
                            DSITimeSpan dSITimeSpan = (DSITimeSpan)dataWrapper.getInterval();
                            if (dSITimeSpan.isNegative()) {
                                string = String.format("-%d:%d:%d.%d", dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                                break;
                            }
                            string = String.format("%d:%d:%d.%d", dSITimeSpan.getHour(), dSITimeSpan.getMinute(), dSITimeSpan.getSecond(), dSITimeSpan.getFraction());
                            break;
                        }
                        default: {
                            string = dataWrapper.getObject().toString();
                        }
                    }
                }
                if (arrayList.size() == 0) {
                    arrayList.add(ProtocolUtils.encodeUTF8(string));
                }
            }
            return arrayList;
        }
        catch (ParamAlreadyPushedException paramAlreadyPushedException) {
            throw new RuntimeException("Logic error: pushed parameter handled as a non-pushed parameter.");
        }
        catch (DefaultParamException defaultParamException) {
            throw new RuntimeException("No default parameter support yet");
        }
        catch (IncorrectTypeException incorrectTypeException) {
            incorrectTypeException.printStackTrace();
            throw new RuntimeException("Bind not implemented for this type");
        }
    }

    private static void serializeChar(List<DataWrapper> list, List<byte[]> list2) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i).getObject();
                if (string == null) continue;
                list2.add(ProtocolUtils.encodeUTF8(string));
            }
        }
    }

    private static void appendTime(StringBuilder stringBuilder, Calendar calendar, int n) {
        int n2 = calendar.get(11);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        int n3 = calendar.get(12);
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append(':');
        int n4 = calendar.get(13);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        if (n > 0) {
            char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
            char[] cArray2 = Integer.toString(n).toCharArray();
            System.arraycopy(cArray2, 0, cArray, cArray.length - cArray2.length, cArray2.length);
            stringBuilder.append('.');
            stringBuilder.append(cArray, 0, 6);
        }
    }

    private static void appendTimeZone(StringBuilder stringBuilder, Calendar calendar, long l) {
        int n = calendar.getTimeZone().getOffset(l) / 1000 / 60;
        int n2 = Math.abs(n);
        int n3 = n2 / 60;
        int n4 = n2 - n3 * 60;
        stringBuilder.append(n >= 0 ? " +" : " -");
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
    }

    public static int getColumnSize(int n, int n2) {
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: {
                return 20;
            }
            case 7: {
                return 15;
            }
            case 16: {
                return TypeUtils.getPrecision(n, n2);
            }
            case 10: {
                return 10;
            }
            case 11: 
            case 15: {
                int n3 = TypeUtils.getPrecision(n, n2);
                if (n3 == 0) {
                    return 8;
                }
                return 9 + n3;
            }
            case 12: 
            case 13: {
                int n4 = TypeUtils.getPrecision(n, n2);
                if (n4 == 0) {
                    return 19;
                }
                return 20 + n4;
            }
            case 14: 
            case 114: {
                int n5 = TypeUtils.getIntervalLeadingPrecision(n, n2);
                int n6 = TypeUtils.getPrecision(n, n2);
                int n7 = TypeUtils.getSQLTypeFromOID(n, n2);
                switch (n7) {
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: {
                        return n5;
                    }
                    case 107: 
                    case 108: 
                    case 111: {
                        return 3 + n5;
                    }
                    case 109: {
                        return 6 + n5;
                    }
                    case 106: {
                        if (n6 == 0) {
                            return n5;
                        }
                        return n5 + 1 + n6;
                    }
                    case 110: {
                        if (n6 == 0) {
                            return 9 + n5;
                        }
                        return 9 + n5 + 1 + n6;
                    }
                    case 112: {
                        if (n6 == 0) {
                            return 6 + n5;
                        }
                        return 6 + n5 + 1 + n6;
                    }
                    case 113: {
                        if (n6 == 0) {
                            return 3 + n5;
                        }
                        return 3 + n5 + 1 + n6;
                    }
                }
                assert (false) : "Invalid interval range";
                throw new IllegalArgumentException("Invalid interval range");
            }
            case 115: 
            case 116: {
                if (n2 <= -1) {
                    return 32000000;
                }
                return n2 - 4;
            }
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 117: {
                if (n2 <= -1) {
                    return 65000;
                }
                return n2 - 4;
            }
            case 20: {
                return 16;
            }
        }
        if (n2 <= -1) {
            return 65000;
        }
        return n2 - 4;
    }

    public static String getTypeName(int n, int n2) {
        switch (n) {
            case 5: {
                return "Boolean";
            }
            case 6: {
                return "Integer";
            }
            case 7: {
                return "Float";
            }
            case 8: {
                return "Char";
            }
            case 4: 
            case 9: {
                return "Varchar";
            }
            case 115: {
                return "Long Varchar";
            }
            case 10: {
                return "Date";
            }
            case 11: {
                return "Time";
            }
            case 15: {
                return "TimeTz";
            }
            case 12: {
                return "Timestamp";
            }
            case 13: {
                return "TimestampTz";
            }
            case 14: 
            case 114: {
                int n3 = TypeUtils.getIntervalRange(n, n2);
                switch (n3) {
                    case 101: {
                        return "Interval Year";
                    }
                    case 107: {
                        return "Interval Year to Month";
                    }
                    case 102: {
                        return "Interval Month";
                    }
                    case 103: {
                        return "Interval Day";
                    }
                    case 108: {
                        return "Interval Day to Hour";
                    }
                    case 109: {
                        return "Interval Day to Minute";
                    }
                    case 110: {
                        return "Interval Day to Second";
                    }
                    case 104: {
                        return "Interval Hour";
                    }
                    case 111: {
                        return "Interval Hour to Minute";
                    }
                    case 112: {
                        return "Interval Hour to Second";
                    }
                    case 105: {
                        return "Interval Minute";
                    }
                    case 113: {
                        return "Interval Minute to Second";
                    }
                    case 106: {
                        return "Interval Second";
                    }
                    case 10: {
                        return "Interval";
                    }
                }
                assert (false) : "Invalid interval range " + n3;
                throw new IllegalArgumentException("Invalid interval range: " + n3);
            }
            case 117: {
                return "Binary";
            }
            case 17: {
                return "Varbinary";
            }
            case 116: {
                return "Long Varbinary";
            }
            case 16: {
                return "Numeric";
            }
            case 20: {
                return "Uuid";
            }
        }
        return "Unknown";
    }

    public static int getSQLTypeFromOID(int n, int n2) {
        switch (n) {
            case 4: {
                return 12;
            }
            case 5: {
                return -7;
            }
            case 6: {
                return -5;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 12;
            }
            case 115: {
                return -1;
            }
            case 10: {
                return 91;
            }
            case 11: 
            case 15: {
                return 92;
            }
            case 12: 
            case 13: {
                return 93;
            }
            case 14: 
            case 114: {
                return TypeUtils.getIntervalRange(n, n2);
            }
            case 117: {
                return -2;
            }
            case 17: {
                return -3;
            }
            case 116: {
                return -4;
            }
            case 16: {
                return 2;
            }
            case 20: {
                return -11;
            }
        }
        return 12;
    }

    public static int getOIDFromSQLType(int n) {
        switch (n) {
            case -7: {
                return 5;
            }
            case -5: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case -1: {
                return 115;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 11;
            }
            case 93: {
                return 12;
            }
            case -2: {
                return 117;
            }
            case -3: {
                return 17;
            }
            case -4: {
                return 116;
            }
            case 2: {
                return 16;
            }
            case 101: 
            case 102: 
            case 107: {
                return 114;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 14;
            }
            case -11: {
                return 20;
            }
        }
        return 4;
    }

    private static int getPrecision(int n, int n2) {
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: {
                return 19;
            }
            case 7: {
                return 15;
            }
            case 16: {
                if (n2 == -1) {
                    return 1024;
                }
                return n2 - 4 >> 16 & 0xFFFF;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 114: {
                if (n2 == -1) {
                    return 6;
                }
                return n2 & 0xF;
            }
        }
        return TypeUtils.getColumnSize(n, n2);
    }

    private static boolean isStringType(int n) {
        switch (n) {
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 115: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private static int getIntervalLeadingPrecision(int n, int n2) {
        if (n != 14 && n != 114) {
            assert (false) : "Invalid OID: " + n;
            throw new IllegalArgumentException("Invalid OID: " + n);
        }
        int n3 = TypeUtils.getIntervalRange(n, n2);
        if (n2 == -1) {
            if (n == 14) {
                n3 = 110;
            } else if (n == 114) {
                n3 = 107;
            }
        }
        switch (n3) {
            case 101: 
            case 107: {
                return 18;
            }
            case 102: {
                return 19;
            }
            case 103: 
            case 108: 
            case 109: 
            case 110: {
                return 9;
            }
            case 104: 
            case 111: 
            case 112: {
                return 10;
            }
            case 105: 
            case 113: {
                return 12;
            }
            case 106: {
                return 13;
            }
        }
        assert (false);
        return 0;
    }

    private static int getIntervalRange(int n, int n2) {
        if (n2 == -1) {
            if (n == 114) {
                return 107;
            }
            if (n == 14) {
                return 110;
            }
        }
        if (n == 114) {
            if ((n2 & 0x60000) == 393216) {
                return 107;
            }
            if ((n2 & 0x40000) == 262144) {
                return 101;
            }
            if ((n2 & 0x20000) == 131072) {
                return 102;
            }
            return 107;
        }
        if (n == 14) {
            if ((n2 & 0x1C080000) == 470286336) {
                return 110;
            }
            if ((n2 & 0xC080000) == 0xC080000) {
                return 109;
            }
            if ((n2 & 0x4080000) == 0x4080000) {
                return 108;
            }
            if ((n2 & 0x80000) == 524288) {
                return 103;
            }
            if ((n2 & 0x1C000000) == 0x1C000000) {
                return 112;
            }
            if ((n2 & 0xC000000) == 0xC000000) {
                return 111;
            }
            if ((n2 & 0x4000000) == 0x4000000) {
                return 104;
            }
            if ((n2 & 0x18000000) == 0x18000000) {
                return 113;
            }
            if ((n2 & 0x8000000) == 0x8000000) {
                return 105;
            }
            if ((n2 & 0x10000000) == 0x10000000) {
                return 106;
            }
            return 110;
        }
        assert (false) : "Invalid OID: " + n;
        throw new IllegalArgumentException("Invalid OID: " + n);
    }

    private static boolean isSigned(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 14: 
            case 16: 
            case 114: {
                return true;
            }
        }
        return false;
    }

    private static int getNano(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (byArray.length == 0) {
            return 0;
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 46; ++n2) {
        }
        if (n2 == byArray.length) {
            return 0;
        }
        for (n3 = ++n2; n3 < byArray.length; ++n3) {
            if (byArray[n3] != 43 && byArray[n3] != 45) continue;
            --n3;
            break;
        }
        int n6 = 100000;
        for (int i = n2; i <= n3; ++i) {
            n += (byArray[i] - 48) * n6;
            n6 /= 10;
        }
        n4 = n / 1000;
        n5 = n % 1000;
        n = n4 * 1000000 + n5 * 1000;
        return n;
    }

    public static TypeMetadata createTypeMetadata(int n, int n2, String string) {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(TypeUtils.getSQLTypeFromOID(n, n2), TypeUtils.isSigned(n));
            short s = 0;
            if (!TypeUtils.isStringType(n)) {
                s = (short)TypeUtils.getPrecision(n, n2);
            }
            typeMetadata.setPrecision(s);
            if (!TypeUtils.isStringType(n)) {
                if (n == 16) {
                    short s2 = n2 == -1 ? (short)15 : (short)(n2 - 4 & 0xFF);
                    typeMetadata.setScale(s2);
                } else if (n == 14 || n == 114) {
                    typeMetadata.setScale(s);
                    typeMetadata.setIntervalPrecision(TypeUtils.getIntervalLeadingPrecision(n, n2));
                }
            }
            typeMetadata.setTypeName(string);
            return typeMetadata;
        }
        catch (ErrorException errorException) {
            assert (false) : errorException.getMessage();
            return null;
        }
    }

    private static VerticaYearMonthInterval parseIntervalYM(int n, byte[] byArray) {
        int n2 = 0;
        boolean bl = false;
        if (byArray[n2] == 45) {
            ++n2;
            bl = true;
        }
        int n3 = 0;
        while (n2 < byArray.length && byArray[n2] != 45) {
            assert (Character.isDigit(byArray[n2]));
            n3 = n3 * 10 + (byArray[n2++] - 48);
        }
        if (n2 == byArray.length) {
            return n == 101 ? new VerticaYearMonthInterval(n, n3, 0, bl) : new VerticaYearMonthInterval(n, 0, n3, bl);
        }
        assert (n == 107);
        assert (byArray[n2] == 45);
        ++n2;
        int n4 = 0;
        while (n2 < byArray.length) {
            assert (Character.isDigit(byArray[n2]));
            n4 = n4 * 10 + (byArray[n2++] - 48);
        }
        return new VerticaYearMonthInterval(n, n3, n4, bl);
    }

    private static VerticaDayTimeInterval parseInterval(int n, int n2, byte[] byArray) {
        int n3 = 0;
        boolean bl = false;
        if (byArray[n3] == 45) {
            ++n3;
            bl = true;
        }
        int n4 = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        while (n3 < byArray.length && byArray[n3] != 32 && byArray[n3] != 58 && byArray[n3] != 46) {
            n4 = n4 * 10 + (byArray[n3++] - 48);
        }
        boolean bl2 = n3 < byArray.length && byArray[n3] == 32;
        ++n3;
        int n5 = 0;
        switch (n) {
            case 103: {
                n5 = 0;
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                n5 = bl2 || n3 > byArray.length ? 0 : 1;
                break;
            }
            case 104: 
            case 111: 
            case 112: {
                n5 = 1;
                break;
            }
            case 105: 
            case 113: {
                n5 = 2;
                break;
            }
            case 106: {
                n5 = 3;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        nArray[n5++] = n4;
        n4 = 0;
        if (n3 < byArray.length) {
            while (n3 < byArray.length) {
                if (byArray[n3] == 58 || byArray[n3] == 46) {
                    nArray[n5++] = n4;
                    n4 = 0;
                } else {
                    assert (Character.isDigit(byArray[n3])) : Character.valueOf((char)byArray[n3]);
                    n4 = n4 * 10 + (byArray[n3] - 48);
                }
                ++n3;
            }
            nArray[n5++] = n4;
            n4 = 0;
        }
        int n6 = 1;
        int n7 = TypeUtils.getPrecision(14, n2);
        for (n5 = 1; n5 < n7; ++n5) {
            n6 *= 10;
        }
        while (nArray[4] > 0 && nArray[4] < n6) {
            nArray[4] = nArray[4] * 10;
        }
        try {
            return new VerticaDayTimeInterval(n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], n7, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static byte[] stringBytesToBinary(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 92) {
                int n3;
                byte by2;
                if ((by2 = byArray[++i]) == 92) {
                    byArray2[n2++] = 92;
                    continue;
                }
                if ((n3 = (by2 - 48) * 64 + (byArray[++i] - 48) * 8 + (byArray[++i] - 48)) > 127) {
                    n3 -= 256;
                }
                byArray2[n2++] = (byte)n3;
                continue;
            }
            byArray2[n2++] = by;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    private static byte[] binaryToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 3 * (byArray.length / 256));
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            byteArrayOutputStream.write(byArray, n, i - n);
            byteArrayOutputStream.write(BACKSLASH_ESCAPE, 0, BACKSLASH_ESCAPE.length);
            n = i + 1;
        }
        if (n == 0) {
            return byArray;
        }
        if (n < byArray.length) {
            byteArrayOutputStream.write(byArray, n, byArray.length - n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

