/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.jdbc.VerticaDatabaseErrorInfo;
import com.vertica.localization.VMessageKey;
import com.vertica.support.LogLevel;
import com.vertica.support.exceptions.DataException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.FeatureNotSupportedException;
import com.vertica.support.exceptions.IntegrityConstraintViolationException;
import com.vertica.support.exceptions.InvalidAuthorizationException;
import com.vertica.support.exceptions.NonTransientConnectionException;
import com.vertica.support.exceptions.NonTransientException;
import com.vertica.support.exceptions.RecoverableException;
import com.vertica.support.exceptions.SyntaxErrorException;
import com.vertica.support.exceptions.TransactionRollbackException;
import com.vertica.support.exceptions.TransientConnectionException;
import com.vertica.support.exceptions.TransientException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class ServerErrorData
implements VerticaDatabaseErrorInfo {
    private static final Map<String, ExceptionType> s_sqlStateMappings = new HashMap<String, ExceptionType>();
    private static final Character SEVERITY;
    private static final Character MESSAGE;
    private static final Character DETAIL;
    private static final Character HINT;
    private static final Character POSITION;
    private static final Character WHERE;
    private static final Character FILE;
    private static final Character LINE;
    private static final Character ROUTINE;
    private static final Character SQLSTATE;
    private static final Character INTERNAL_POSITION;
    private static final Character INTERNAL_QUERY;
    private static final Character ERROR_CODE;
    private static final int DEFAULT_SERVER_ERRCODE = 100081;
    private final Hashtable<Character, String> m_mesgParts = new Hashtable();
    private final int m_verbosity;

    public ServerErrorData(String string, LogLevel logLevel, VConnection vConnection) {
        this.m_verbosity = logLevel.ordinal();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\u0000') continue;
            int n2 = ++i;
            while (i < n && cArray[i] != '\u0000') {
                ++i;
            }
            String string2 = new String(cArray, n2, i - n2);
            this.m_mesgParts.put(new Character(c), string2);
        }
    }

    private static void buildSQLStateMappings() {
        s_sqlStateMappings.put("0A", ExceptionType.FEATURE_NOT_IMPLEMENTED);
        s_sqlStateMappings.put("08", ExceptionType.NON_TRANSIENT_CONNECTION);
        s_sqlStateMappings.put("22", ExceptionType.DATA);
        s_sqlStateMappings.put("23", ExceptionType.INTEGRITY_CONSTRAINT_VIOLATION);
        s_sqlStateMappings.put("28", ExceptionType.INVALID_AUTHORIZATION);
        s_sqlStateMappings.put("40", ExceptionType.TRANSACTION_ROLLBACK);
        s_sqlStateMappings.put("42", ExceptionType.SYNTAX_ERROR);
        s_sqlStateMappings.put("2B", ExceptionType.DATA);
        s_sqlStateMappings.put("25", ExceptionType.TRANSACTION_ROLLBACK);
        s_sqlStateMappings.put("53", ExceptionType.TRANSIENT);
        s_sqlStateMappings.put("54", ExceptionType.NON_TRANSIENT);
        s_sqlStateMappings.put("55", ExceptionType.NON_TRANSIENT);
        s_sqlStateMappings.put("57", ExceptionType.TRANSIENT);
        s_sqlStateMappings.put("VC", ExceptionType.NON_TRANSIENT);
        s_sqlStateMappings.put("VD", ExceptionType.NON_TRANSIENT);
        s_sqlStateMappings.put("VP", ExceptionType.NON_TRANSIENT);
        s_sqlStateMappings.put("55V03", ExceptionType.TRANSACTION_ROLLBACK);
        s_sqlStateMappings.put("22V21", ExceptionType.NON_TRANSIENT);
        s_sqlStateMappings.put("53300", ExceptionType.TRANSIENT_CONNECTION);
        s_sqlStateMappings.put("V2000", ExceptionType.INVALID_AUTHORIZATION);
        s_sqlStateMappings.put("57V01", ExceptionType.NON_TRANSIENT_CONNECTION);
        s_sqlStateMappings.put("57V02", ExceptionType.NON_TRANSIENT_CONNECTION);
        s_sqlStateMappings.put("57V03", ExceptionType.NON_TRANSIENT_CONNECTION);
        s_sqlStateMappings.put("", ExceptionType.DEFAULT);
    }

    public static ExceptionType getExceptionTypeForSQLState(String string) {
        for (int i = string.length(); i >= 0; --i) {
            String string2 = string.substring(0, i);
            if (!s_sqlStateMappings.containsKey(string2)) continue;
            return s_sqlStateMappings.get(string2);
        }
        return ExceptionType.DEFAULT;
    }

    public ErrorException buildException() {
        ExceptionType exceptionType = ServerErrorData.getExceptionTypeForSQLState(this.getSQLState());
        ErrorException errorException = null;
        String string = this.getSQLState();
        int n = this.getErrorCode();
        String string2 = VDriver.s_msgSrc.loadMessage(Locale.getDefault(), 101, VMessageKey.SERVER_ERROR_DATA.name(), this.getErrorCode() + "", this.toString());
        switch (exceptionType) {
            case INVALID_AUTHORIZATION: {
                errorException = new InvalidAuthorizationException(string, string2, n);
                break;
            }
            case FEATURE_NOT_IMPLEMENTED: {
                errorException = new FeatureNotSupportedException(string, string2, n);
                break;
            }
            case DATA: {
                errorException = new DataException(string, string2, n);
                break;
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                errorException = new IntegrityConstraintViolationException(string, string2, n);
                break;
            }
            case NON_TRANSIENT: {
                errorException = new NonTransientException(string, string2, n);
                break;
            }
            case NON_TRANSIENT_CONNECTION: {
                errorException = new NonTransientConnectionException(string, string2, n);
                break;
            }
            case RECOVERABLE: {
                errorException = new RecoverableException(string, string2, n);
                break;
            }
            case SYNTAX_ERROR: {
                errorException = new SyntaxErrorException(string, string2, n);
                break;
            }
            case TRANSACTION_ROLLBACK: {
                if (n == 5156 || n == 5157) {
                    errorException = new TransientException(string, string2, n);
                    break;
                }
                errorException = new TransactionRollbackException(string, string2, n);
                break;
            }
            case TRANSIENT: {
                errorException = new TransientException(string, string2, n);
                break;
            }
            case TRANSIENT_CONNECTION: {
                errorException = new TransientConnectionException(string, string2, n);
                break;
            }
            default: {
                errorException = new ErrorException(string, string2, n);
            }
        }
        return errorException;
    }

    @Override
    public String getSQLState() {
        return this.m_mesgParts.get(SQLSTATE);
    }

    @Override
    public String getMessage() {
        if (this.m_mesgParts.get(HINT) == null) {
            return this.m_mesgParts.get(MESSAGE);
        }
        return this.m_mesgParts.get(MESSAGE) + "\n Hint: " + this.m_mesgParts.get(HINT);
    }

    @Override
    public String getErrorLevel() {
        return this.m_mesgParts.get(SEVERITY);
    }

    @Override
    public String getDetail() {
        return this.m_mesgParts.get(DETAIL);
    }

    @Override
    public String getHint() {
        return this.m_mesgParts.get(HINT);
    }

    @Override
    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public String getWhere() {
        return this.m_mesgParts.get(WHERE);
    }

    public String getFile() {
        return this.m_mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public String getRoutine() {
        return this.m_mesgParts.get(ROUTINE);
    }

    public String getInternalQuery() {
        return this.m_mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    @Override
    public int getErrorCode() {
        int n = this.getIntegerPart(ERROR_CODE);
        return n == 0 ? 100081 : n;
    }

    private int getIntegerPart(Character c) {
        String string = this.m_mesgParts.get(c);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public String toString() {
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_mesgParts.get(SEVERITY);
        if (string != null) {
            stringBuffer.append(string).append(": ");
        }
        if ((string = this.m_mesgParts.get(MESSAGE)) != null) {
            stringBuffer.append(string);
        }
        if ((string = this.m_mesgParts.get(DETAIL)) != null) {
            stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_DETAIL.toString(), string));
        }
        if (this.m_verbosity > 0) {
            string = this.m_mesgParts.get(HINT);
            if (string != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_HINT.toString(), string));
            }
            if ((string = this.m_mesgParts.get(POSITION)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_POSITION.toString(), string));
            }
            if ((string = this.m_mesgParts.get(WHERE)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_WHERE.toString(), string));
            }
        }
        if (this.m_verbosity > 2) {
            String string2;
            String string3 = this.m_mesgParts.get(INTERNAL_QUERY);
            if (string3 != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_INTERNAL_QUERY.toString(), string3));
            }
            if ((string2 = this.m_mesgParts.get(INTERNAL_POSITION)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_INTERNAL_POSITION.toString(), string2));
            }
            String string4 = this.m_mesgParts.get(FILE);
            String string5 = this.m_mesgParts.get(LINE);
            String string6 = this.m_mesgParts.get(ROUTINE);
            if (string4 != null || string5 != null || string6 != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_LOCATION.toString(), string4, string6, string5));
            }
            if ((string = this.m_mesgParts.get(SQLSTATE)) != null) {
                stringBuffer.append("\n  ").append(VDriver.s_msgSrc.loadMessage(locale, 101, VMessageKey.ERROR_DATA_SQLSTATE.toString(), string));
            }
        }
        return stringBuffer.toString();
    }

    static {
        ServerErrorData.buildSQLStateMappings();
        SEVERITY = new Character('S');
        MESSAGE = new Character('M');
        DETAIL = new Character('D');
        HINT = new Character('H');
        POSITION = new Character('P');
        WHERE = new Character('W');
        FILE = new Character('F');
        LINE = new Character('L');
        ROUTINE = new Character('R');
        SQLSTATE = new Character('C');
        INTERNAL_POSITION = new Character('p');
        INTERNAL_QUERY = new Character('q');
        ERROR_CODE = new Character('V');
    }
}

