/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.parameters.AbstractParameterStream;
import com.vertica.utilities.ReferenceEqualityWrapper;
import java.io.IOException;
import java.io.Reader;

public class CharacterParameterStream
extends AbstractParameterStream {
    private Reader m_reader = null;

    public CharacterParameterStream(Reader reader, long streamLength) {
        super(null, streamLength);
        this.m_reader = reader;
        this.m_streamWrapper = new ReferenceEqualityWrapper(this.m_reader);
    }

    @Deprecated
    public CharacterParameterStream(Reader reader, long streamLength, ParameterMetadata paramMeta, int type) {
        super(null, streamLength, paramMeta, type);
        this.m_reader = reader;
        this.m_streamWrapper = new ReferenceEqualityWrapper(this.m_reader);
    }

    @Override
    public void close() {
        super.close();
        if (!this.isClosed()) {
            try {
                this.m_reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_reader = null;
        }
    }

    @Override
    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        if (null == this.m_parameterMetadata) {
            throw new InputOutputException(1, JDBCMessageKey.NULL_PARAM_METADATA.name());
        }
        if (!this.m_valuesPushed) {
            this.m_valuesPushed = true;
        }
        int numCharsToFetch = this.getNumToFetch();
        char[] buffer = new char[numCharsToFetch];
        int numCharsRead = this.m_reader.read(buffer);
        this.m_numRead += (long)numCharsRead;
        DataWrapper data = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == numCharsRead) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = numCharsRead;
            if (numCharsRead < buffer.length && -1 != numCharsRead) {
                char[] temp = new char[numCharsRead];
                System.arraycopy(buffer, 0, temp, 0, numCharsRead);
                buffer = temp;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == numCharsRead) {
                buffer = new char[]{};
            }
        }
        try {
            if (12 == this.m_parameterMetadata.getTypeMetadata().getType()) {
                data.setVarChar(new String(buffer));
            } else {
                data.setLongVarChar(new String(buffer));
            }
        }
        catch (Exception e) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CORRUPT_UTF.name());
        }
        return new ParameterInputValue(this.m_parameterMetadata, data);
    }

    @Override
    protected boolean isClosed() {
        return null == this.m_reader;
    }
}

