/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import com.vertica.security.KeyStoreResolver;
import com.vertica.security.TLSMode;
import com.vertica.security.TrustStoreResolver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CustomKeystoreSSLSocketFactory
extends SSLSocketFactory {
    final SSLSocketFactory factory;

    public CustomKeystoreSSLSocketFactory(KeyStoreResolver keyStoreResolver, TrustStoreResolver trustStoreResolver, TLSMode tLSMode) throws IOException {
        try {
            TrustManager[] trustManagerArray;
            KeyStore keyStore = keyStoreResolver.getKeyStore();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStoreResolver.password.toCharArray());
            KeyStore keyStore2 = trustStoreResolver.getKeyStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore2);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            if (tLSMode.verifyCertificate()) {
                trustManagerArray = trustManagerFactory.getTrustManagers();
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new NonValidatingTM();
            }
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failed to create an SSLSocketFactory when setting up TLS: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.factory.createSocket(socket, string, n, bl);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.factory.createSocket(string, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.factory.createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.factory.createSocket(inetAddress, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.factory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    public static class NonValidatingTM
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

