/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.DescriptionResponseMessage;
import com.vertica.io.MessageType;
import com.vertica.io.VStream;
import com.vertica.io.VerticaDBTypeDesc;
import java.io.IOException;
import java.util.Arrays;

public class ParameterDescriptionResponseMessage
extends DescriptionResponseMessage {
    private int[] m_baseTypes;
    private int[] m_typmods;
    private boolean[] m_notnulls;
    private String[] m_typeNames;

    public ParameterDescriptionResponseMessage(VStream vStream) {
        super(vStream);
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        int n2 = this.m_vStream.ReceiveIntegerR(2);
        this.m_baseTypes = new int[n2];
        this.m_typmods = new int[n2];
        this.m_notnulls = new boolean[n2];
        this.m_typeNames = new String[n2];
        if (n2 > 0) {
            this.readTypePool();
        }
        for (int i = 0; i < n2; ++i) {
            VerticaDBTypeDesc verticaDBTypeDesc = this.readNextTypeInfo();
            this.m_typmods[i] = this.m_vStream.ReceiveIntegerR(4);
            this.m_notnulls[i] = this.m_vStream.ReceiveIntegerR(2) == 1;
            this.m_baseTypes[i] = verticaDBTypeDesc.getBaseTypeOid();
            this.m_typeNames[i] = verticaDBTypeDesc.getTypeName(this.m_typmods[i]);
        }
    }

    @Override
    public MessageType getType() {
        return MessageType.ParameterDescription;
    }

    @Override
    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[]{this.getType(), "OIDs: " + Arrays.toString(this.m_baseTypes), "TypeMods: " + Arrays.toString(this.m_typmods), "NotNulls: " + Arrays.toString(this.m_notnulls), "TypeName: " + Arrays.toString(this.m_typeNames)};
        return objectArray;
    }

    public int[] getParameterTypes() {
        return this.m_baseTypes;
    }

    public int[] getParameterTypmods() {
        return this.m_typmods;
    }

    public boolean[] getParameterNotNulls() {
        return this.m_notnulls;
    }

    public String[] getParameterTypeNames() {
        return this.m_typeNames;
    }
}

