/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.exceptions;

import com.vertica.support.IMessageSource;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import java.io.IOException;
import java.util.Locale;

public class InputOutputException
extends IOException {
    private static final long serialVersionUID = 8964924464604877510L;
    private ErrorException m_exception;
    private int m_errorCode = 0;

    public InputOutputException(int componentId, String msgKey) {
        this.m_exception = new ErrorException(DiagState.DIAG_GENERAL_ERROR, componentId, msgKey);
    }

    public InputOutputException(int componentId, String msgKey, String[] msgParams) {
        this.m_exception = new ErrorException(DiagState.DIAG_GENERAL_ERROR, componentId, msgKey, msgParams);
    }

    public InputOutputException(String message, int nativeErrorCode) {
        this.m_exception = new ErrorException(DiagState.DIAG_GENERAL_ERROR, message, nativeErrorCode);
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    @Override
    public String getLocalizedMessage() {
        return this.m_exception.getLocalizedMessage();
    }

    @Override
    public String getMessage() {
        return this.m_exception.getMessage();
    }

    public void loadMessage(IMessageSource messageSource, Locale locale) {
        if (this.m_exception.hasPreformattedMessage()) {
            return;
        }
        this.m_exception.loadMessage(messageSource, locale);
        this.m_errorCode = this.m_exception.getNativeErrorCode(null, null);
    }
}

