/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.IncorrectTypeException;

public class StringFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private final String m_value;
    private final boolean m_isCaseInsensitive;

    public StringFilter(MetadataSourceColumnTag columnTag, String value, boolean caseInsensitive) {
        this.m_columnTag = columnTag;
        this.m_value = null != value ? value.trim() : null;
        this.m_isCaseInsensitive = caseInsensitive;
    }

    public StringFilter(MetadataSourceColumnTag columnTag, String value) {
        this(columnTag, value, false);
    }

    @Override
    public boolean filter(DataWrapper data) {
        if (null == this.m_value) {
            return true;
        }
        if (data.isNull()) {
            return false;
        }
        try {
            switch (data.getType()) {
                case 1: {
                    return this.m_isCaseInsensitive ? this.m_value.equalsIgnoreCase(data.getChar()) : this.m_value.equals(data.getChar());
                }
                case 12: {
                    return this.m_isCaseInsensitive ? this.m_value.equalsIgnoreCase(data.getVarChar()) : this.m_value.equals(data.getVarChar());
                }
                case -1: {
                    return this.m_isCaseInsensitive ? this.m_value.equalsIgnoreCase(data.getLongVarChar()) : this.m_value.equals(data.getLongVarChar());
                }
                case 5: {
                    return this.m_value.equals(Integer.toString(data.getSmallInt()));
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

