/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.AttributeDataMap;
import com.vertica.dsi.core.utilities.PropertyLimitKeys;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.BadPropertyKeyException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.HashMap;
import java.util.Map;

public abstract class DSIStatement
implements IStatement {
    private final IConnection m_parentConnection;
    private final Map<Integer, PropertyLimitKeys> m_propertyLimitKeyMap = new HashMap<Integer, PropertyLimitKeys>();
    private final AttributeDataMap m_settings = new AttributeDataMap();
    private String m_cursorName = "";
    private IWarningListener m_warningListener = null;

    protected DSIStatement(IConnection parent) throws ErrorException {
        this.m_parentConnection = parent;
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        this.loadPropertyKeyToPropertyLimitKeyMapping();
    }

    @Override
    public String getCursorName() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return this.m_cursorName;
    }

    @Override
    public Variant getCustomProperty(int propKey) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey);
        return null;
    }

    @Override
    public int getCustomPropertyType(int propKey) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey);
        return 0;
    }

    @Override
    public ILogger getLog() {
        return this.getParentConnection().getConnectionLog();
    }

    @Override
    public IConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public AttributeDataMap getAllProperties() {
        return this.m_settings;
    }

    @Override
    public Variant getProperty(int propKey) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey);
        if (this.m_settings.isProperty(propKey)) {
            return this.m_settings.getProperty(propKey);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(propKey));
    }

    @Override
    public Variant getSimilarValue(int propKey, Variant propValue) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey, propValue);
        try {
            PropertyLimitKeys limitKeys = this.m_propertyLimitKeyMap.get(propKey);
            if (null == limitKeys) {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_PROP_LIMITKEY.name(), ExceptionType.DEFAULT);
            }
            int givenValue = (int)propValue.getLong();
            Integer maxLimitKey = limitKeys.getMaxLimitkey();
            Variant maxLimitAttrData = this.m_settings.getProperty(maxLimitKey);
            long maxLimitValue = givenValue;
            if (null != maxLimitAttrData) {
                maxLimitValue = maxLimitAttrData.getLong();
            }
            Integer minLimitKey = limitKeys.getMinLimitkey();
            Variant minLimitAttrData = this.m_settings.getProperty(minLimitKey);
            long minLimitValue = givenValue;
            if (null != minLimitAttrData) {
                minLimitValue = minLimitAttrData.getLong();
            }
            if (null != maxLimitAttrData && null != minLimitAttrData && maxLimitValue == minLimitValue) {
                return null;
            }
            if (null != maxLimitAttrData && maxLimitValue < (long)givenValue) {
                return maxLimitAttrData;
            }
            if (null != minLimitAttrData && minLimitValue > (long)givenValue) {
                return minLimitAttrData;
            }
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        return null;
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isCustomProperty(int propKey) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey);
        return false;
    }

    @Override
    public boolean isValueSupported(int propKey, Variant propValue) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey, propValue);
        PropertyLimitKeys limitKeys = this.m_propertyLimitKeyMap.get(propKey);
        if (null == limitKeys) {
            return true;
        }
        try {
            long givenValue = propValue.getLong();
            boolean hasMaxLimit = false;
            Integer maxLimitKey = limitKeys.getMaxLimitkey();
            Variant maxLimitAttrData = this.m_settings.getProperty(maxLimitKey);
            long maxLimitValue = givenValue;
            if (null != maxLimitAttrData) {
                maxLimitValue = maxLimitAttrData.getLong();
                hasMaxLimit = 0L != maxLimitValue;
            }
            Integer minLimitKey = limitKeys.getMinLimitkey();
            Variant minLimitAttrData = this.m_settings.getProperty(minLimitKey);
            long minLimitValue = givenValue;
            if (null != minLimitAttrData) {
                minLimitValue = minLimitAttrData.getLong();
            }
            if (hasMaxLimit && null != minLimitAttrData && maxLimitValue == minLimitValue) {
                return maxLimitValue == givenValue;
            }
            if (hasMaxLimit && maxLimitValue < givenValue) {
                return false;
            }
            if (null != minLimitAttrData && minLimitValue > givenValue) {
                return false;
            }
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        return true;
    }

    @Override
    public void notifyCursorNameChange(String cursorName) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), cursorName);
        this.m_cursorName = cursorName;
    }

    @Override
    public void registerWarningListener(IWarningListener listener) {
        LogUtilities.logFunctionEntrance(this.getLog(), listener);
        this.m_warningListener = listener;
    }

    @Override
    public void setCustomProperty(int propKey, Variant propValue) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey, propValue);
    }

    @Override
    public void setProperty(int propKey, Variant propValue) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), propKey, propValue);
        if (this.isValueSupported(propKey, propValue)) {
            this.m_settings.setProperty(propKey, propValue);
        } else {
            Variant similarVal = this.getSimilarValue(propKey, propValue);
            if (null == similarVal) {
                throw new BadAttrValException(2, DSIMessageKey.BAD_ATTR_VAL.name(), new String[]{String.valueOf(propKey), propValue.getString()});
            }
            this.m_settings.setProperty(propKey, similarVal);
            if (null != this.m_warningListener) {
                this.m_warningListener.postWarning(new Warning(WarningCode.OPTIONAL_VALUE_CHANGED, 2, DSIMessageKey.OPTIONAL_VAL_CHANGED.name(), new String[]{String.valueOf(propKey), propValue.getString()}));
            }
        }
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(100, 4, 0xFFFFFFFFL);
        this.m_settings.setProperty(101, 4, 0L);
        this.m_settings.setProperty(102, 4, 0L);
        this.m_settings.setProperty(103, 4, 0L);
        this.m_settings.setProperty(104, 4, 0L);
        this.m_settings.setProperty(105, 4, 0L);
        this.m_settings.setProperty(106, 4, Integer.MAX_VALUE);
        this.m_settings.setProperty(107, 4, 0L);
        this.m_settings.setProperty(1, 4, 0L);
        this.m_settings.setProperty(2, 4, 0L);
        this.m_settings.setProperty(3, 4, 0L);
        this.m_settings.setProperty(4, 5, (short)0);
        this.m_settings.setProperty(5, 4, 1L);
        this.m_settings.setProperty(6, 4, 0L);
        this.m_settings.setProperty(108, 4, 0L);
    }

    private void loadPropertyKeyToPropertyLimitKeyMapping() {
        PropertyLimitKeys maxLenLimits = new PropertyLimitKeys(100, 101);
        this.m_propertyLimitKeyMap.put(1, maxLenLimits);
        PropertyLimitKeys maxRowsLimits = new PropertyLimitKeys(102, 103);
        this.m_propertyLimitKeyMap.put(2, maxRowsLimits);
        PropertyLimitKeys timeoutLimits = new PropertyLimitKeys(104, 105);
        this.m_propertyLimitKeyMap.put(3, timeoutLimits);
        PropertyLimitKeys rowsetSizeLimits = new PropertyLimitKeys(106, 107);
        this.m_propertyLimitKeyMap.put(6, rowsetSizeLimits);
    }
}

