/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.thirdparty.com.google.common.cache;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.CompatibleWith;
import com.google.errorprone.annotations.DoNotMock;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.GwtCompatible;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheStats;
import com.tngtech.archunit.thirdparty.com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;

@DoNotMock(value="Use CacheBuilder.newBuilder().build()")
@ElementTypesAreNonnullByDefault
@GwtCompatible
public interface Cache<K, V> {
    @CheckForNull
    public V getIfPresent(@CompatibleWith(value="K") Object var1);

    public V get(K var1, Callable<? extends V> var2) throws ExecutionException;

    public ImmutableMap<K, V> getAllPresent(Iterable<? extends Object> var1);

    public void put(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void invalidate(@CompatibleWith(value="K") Object var1);

    public void invalidateAll(Iterable<? extends Object> var1);

    public void invalidateAll();

    @CheckReturnValue
    public long size();

    @CheckReturnValue
    public CacheStats stats();

    @CheckReturnValue
    public ConcurrentMap<K, V> asMap();

    public void cleanUp();
}

