/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.freeze;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ReflectionUtils;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.library.freeze.FreezingArchRule;
import com.tngtech.archunit.library.freeze.StoreInitializationFailedException;
import com.tngtech.archunit.library.freeze.StoreReadException;
import com.tngtech.archunit.library.freeze.StoreUpdateFailedException;
import com.tngtech.archunit.library.freeze.ViolationStore;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.VisibleForTesting;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ViolationStoreFactory {
    static final String FREEZE_STORE_PROPERTY_NAME = "freeze.store";

    ViolationStoreFactory() {
    }

    static ViolationStore create() {
        return ArchConfiguration.get().containsProperty(FREEZE_STORE_PROPERTY_NAME) ? ViolationStoreFactory.createInstance(ArchConfiguration.get().getProperty(FREEZE_STORE_PROPERTY_NAME)) : new TextFileBasedViolationStore();
    }

    @MayResolveTypesViaReflection(reason="This is not part of the import process")
    private static ViolationStore createInstance(String violationStoreClassName) {
        try {
            return (ViolationStore)ReflectionUtils.newInstanceOf(Class.forName(violationStoreClassName), new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Could not instantiate %s of configured type '%s=%s'", ViolationStore.class.getSimpleName(), FREEZE_STORE_PROPERTY_NAME, violationStoreClassName);
            throw new StoreInitializationFailedException(message, e);
        }
    }

    @VisibleForTesting
    static class TextFileBasedViolationStore
    implements ViolationStore {
        private static final Logger log = LoggerFactory.getLogger(TextFileBasedViolationStore.class);
        private static final Pattern UNESCAPED_LINE_BREAK_PATTERN = Pattern.compile("(?<!\\\\)\n");
        private static final String STORE_PATH_PROPERTY_NAME = "default.path";
        private static final String STORE_PATH_DEFAULT = "archunit_store";
        private static final String STORED_RULES_FILE_NAME = "stored.rules";
        private static final String ALLOW_STORE_CREATION_PROPERTY_NAME = "default.allowStoreCreation";
        private static final String ALLOW_STORE_CREATION_DEFAULT = "false";
        private static final String ALLOW_STORE_UPDATE_PROPERTY_NAME = "default.allowStoreUpdate";
        private static final String ALLOW_STORE_UPDATE_DEFAULT = "true";
        private boolean storeCreationAllowed;
        private boolean storeUpdateAllowed;
        private File storeFolder;
        private FileSyncedProperties storedRules;

        TextFileBasedViolationStore() {
        }

        @Override
        public void initialize(Properties properties) {
            this.storeCreationAllowed = Boolean.parseBoolean(properties.getProperty(ALLOW_STORE_CREATION_PROPERTY_NAME, ALLOW_STORE_CREATION_DEFAULT));
            this.storeUpdateAllowed = Boolean.parseBoolean(properties.getProperty(ALLOW_STORE_UPDATE_PROPERTY_NAME, ALLOW_STORE_UPDATE_DEFAULT));
            String path = properties.getProperty(STORE_PATH_PROPERTY_NAME, STORE_PATH_DEFAULT);
            this.storeFolder = new File(path);
            this.ensureExistence(this.storeFolder);
            File storedRulesFile = this.getStoredRulesFile();
            log.info("Initializing {} at {}", (Object)TextFileBasedViolationStore.class.getSimpleName(), (Object)storedRulesFile.getAbsolutePath());
            this.storedRules = new FileSyncedProperties(storedRulesFile);
            this.checkInitialization(this.storedRules.initializationSuccessful(), "Cannot create rule store at %s", storedRulesFile.getAbsolutePath());
        }

        private File getStoredRulesFile() {
            File rulesFile = new File(this.storeFolder, STORED_RULES_FILE_NAME);
            if (!rulesFile.exists() && !this.storeCreationAllowed) {
                throw new StoreInitializationFailedException(String.format("Creating new violation store is disabled (enable by configuration %s.%s=true)", ViolationStoreFactory.FREEZE_STORE_PROPERTY_NAME, ALLOW_STORE_CREATION_PROPERTY_NAME));
            }
            return rulesFile;
        }

        private void ensureExistence(File folder) {
            Preconditions.checkState(folder.exists() && folder.isDirectory() || folder.mkdirs(), "Cannot create folder %s", (Object)folder.getAbsolutePath());
        }

        private void checkInitialization(boolean initializationSuccessful, String message, Object ... args) {
            if (!initializationSuccessful) {
                throw new StoreInitializationFailedException(String.format(message, args));
            }
        }

        @Override
        public boolean contains(ArchRule rule) {
            return this.storedRules.containsKey(rule.getDescription());
        }

        @Override
        public void save(ArchRule rule, List<String> violations) {
            log.debug("Storing evaluated rule '{}' with {} violations: {}", new Object[]{rule.getDescription(), violations.size(), violations});
            if (!this.storeUpdateAllowed) {
                throw new StoreUpdateFailedException(String.format("Updating frozen violations is disabled (enable by configuration %s.%s=true)", ViolationStoreFactory.FREEZE_STORE_PROPERTY_NAME, ALLOW_STORE_UPDATE_PROPERTY_NAME));
            }
            String ruleFileName = this.ensureRuleFileName(rule);
            this.write(violations, new File(this.storeFolder, ruleFileName));
        }

        private void write(List<String> violations, File ruleDetails) {
            String updatedViolations = Joiner.on("\n").join(this.escape(violations));
            try {
                Files.write(ruleDetails.toPath(), updatedViolations.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new StoreUpdateFailedException(e);
            }
        }

        private List<String> escape(List<String> violations) {
            return this.replaceCharacter(violations, "\n", "\\\n");
        }

        private List<String> unescape(List<String> violations) {
            return this.replaceCharacter(violations, "\\\n", "\n");
        }

        private List<String> replaceCharacter(List<String> violations, String characterToReplace, String replacement) {
            return violations.stream().map(violation -> violation.replace(characterToReplace, replacement)).collect(Collectors.toList());
        }

        private String ensureRuleFileName(ArchRule rule) {
            String ruleFileName;
            if (this.storedRules.containsKey(rule.getDescription())) {
                ruleFileName = this.storedRules.getProperty(rule.getDescription());
                log.debug("Rule '{}' is already stored in file {}", (Object)rule.getDescription(), (Object)ruleFileName);
            } else {
                ruleFileName = this.createNewRuleId(rule).toString();
            }
            return ruleFileName;
        }

        private UUID createNewRuleId(ArchRule rule) {
            UUID ruleId = UUID.randomUUID();
            log.debug("Assigning new ID {} to rule '{}'", (Object)ruleId, (Object)rule.getDescription());
            this.storedRules.setProperty(rule.getDescription(), ruleId.toString());
            return ruleId;
        }

        @Override
        public List<String> getViolations(ArchRule rule) {
            String ruleDetailsFileName = this.storedRules.getProperty(rule.getDescription());
            Preconditions.checkArgument(ruleDetailsFileName != null, "No rule stored with description '%s'", (Object)rule.getDescription());
            List<String> result = this.readLines(ruleDetailsFileName);
            log.debug("Retrieved stored rule '{}' with {} violations: {}", new Object[]{rule.getDescription(), result.size(), result});
            return result;
        }

        private List<String> readLines(String ruleDetailsFileName) {
            String violationsText = this.readStoreFile(ruleDetailsFileName);
            List<String> lines = Splitter.on(UNESCAPED_LINE_BREAK_PATTERN).omitEmptyStrings().splitToList(violationsText);
            return this.unescape(lines);
        }

        private String readStoreFile(String fileName) {
            try {
                String result = new String(com.tngtech.archunit.thirdparty.com.google.common.io.Files.toByteArray(new File(this.storeFolder, fileName)), StandardCharsets.UTF_8);
                return FreezingArchRule.ensureUnixLineBreaks(result);
            }
            catch (IOException e) {
                throw new StoreReadException(e);
            }
        }

        private static class FileSyncedProperties {
            private final File propertiesFile;
            private final Properties loadedProperties;

            FileSyncedProperties(File file) {
                this.propertiesFile = this.initializePropertiesFile(file);
                this.loadedProperties = this.initializationSuccessful() ? this.loadRulesFrom(this.propertiesFile) : null;
            }

            boolean initializationSuccessful() {
                return this.propertiesFile != null;
            }

            private File initializePropertiesFile(File file) {
                boolean fileAvailable;
                try {
                    fileAvailable = file.exists() || file.createNewFile();
                }
                catch (IOException e) {
                    fileAvailable = false;
                }
                return fileAvailable ? file : null;
            }

            private Properties loadRulesFrom(File file) {
                Properties result = new Properties();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    result.load(inputStream);
                }
                catch (IOException e) {
                    throw new StoreInitializationFailedException(e);
                }
                return result;
            }

            boolean containsKey(String propertyName) {
                return this.loadedProperties.containsKey(FreezingArchRule.ensureUnixLineBreaks(propertyName));
            }

            String getProperty(String propertyName) {
                return this.loadedProperties.getProperty(FreezingArchRule.ensureUnixLineBreaks(propertyName));
            }

            void setProperty(String propertyName, String value) {
                this.loadedProperties.setProperty(FreezingArchRule.ensureUnixLineBreaks(propertyName), FreezingArchRule.ensureUnixLineBreaks(value));
                this.syncFileSystem();
            }

            private void syncFileSystem() {
                try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                    this.loadedProperties.store(outputStream, "");
                }
                catch (IOException e) {
                    throw new StoreUpdateFailedException(e);
                }
            }
        }
    }
}

