/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.library.dependencies.Cycle;
import com.tngtech.archunit.library.dependencies.CycleConfiguration;
import com.tngtech.archunit.library.dependencies.Edge;
import com.tngtech.archunit.library.dependencies.Graph;
import com.tngtech.archunit.library.dependencies.Slice;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ForwardingSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.MultimapBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SortedSetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SliceCycleArchCondition
extends ArchCondition<Slice> {
    private static final Logger log = LoggerFactory.getLogger(SliceCycleArchCondition.class);
    private final DescribedPredicate<Dependency> predicate;
    private ClassesToSlicesMapping classesToSlicesMapping;
    private Graph<Slice, Dependency> graph;
    private EventRecorder eventRecorder;

    SliceCycleArchCondition(DescribedPredicate<Dependency> predicate) {
        super("be free of cycles", new Object[0]);
        this.predicate = predicate;
    }

    @Override
    public void init(Collection<Slice> allSlices) {
        this.initializeResources(allSlices);
        this.graph.addNodes(allSlices);
    }

    private void initializeResources(Iterable<Slice> allSlices) {
        this.classesToSlicesMapping = new ClassesToSlicesMapping(allSlices);
        this.graph = new Graph();
        this.eventRecorder = new EventRecorder();
    }

    @Override
    public void check(Slice slice, ConditionEvents events) {
        this.graph.addEdges(SliceDependencies.of(slice, this.classesToSlicesMapping, this.predicate));
    }

    @Override
    public void finish(ConditionEvents events) {
        Graph.Cycles<Slice, Dependency> cycles = this.graph.findCycles();
        if (cycles.maxNumberOfCyclesReached()) {
            events.setInformationAboutNumberOfViolations(String.format(" >= %d times - the maximum number of cycles to detect has been reached; this limit can be adapted using the `archunit.properties` value `%s=xxx`", cycles.size(), "cycles.maxNumberToDetect"));
        }
        for (Cycle cycle : cycles) {
            this.eventRecorder.record(cycle, events);
        }
        this.releaseResources();
    }

    private void releaseResources() {
        this.classesToSlicesMapping = null;
        this.graph = null;
        this.eventRecorder = null;
    }

    private static class ClassesToSlicesMapping {
        private final Iterable<Slice> allSlices;
        private Map<JavaClass, Slice> mapping;

        private ClassesToSlicesMapping(Iterable<Slice> allSlices) {
            this.allSlices = allSlices;
        }

        public Slice get(JavaClass javaClass) {
            return this.mapping().get(javaClass);
        }

        private Map<JavaClass, Slice> mapping() {
            if (this.mapping != null) {
                return this.mapping;
            }
            ImmutableMap.Builder<JavaClass, Slice> result = ImmutableMap.builder();
            for (Slice slice : this.allSlices) {
                for (JavaClass javaClass : slice) {
                    result.put(javaClass, slice);
                }
            }
            this.mapping = result.build();
            return this.mapping;
        }

        public boolean containsKey(JavaClass javaClass) {
            return this.mapping().containsKey(javaClass);
        }
    }

    private static class EventRecorder {
        private static final String CYCLE_DETECTED_SECTION_INTRO = "Cycle detected: ";
        private static final String DEPENDENCY_DETAILS_INDENT = Strings.repeat(" ", 4);
        private final CycleConfiguration cycleConfiguration = new CycleConfiguration();

        private EventRecorder() {
            log.debug("Maximum number of dependencies to report per edge is set to {}; this limit can be adapted using the `archunit.properties` value `{}=xxx`", (Object)this.cycleConfiguration.getMaxNumberOfDependenciesToShowPerEdge(), (Object)"cycles.maxNumberOfDependenciesPerEdge");
        }

        void record(Cycle<Slice, Dependency> cycle, ConditionEvents events) {
            events.add(this.newEvent(cycle));
        }

        private ConditionEvent newEvent(Cycle<Slice, Dependency> cycle) {
            Map<String, Edge<Slice, Dependency>> descriptionsToEdges = this.sortEdgesByDescription(cycle);
            String description = this.createDescription(descriptionsToEdges.keySet(), CYCLE_DETECTED_SECTION_INTRO.length());
            String details = this.createDetails(descriptionsToEdges);
            return new SimpleConditionEvent(cycle, false, CYCLE_DETECTED_SECTION_INTRO + description + System.lineSeparator() + details);
        }

        private Map<String, Edge<Slice, Dependency>> sortEdgesByDescription(Cycle<Slice, Dependency> cycle) {
            LinkedList<Edge<Slice, Dependency>> edges = new LinkedList<Edge<Slice, Dependency>>(cycle.getEdges());
            Edge startEdge = cycle.getEdges().stream().min(Comparator.comparing(input -> ((Slice)input.getFrom()).getDescription())).get();
            while (!edges.getFirst().equals(startEdge)) {
                edges.addLast(edges.pollFirst());
            }
            LinkedHashMap<String, Edge<Slice, Dependency>> descriptionToEdge = new LinkedHashMap<String, Edge<Slice, Dependency>>();
            for (Edge edge : edges) {
                descriptionToEdge.put(((Slice)edge.getFrom()).getDescription(), edge);
            }
            return descriptionToEdge;
        }

        private String createDescription(Collection<String> edgeDescriptions, int indent) {
            ArrayList<String> descriptions = new ArrayList<String>(edgeDescriptions);
            descriptions.add((String)descriptions.get(0));
            return Joiner.on(" -> " + System.lineSeparator() + Strings.repeat(" ", indent)).join(descriptions);
        }

        private String createDetails(Map<String, Edge<Slice, Dependency>> descriptionsToEdges) {
            ArrayList<String> details = new ArrayList<String>();
            int sliceIndex = 0;
            for (Map.Entry<String, Edge<Slice, Dependency>> edgeWithDescription : descriptionsToEdges.entrySet()) {
                details.add(String.format("  %d. Dependencies of %s", ++sliceIndex, edgeWithDescription.getKey()));
                details.addAll(this.dependenciesDescription(edgeWithDescription.getValue()));
            }
            return Joiner.on(System.lineSeparator()).join(details);
        }

        private List<String> dependenciesDescription(Edge<Slice, Dependency> edge) {
            int maxDependencies = this.cycleConfiguration.getMaxNumberOfDependenciesToShowPerEdge();
            List<Dependency> allDependencies = edge.getAttachments();
            boolean tooManyDependenciesToDisplay = allDependencies.size() > maxDependencies;
            List<Dependency> dependenciesToDisplay = tooManyDependenciesToDisplay ? allDependencies.subList(0, maxDependencies) : allDependencies;
            List result = dependenciesToDisplay.stream().map(dependency -> DEPENDENCY_DETAILS_INDENT + "- " + dependency.getDescription()).collect(Collectors.toCollection(ArrayList::new));
            if (tooManyDependenciesToDisplay) {
                result.add(DEPENDENCY_DETAILS_INDENT + String.format("(%d further dependencies have been omitted...)", allDependencies.size() - dependenciesToDisplay.size()));
            }
            return result;
        }
    }

    private static class SliceDependencies
    extends ForwardingSet<Edge<Slice, Dependency>> {
        private final Set<Edge<Slice, Dependency>> edges;

        private SliceDependencies(Slice slice, ClassesToSlicesMapping classesToSlicesMapping, DescribedPredicate<Dependency> predicate) {
            SortedSetMultimap<Slice, Dependency> targetSlicesWithDependencies = this.targetsOf(slice, classesToSlicesMapping, predicate);
            ImmutableSet.Builder edgeBuilder = ImmutableSet.builder();
            for (Map.Entry<Slice, SortedSet<Dependency>> entry : this.sortedEntries(targetSlicesWithDependencies)) {
                edgeBuilder.add(new Edge(slice, entry.getKey(), (Collection)entry.getValue()));
            }
            this.edges = edgeBuilder.build();
        }

        private SortedSetMultimap<Slice, Dependency> targetsOf(Slice slice, ClassesToSlicesMapping classesToSlicesMapping, DescribedPredicate<Dependency> predicate) {
            SetMultimap result = MultimapBuilder.hashKeys().treeSetValues().build();
            slice.getDependenciesFromSelf().stream().filter(predicate).filter(dependency -> classesToSlicesMapping.containsKey(dependency.getTargetClass())).forEach(arg_0 -> SliceDependencies.lambda$targetsOf$1((SortedSetMultimap)result, classesToSlicesMapping, arg_0));
            return result;
        }

        private Set<Map.Entry<Slice, SortedSet<Dependency>>> sortedEntries(SortedSetMultimap<Slice, Dependency> multimap) {
            return multimap.asMap().entrySet();
        }

        @Override
        protected Set<Edge<Slice, Dependency>> delegate() {
            return this.edges;
        }

        static SliceDependencies of(Slice slice, ClassesToSlicesMapping classesToSlicesMapping, DescribedPredicate<Dependency> predicate) {
            return new SliceDependencies(slice, classesToSlicesMapping, predicate);
        }

        private static /* synthetic */ void lambda$targetsOf$1(SortedSetMultimap result, ClassesToSlicesMapping classesToSlicesMapping, Dependency dependency) {
            result.put(classesToSlicesMapping.get(dependency.getTargetClass()), dependency);
        }
    }
}

