/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Arrays;

class PrimitiveDataTypes {
    private PrimitiveDataTypes() {
    }

    static final class IntStack {
        private final int[] stack;
        private int pointer = 0;

        IntStack(int maxSize) {
            this.stack = new int[maxSize];
        }

        void push(int number) {
            this.stack[this.pointer++] = number;
        }

        int pop() {
            return this.stack[--this.pointer];
        }

        void reset() {
            this.pointer = 0;
        }

        int[] asArray() {
            return Arrays.copyOf(this.stack, this.pointer);
        }
    }

    static final class IntArray {
        private static final int UNINITIALIZED_MARKER = -1;
        private final int[] array;

        IntArray(int size) {
            this.array = new int[size];
            this.reset();
        }

        boolean isSet(int index) {
            return this.array[index] != -1;
        }

        int get(int index) {
            int result = this.array[index];
            Preconditions.checkState(result != -1, "Value at index %d is uninitialized", index);
            return result;
        }

        void set(int index, int value) {
            this.array[index] = value;
        }

        void reset() {
            Arrays.fill(this.array, -1);
        }
    }
}

