/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.dependencies;

import com.tngtech.archunit.library.dependencies.Cycle;
import com.tngtech.archunit.library.dependencies.Edge;
import com.tngtech.archunit.library.dependencies.JohnsonCycleFinder;
import com.tngtech.archunit.library.dependencies.PrimitiveGraph;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ArrayListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ForwardingCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class Graph<T, ATTACHMENT> {
    private final Map<T, Integer> nodes = new HashMap<T, Integer>();
    private final ListMultimap<Integer, Edge<T, ATTACHMENT>> outgoingEdges = ArrayListMultimap.create();

    Graph() {
    }

    void addNodes(Iterable<T> nodes) {
        for (T node : nodes) {
            if (this.nodes.containsKey(node)) continue;
            this.nodes.put(node, this.nodes.size());
        }
    }

    void addEdges(Iterable<Edge<T, ATTACHMENT>> outgoingEdges) {
        for (Edge<T, ATTACHMENT> edge : outgoingEdges) {
            Preconditions.checkArgument(this.nodes.containsKey(edge.getFrom()), "Node %s of edge %s is not part of the graph", edge.getFrom(), edge);
            Preconditions.checkArgument(this.nodes.containsKey(edge.getTo()), "Node %s of edge %s is not part of the graph", edge.getTo(), edge);
            this.outgoingEdges.put(this.nodes.get(edge.getFrom()), edge);
        }
    }

    Cycles<T, ATTACHMENT> findCycles() {
        ImmutableMap<Integer, Map<Integer, Edge<T, ATTACHMENT>>> edgesByTargetIndexByOriginIndex = this.indexEdgesByTargetIndexByOriginIndex(this.nodes, this.outgoingEdges);
        JohnsonCycleFinder johnsonCycleFinder = new JohnsonCycleFinder(this.createPrimitiveGraph());
        ImmutableList.Builder result = ImmutableList.builder();
        JohnsonCycleFinder.Result cycles = johnsonCycleFinder.findCycles();
        for (int[] rawCycle : cycles) {
            result.add(this.mapToCycle(edgesByTargetIndexByOriginIndex, rawCycle));
        }
        return new Cycles(result.build(), cycles.maxNumberOfCyclesReached());
    }

    private PrimitiveGraph createPrimitiveGraph() {
        int[][] edges = new int[this.nodes.size()][];
        for (Map.Entry<T, Integer> nodeToIndex : this.nodes.entrySet()) {
            Collection outgoing = this.outgoingEdges.get((Object)nodeToIndex.getValue());
            edges[nodeToIndex.getValue().intValue()] = new int[outgoing.size()];
            for (int j = 0; j < outgoing.size(); ++j) {
                edges[nodeToIndex.getValue().intValue()][j] = this.nodes.get(((Edge)outgoing.get(j)).getTo());
            }
        }
        return new PrimitiveGraph(edges);
    }

    private ImmutableMap<Integer, Map<Integer, Edge<T, ATTACHMENT>>> indexEdgesByTargetIndexByOriginIndex(Map<T, Integer> nodes, Multimap<Integer, Edge<T, ATTACHMENT>> outgoingEdges) {
        ImmutableMap.Builder edgeMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Integer, Collection<Edge<T, ATTACHMENT>>> originIndexToEdges : outgoingEdges.asMap().entrySet()) {
            ImmutableMap.Builder<Integer, Edge<T, ATTACHMENT>> targetIndexToEdges = ImmutableMap.builder();
            for (Edge<T, ATTACHMENT> edge : originIndexToEdges.getValue()) {
                targetIndexToEdges.put(nodes.get(edge.getTo()), edge);
            }
            edgeMapBuilder.put(originIndexToEdges.getKey(), targetIndexToEdges.build());
        }
        return edgeMapBuilder.build();
    }

    private Cycle<T, ATTACHMENT> mapToCycle(Map<Integer, Map<Integer, Edge<T, ATTACHMENT>>> edgesByTargetIndexByOriginIndex, int[] rawCycle) {
        ImmutableList.Builder edges = ImmutableList.builder();
        int originIndex = -1;
        for (int targetIndex : rawCycle) {
            if (originIndex >= 0) {
                edges.add(edgesByTargetIndexByOriginIndex.get(originIndex).get(targetIndex));
            }
            originIndex = targetIndex;
        }
        edges.add(edgesByTargetIndexByOriginIndex.get(originIndex).get(rawCycle[0]));
        return new Cycle(edges.build());
    }

    public String toString() {
        return "Graph{nodes=" + this.nodes + ", edges=" + this.outgoingEdges + '}';
    }

    static class Cycles<T, ATTACHMENT>
    extends ForwardingCollection<Cycle<T, ATTACHMENT>> {
        private final Collection<Cycle<T, ATTACHMENT>> cycles;
        private final boolean maxNumberOfCyclesReached;

        private Cycles(Collection<Cycle<T, ATTACHMENT>> cycles, boolean maxNumberOfCyclesReached) {
            this.cycles = cycles;
            this.maxNumberOfCyclesReached = maxNumberOfCyclesReached;
        }

        boolean maxNumberOfCyclesReached() {
            return this.maxNumberOfCyclesReached;
        }

        @Override
        protected Collection<Cycle<T, ATTACHMENT>> delegate() {
            return this.cycles;
        }
    }
}

