/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.DescribedPredicate;
import java.util.Optional;

@Internal
public final class PredicateAggregator<T> {
    private final AddMode<T> addMode;
    private final Optional<DescribedPredicate<T>> predicate;

    public PredicateAggregator() {
        this(AddMode.and(), Optional.empty());
    }

    private PredicateAggregator(AddMode<T> addMode, Optional<DescribedPredicate<T>> predicate) {
        this.addMode = addMode;
        this.predicate = predicate;
    }

    public PredicateAggregator<T> add(DescribedPredicate<? super T> other) {
        return new PredicateAggregator<T>(this.addMode, Optional.of(this.addMode.apply(this.predicate, other)));
    }

    public boolean isPresent() {
        return this.predicate.isPresent();
    }

    public DescribedPredicate<T> get() {
        return this.predicate.get();
    }

    public PredicateAggregator<T> thatANDs() {
        return new PredicateAggregator(AddMode.and(), this.predicate);
    }

    public PredicateAggregator<T> thatORs() {
        return new PredicateAggregator(AddMode.or(), this.predicate);
    }

    private static abstract class AddMode<T> {
        private AddMode() {
        }

        static <T> AddMode<T> and() {
            return new AddMode<T>(){

                @Override
                DescribedPredicate<T> apply(Optional<DescribedPredicate<T>> first, DescribedPredicate<? super T> other) {
                    DescribedPredicate second = other.forSubtype();
                    return first.isPresent() ? first.get().and(second) : second;
                }
            };
        }

        static <T> AddMode<T> or() {
            return new AddMode<T>(){

                @Override
                DescribedPredicate<T> apply(Optional<DescribedPredicate<T>> first, DescribedPredicate<? super T> other) {
                    DescribedPredicate second = other.forSubtype();
                    return first.isPresent() ? first.get().or(second) : second;
                }
            };
        }

        abstract DescribedPredicate<T> apply(Optional<DescribedPredicate<T>> var1, DescribedPredicate<? super T> var2);
    }
}

