/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.syntax;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.syntax.PredicateAggregator;
import com.tngtech.archunit.lang.syntax.elements.GivenConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenObjects;
import java.util.Optional;
import java.util.function.Function;

abstract class AbstractGivenObjects<T, SELF extends AbstractGivenObjects<T, SELF>>
implements GivenObjects<T>,
GivenConjunction<T> {
    final Factory<T, SELF> factory;
    final Priority priority;
    private final ClassesTransformer<T> classesTransformer;
    final Function<ArchCondition<T>, ArchCondition<T>> prepareCondition;
    private final PredicateAggregator<T> relevantObjectsPredicates;
    private final Optional<String> overriddenDescription;

    AbstractGivenObjects(Factory<T, SELF> factory, Priority priority, ClassesTransformer<T> classesTransformer, Function<ArchCondition<T>, ArchCondition<T>> prepareCondition, PredicateAggregator<T> relevantObjectsPredicates, Optional<String> overriddenDescription) {
        this.factory = factory;
        this.prepareCondition = prepareCondition;
        this.classesTransformer = classesTransformer;
        this.overriddenDescription = overriddenDescription;
        this.priority = priority;
        this.relevantObjectsPredicates = relevantObjectsPredicates;
    }

    SELF with(PredicateAggregator<T> newPredicate) {
        return this.factory.create(this.priority, this.classesTransformer, this.prepareCondition, newPredicate, this.overriddenDescription);
    }

    ClassesTransformer<T> finishedClassesTransformer() {
        ClassesTransformer<T> completeTransformation = this.relevantObjectsPredicates.isPresent() ? this.classesTransformer.that(this.relevantObjectsPredicates.get()) : this.classesTransformer;
        return this.overriddenDescription.isPresent() ? completeTransformation.as(this.overriddenDescription.get()) : completeTransformation;
    }

    public SELF that(DescribedPredicate<? super T> predicate) {
        return this.with(this.currentPredicate().add(predicate));
    }

    public SELF and(DescribedPredicate<? super T> predicate) {
        return this.with(this.currentPredicate().thatANDs().add(predicate));
    }

    public SELF or(DescribedPredicate<? super T> predicate) {
        return this.with(this.currentPredicate().thatORs().add(predicate));
    }

    SELF self() {
        return (SELF)this;
    }

    PredicateAggregator<T> currentPredicate() {
        return this.relevantObjectsPredicates;
    }

    static interface Factory<T, GIVEN extends AbstractGivenObjects<T, GIVEN>> {
        public GIVEN create(Priority var1, ClassesTransformer<T> var2, Function<ArchCondition<T>, ArchCondition<T>> var3, PredicateAggregator<T> var4, Optional<String> var5);
    }
}

