/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.PackageMatchers;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasParameterTypes;
import com.tngtech.archunit.core.domain.properties.HasReturnType;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.AllAccessesCondition;
import com.tngtech.archunit.lang.conditions.AllAttributesMatchCondition;
import com.tngtech.archunit.lang.conditions.AllDependenciesCondition;
import com.tngtech.archunit.lang.conditions.AndCondition;
import com.tngtech.archunit.lang.conditions.AnyDependencyCondition;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.conditions.ClassAccessesCondition;
import com.tngtech.archunit.lang.conditions.ClassAccessesFieldCondition;
import com.tngtech.archunit.lang.conditions.ClassOnlyAccessesCondition;
import com.tngtech.archunit.lang.conditions.CodeUnitOnlyCallsCondition;
import com.tngtech.archunit.lang.conditions.ContainAnyCondition;
import com.tngtech.archunit.lang.conditions.ContainsOnlyCondition;
import com.tngtech.archunit.lang.conditions.JavaAccessPackagePredicate;
import com.tngtech.archunit.lang.conditions.NeverCondition;
import com.tngtech.archunit.lang.conditions.OrCondition;
import com.tngtech.archunit.lang.conditions.TransitiveDependencyCondition;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ArchConditions {
    private static final ArchCondition<JavaClass> BE_TOP_LEVEL_CLASSES = ArchConditions.be(JavaClass.Predicates.TOP_LEVEL_CLASSES).describeEventsBy((__, satisfied) -> (satisfied ? "is a" : "is no") + " top level class");
    private static final ArchCondition<JavaClass> BE_NESTED_CLASSES = ArchConditions.be(JavaClass.Predicates.NESTED_CLASSES).describeEventsBy((__, satisfied) -> (satisfied ? "is a" : "is no") + " nested class");
    private static final ArchCondition<JavaClass> BE_MEMBER_CLASSES = ArchConditions.be(JavaClass.Predicates.MEMBER_CLASSES).describeEventsBy((__, satisfied) -> (satisfied ? "is a" : "is no") + " member class");
    private static final ArchCondition<JavaClass> BE_INNER_CLASSES = ArchConditions.be(JavaClass.Predicates.INNER_CLASSES).describeEventsBy((__, satisfied) -> (satisfied ? "is an" : "is no") + " inner class");
    private static final ArchCondition<JavaClass> BE_ANONYMOUS_CLASSES = ArchConditions.be(JavaClass.Predicates.ANONYMOUS_CLASSES).describeEventsBy((__, satisfied) -> (satisfied ? "is an" : "is no") + " anonymous class");
    private static final ArchCondition<JavaClass> BE_LOCAL_CLASSES = ArchConditions.be(JavaClass.Predicates.LOCAL_CLASSES).describeEventsBy((__, satisfied) -> (satisfied ? "is a" : "is no") + " local class");

    private ArchConditions() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> getField(Class<?> owner, String fieldName) {
        return ArchConditions.getField(owner.getName(), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> getField(String ownerName, String fieldName) {
        return ArchConditions.getFieldWhere(ArchConditions.ownerAndNameAre(ownerName, fieldName)).as("get field %s.%s", Formatters.ensureSimpleName(ownerName), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> getFieldWhere(DescribedPredicate<? super JavaFieldAccess> predicate) {
        return new ClassAccessesFieldCondition.ClassGetsFieldCondition(predicate).as("get field where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> setField(Class<?> owner, String fieldName) {
        return ArchConditions.setField(owner.getName(), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> setField(String ownerName, String fieldName) {
        return ArchConditions.setFieldWhere(ArchConditions.ownerAndNameAre(ownerName, fieldName)).as("set field %s.%s", Formatters.ensureSimpleName(ownerName), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> setFieldWhere(DescribedPredicate<? super JavaFieldAccess> predicate) {
        return new ClassAccessesFieldCondition.ClassSetsFieldCondition(predicate).as("set field where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessField(Class<?> owner, String fieldName) {
        return ArchConditions.accessField(owner.getName(), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessField(String ownerName, String fieldName) {
        return ArchConditions.accessFieldWhere(ArchConditions.ownerAndNameAre(ownerName, fieldName)).as("access field %s.%s", Formatters.ensureSimpleName(ownerName), fieldName);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessFieldWhere(DescribedPredicate<? super JavaFieldAccess> predicate) {
        return new ClassAccessesFieldCondition(predicate).as("access field where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyAccessFieldsThat(DescribedPredicate<? super JavaField> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate accessPredicate = getTarget.then(AccessTarget.FieldAccessTarget.Functions.RESOLVE_MEMBER).is(DescribedPredicate.optionalContains(predicate.forSubtype()).or(DescribedPredicate.optionalEmpty()));
        return new ClassOnlyAccessesCondition<JavaFieldAccess>(accessPredicate, JavaClass.Functions.GET_FIELD_ACCESSES_FROM_SELF).as("only access fields that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callMethod(Class<?> owner, String methodName, Class<?> ... parameterTypes) {
        return ArchConditions.callMethodWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(JavaClass.Predicates.type(owner))).and(JavaCall.Predicates.target(HasName.Predicates.name(methodName))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypes)))).as("call method %s", Formatters.formatMethodSimple(owner.getSimpleName(), methodName, Formatters.formatNamesOf(parameterTypes)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callMethod(String ownerName, String methodName, String ... parameterTypeNames) {
        return ArchConditions.callMethodWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(HasName.Predicates.name(ownerName))).and(JavaCall.Predicates.target(HasName.Predicates.name(methodName))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypeNames)))).as("call method %s", Formatters.formatMethodSimple(Formatters.ensureSimpleName(ownerName), methodName, Arrays.asList(parameterTypeNames)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callMethodWhere(DescribedPredicate<? super JavaMethodCall> predicate) {
        return new ClassAccessesCondition<JavaMethodCall>(predicate, JavaClass.Functions.GET_METHOD_CALLS_FROM_SELF).as("call method where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyCallMethodsThat(DescribedPredicate<? super JavaMethod> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate callPredicate = getTarget.then(AccessTarget.MethodCallTarget.Functions.RESOLVE_MEMBER).is(DescribedPredicate.optionalContains(predicate.forSubtype()).or(DescribedPredicate.optionalEmpty()));
        return new ClassOnlyAccessesCondition<JavaMethodCall>(callPredicate, JavaClass.Functions.GET_METHOD_CALLS_FROM_SELF).as("only call methods that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callConstructor(Class<?> owner, Class<?> ... parameterTypes) {
        return ArchConditions.callConstructorWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(JavaClass.Predicates.type(owner))).and(JavaCall.Predicates.target(HasName.Predicates.name("<init>"))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypes)))).as("call constructor %s", Formatters.formatMethodSimple(owner.getSimpleName(), "<init>", Formatters.formatNamesOf(parameterTypes)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callConstructor(String ownerName, String ... parameterTypeNames) {
        return ArchConditions.callConstructorWhere(JavaCall.Predicates.target(HasOwner.Predicates.With.owner(HasName.Predicates.name(ownerName))).and(JavaCall.Predicates.target(HasName.Predicates.name("<init>"))).and(JavaCall.Predicates.target(HasParameterTypes.Predicates.rawParameterTypes(parameterTypeNames)))).as("call constructor %s", Formatters.formatMethodSimple(Formatters.ensureSimpleName(ownerName), "<init>", Arrays.asList(parameterTypeNames)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callConstructorWhere(DescribedPredicate<? super JavaConstructorCall> predicate) {
        return new ClassAccessesCondition<JavaConstructorCall>(predicate, JavaClass.Functions.GET_CONSTRUCTOR_CALLS_FROM_SELF).as("call constructor where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyCallConstructorsThat(DescribedPredicate<? super JavaConstructor> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate callPredicate = getTarget.then(AccessTarget.ConstructorCallTarget.Functions.RESOLVE_MEMBER).is(DescribedPredicate.optionalContains(predicate.forSubtype()).or(DescribedPredicate.optionalEmpty()));
        return new ClassOnlyAccessesCondition<JavaConstructorCall>(callPredicate, JavaClass.Functions.GET_CONSTRUCTOR_CALLS_FROM_SELF).as("only call constructors that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> callCodeUnitWhere(DescribedPredicate<? super JavaCall<?>> predicate) {
        return new ClassAccessesCondition(predicate, JavaClass.Functions.GET_CODE_UNIT_CALLS_FROM_SELF).as("call code unit where " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyCallCodeUnitsThat(DescribedPredicate<? super JavaCodeUnit> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate callPredicate = getTarget.then(AccessTarget.CodeUnitAccessTarget.Functions.RESOLVE_MEMBER).is(DescribedPredicate.optionalContains(predicate.forSubtype()).or(DescribedPredicate.optionalEmpty()));
        return new ClassOnlyAccessesCondition(callPredicate, JavaClass.Functions.GET_CODE_UNIT_CALLS_FROM_SELF).as("only call code units that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyAccessMembersThat(DescribedPredicate<? super JavaMember> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate accessPredicate = getTarget.then(AccessTarget.Functions.RESOLVE_MEMBER).is(DescribedPredicate.optionalContains(predicate.forSubtype()).or(DescribedPredicate.optionalEmpty()));
        return new ClassOnlyAccessesCondition(accessPredicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF).as("only access members that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessTargetWhere(DescribedPredicate<? super JavaAccess<?>> predicate) {
        return new ClassAccessesCondition(predicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate accessPredicate = getTarget.then(HasOwner.Functions.Get.owner()).is(predicate);
        return new ClassAccessesCondition(accessPredicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF).as("access classes that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyAccessClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        ChainableFunction getTarget = JavaAccess.Functions.Get.target();
        DescribedPredicate<JavaAccess<?>> accessPredicate = getTarget.then(HasOwner.Functions.Get.owner()).is(predicate);
        return new AllAccessesCondition("only access classes that", accessPredicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> dependOnClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new AnyDependencyCondition("depend on classes that " + predicate.getDescription(), Dependency.Functions.GET_TARGET_CLASS.is(predicate), JavaClass.Functions.GET_DIRECT_DEPENDENCIES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> transitivelyDependOnClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new TransitiveDependencyCondition(predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyDependOnClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new AllDependenciesCondition("only depend on classes that " + predicate.getDescription(), Dependency.Functions.GET_TARGET_CLASS.is(predicate), JavaClass.Functions.GET_DIRECT_DEPENDENCIES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyBeAccessedByClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new AllAccessesCondition("only be accessed by classes that", JavaAccess.Functions.Get.origin().then(HasOwner.Functions.Get.owner()).is(predicate), JavaClass.Functions.GET_ACCESSES_TO_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessClassesThatResideIn(String packageIdentifier) {
        return ArchConditions.accessClassesThatResideInAnyPackage(packageIdentifier).as("access classes that reside in package '%s'", packageIdentifier);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> accessClassesThatResideInAnyPackage(String ... packageIdentifiers) {
        JavaAccessPackagePredicate predicate = JavaAccessPackagePredicate.forAccessTarget().matching(packageIdentifiers);
        return new ClassAccessesCondition(predicate, JavaClass.Functions.GET_ACCESSES_FROM_SELF).as("access classes that reside in " + predicate, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyBeAccessedByAnyPackage(String ... packageIdentifiers) {
        return new AllAccessesCondition("only be accessed by", JavaAccessPackagePredicate.forAccessOrigin().matching(packageIdentifiers), JavaClass.Functions.GET_ACCESSES_TO_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyHaveDependentsInAnyPackage(String ... packageIdentifiers) {
        String description = String.format("only have dependents in any package [%s]", Formatters.joinSingleQuoted(packageIdentifiers));
        return ArchConditions.onlyHaveDependentsWhere(Dependency.Predicates.dependencyOrigin(JavaClass.Functions.GET_PACKAGE_NAME.is(PackageMatchers.of(packageIdentifiers)))).as(description, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyHaveDependentClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.onlyHaveDependentsWhere(Dependency.Functions.GET_ORIGIN_CLASS.is(predicate)).as("only have dependent classes that " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> onlyHaveDependentsWhere(DescribedPredicate<? super Dependency> predicate) {
        String description = "only have dependents where " + predicate.getDescription();
        return new AllDependenciesCondition(description, predicate, JavaClass.Functions.GET_DIRECT_DEPENDENCIES_TO_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static AllDependenciesCondition onlyHaveDependenciesInAnyPackage(String ... packageIdentifiers) {
        String description = String.format("only have dependencies in any package [%s]", Formatters.joinSingleQuoted(packageIdentifiers));
        return ArchConditions.onlyHaveDependenciesWhere(Dependency.Predicates.dependencyTarget(JavaClass.Functions.GET_PACKAGE_NAME.is(PackageMatchers.of(packageIdentifiers)))).as(description, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static AllDependenciesCondition onlyHaveDependenciesWhere(DescribedPredicate<? super Dependency> predicate) {
        String description = "only have dependencies where " + predicate.getDescription();
        return new AllDependenciesCondition(description, predicate, JavaClass.Functions.GET_DIRECT_DEPENDENCIES_FROM_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> ArchCondition<T> and(ArchCondition<T> first, ArchCondition<T> second) {
        return new AndCondition<T>(first, second);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> ArchCondition<T> or(ArchCondition<T> first, ArchCondition<T> second) {
        return new OrCondition<T>(first, second);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> ArchCondition<T> never(ArchCondition<T> condition) {
        return new NeverCondition<T>(condition);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T> ArchCondition<T> not(ArchCondition<T> condition) {
        return ArchConditions.never(condition).as("not " + condition.getDescription(), new Object[0]);
    }

    static <T> ArchCondition<Collection<? extends T>> containAnyElementThat(ArchCondition<T> condition) {
        return new ContainAnyCondition<T>(condition);
    }

    static <T> ArchCondition<Collection<? extends T>> containOnlyElementsThat(ArchCondition<T> condition) {
        return new ContainsOnlyCondition<T>(condition);
    }

    private static DescribedPredicate<? super JavaFieldAccess> ownerAndNameAre(String ownerName, String fieldName) {
        return JavaFieldAccess.Predicates.target(HasOwner.Predicates.With.owner(HasName.Predicates.name(ownerName))).and(JavaFieldAccess.Predicates.target(HasName.Predicates.name(fieldName))).as(ownerName + "." + fieldName, new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> be(Class<?> clazz) {
        return ArchConditions.be(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBe(Class<?> clazz) {
        return ArchConditions.not(ArchConditions.be(clazz));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> be(String className) {
        return ArchConditions.be(ArchConditions.fullyQualifiedName(className).as(className, new Object[0])).describeEventsBy((__, satisfied) -> (satisfied ? "is " : "is not ") + className).forSubtype();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBe(String className) {
        return ArchConditions.not(ArchConditions.be(className));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveName(String name) {
        return ArchConditions.have(HasName.Predicates.name(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> notHaveName(String name) {
        return ArchConditions.not(ArchConditions.haveName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> haveFullName(String fullName) {
        return ArchConditions.have(HasName.AndFullName.Predicates.fullName(fullName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> notHaveFullName(String fullName) {
        return ArchConditions.not(ArchConditions.haveFullName(fullName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveFullyQualifiedName(String name) {
        return ArchConditions.have(ArchConditions.fullyQualifiedName(name));
    }

    @Internal
    public static DescribedPredicate<HasName> fullyQualifiedName(String name) {
        DescribedPredicate<HasName> predicate = HasName.Predicates.name(name);
        return predicate.as("fully qualified " + predicate.getDescription(), new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notHaveFullyQualifiedName(String name) {
        return ArchConditions.not(ArchConditions.haveFullyQualifiedName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleName(String name) {
        return ArchConditions.have(JavaClass.Predicates.simpleName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notHaveSimpleName(String name) {
        return ArchConditions.not(ArchConditions.haveSimpleName(name));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameStartingWith(String prefix) {
        return ArchConditions.have(JavaClass.Predicates.simpleNameStartingWith(prefix));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameNotStartingWith(String prefix) {
        return ArchConditions.not(ArchConditions.haveSimpleNameStartingWith(prefix)).as("have simple name not starting with '%s'", prefix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameContaining(String infix) {
        return ArchConditions.have(JavaClass.Predicates.simpleNameContaining(infix));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameNotContaining(String infix) {
        return ArchConditions.not(ArchConditions.haveSimpleNameContaining(infix)).as("have simple name not containing '%s'", infix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameEndingWith(String suffix) {
        return ArchConditions.have(JavaClass.Predicates.simpleNameEndingWith(suffix));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveSimpleNameNotEndingWith(String suffix) {
        return ArchConditions.not(ArchConditions.haveSimpleNameEndingWith(suffix)).as("have simple name not ending with '%s'", suffix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameMatching(String regex) {
        return ArchConditions.have(HasName.Predicates.nameMatching(regex));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameNotMatching(String regex) {
        return ArchConditions.not(ArchConditions.haveNameMatching(regex)).as("have name not matching '%s'", regex);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> haveFullNameMatching(String regex) {
        return ArchConditions.have(HasName.AndFullName.Predicates.fullNameMatching(regex));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_FULL_NAME extends HasName.AndFullName & HasDescription> ArchCondition<HAS_FULL_NAME> haveFullNameNotMatching(String regex) {
        return ArchConditions.not(ArchConditions.haveFullNameMatching(regex)).as("have full name not matching '%s'", regex);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameStartingWith(String prefix) {
        return ArchConditions.have(HasName.Predicates.nameStartingWith(prefix));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameNotStartingWith(String prefix) {
        return ArchConditions.not(ArchConditions.haveNameStartingWith(prefix)).forSubtype().as("have name not starting with '%s'", prefix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameContaining(String infix) {
        return ArchConditions.have(HasName.Predicates.nameContaining(infix));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameNotContaining(String infix) {
        return ArchConditions.not(ArchConditions.haveNameContaining(infix)).forSubtype().as("have name not containing '%s'", infix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameEndingWith(String suffix) {
        return ArchConditions.have(HasName.Predicates.nameEndingWith(suffix));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_NAME extends HasName & HasDescription> ArchCondition<HAS_NAME> haveNameNotEndingWith(String suffix) {
        return ArchConditions.not(ArchConditions.haveNameEndingWith(suffix)).forSubtype().as("have name not ending with '%s'", suffix);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideInAPackage(String packageIdentifier) {
        return ArchConditions.does(JavaClass.Predicates.resideInAPackage(packageIdentifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideInAnyPackage(String ... packageIdentifiers) {
        return ArchConditions.does(JavaClass.Predicates.resideInAnyPackage(packageIdentifiers));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideOutsideOfPackage(String packageIdentifier) {
        return ArchConditions.does(JavaClass.Predicates.resideOutsideOfPackage(packageIdentifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> resideOutsideOfPackages(String ... packageIdentifiers) {
        return ArchConditions.does(JavaClass.Predicates.resideOutsideOfPackages(packageIdentifiers));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> haveModifier(JavaModifier modifier) {
        return ArchConditions.have(HasModifiers.Predicates.modifier(modifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notHaveModifier(JavaModifier modifier) {
        return ArchConditions.not(ArchConditions.haveModifier(modifier));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> bePublic() {
        return ArchConditions.haveModifier(JavaModifier.PUBLIC).as("be public", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBePublic() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.PUBLIC)).as("not be public", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> beProtected() {
        return ArchConditions.haveModifier(JavaModifier.PROTECTED).as("be protected", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBeProtected() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.PROTECTED)).as("not be protected", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> bePackagePrivate() {
        return ArchConditions.not(ArchConditions.notBePackagePrivate()).as("be package private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBePackagePrivate() {
        return ArchConditions.haveModifier(JavaModifier.PUBLIC).or(ArchConditions.haveModifier(JavaModifier.PROTECTED)).or(ArchConditions.haveModifier(JavaModifier.PRIVATE)).as("not be package private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> bePrivate() {
        return ArchConditions.haveModifier(JavaModifier.PRIVATE).as("be private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBePrivate() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.PRIVATE)).as("not be private", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> beStatic() {
        return ArchConditions.haveModifier(JavaModifier.STATIC).as("be static", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBeStatic() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.STATIC).as("be static", new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> beFinal() {
        return ArchConditions.haveModifier(JavaModifier.FINAL).as("be final", new Object[0]);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_MODIFIERS extends HasModifiers & HasDescription> ArchCondition<HAS_MODIFIERS> notBeFinal() {
        return ArchConditions.not(ArchConditions.haveModifier(JavaModifier.FINAL).as("be final", new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveOnlyFinalFields() {
        return new HaveOnlyModifiersCondition<JavaField>("final fields", JavaModifier.FINAL, JavaClass.Functions.GET_FIELDS);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> haveOnlyPrivateConstructors() {
        return new HaveOnlyModifiersCondition<JavaConstructor>("private constructors", JavaModifier.PRIVATE, JavaClass.Functions.GET_CONSTRUCTORS);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beAnnotatedWith(Class<? extends Annotation> type) {
        return ArchConditions.be(CanBeAnnotated.Predicates.annotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeAnnotatedWith(Class<? extends Annotation> type) {
        return ArchConditions.not(ArchConditions.beAnnotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beAnnotatedWith(String typeName) {
        return ArchConditions.be(CanBeAnnotated.Predicates.annotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeAnnotatedWith(String typeName) {
        return ArchConditions.not(ArchConditions.beAnnotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return ArchConditions.be(CanBeAnnotated.Predicates.annotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return ArchConditions.not(ArchConditions.beAnnotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beMetaAnnotatedWith(Class<? extends Annotation> type) {
        return ArchConditions.be(CanBeAnnotated.Predicates.metaAnnotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeMetaAnnotatedWith(Class<? extends Annotation> type) {
        return ArchConditions.not(ArchConditions.beMetaAnnotatedWith(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beMetaAnnotatedWith(String typeName) {
        return ArchConditions.be(CanBeAnnotated.Predicates.metaAnnotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeMetaAnnotatedWith(String typeName) {
        return ArchConditions.not(ArchConditions.beMetaAnnotatedWith(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> beMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return ArchConditions.be(CanBeAnnotated.Predicates.metaAnnotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <HAS_ANNOTATIONS extends HasAnnotations<?> & HasDescription> ArchCondition<HAS_ANNOTATIONS> notBeMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return ArchConditions.not(ArchConditions.beMetaAnnotatedWith(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> implement(Class<?> interfaceType) {
        return ArchConditions.does(JavaClass.Predicates.implement(interfaceType));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notImplement(Class<?> interfaceType) {
        return ArchConditions.not(ArchConditions.implement(interfaceType));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> implement(String interfaceTypeName) {
        return ArchConditions.does(JavaClass.Predicates.implement(interfaceTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notImplement(String interfaceTypeName) {
        return ArchConditions.not(ArchConditions.implement(interfaceTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> implement(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.does(JavaClass.Predicates.implement(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notImplement(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.not(ArchConditions.implement(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableTo(Class<?> type) {
        return ArchConditions.be(JavaClass.Predicates.assignableTo(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableTo(Class<?> type) {
        return ArchConditions.not(ArchConditions.beAssignableTo(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableTo(String typeName) {
        return ArchConditions.be(JavaClass.Predicates.assignableTo(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableTo(String typeName) {
        return ArchConditions.not(ArchConditions.beAssignableTo(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableTo(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.be(JavaClass.Predicates.assignableTo(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableTo(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.not(ArchConditions.beAssignableTo(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableFrom(Class<?> type) {
        return ArchConditions.be(JavaClass.Predicates.assignableFrom(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableFrom(Class<?> type) {
        return ArchConditions.not(ArchConditions.beAssignableFrom(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableFrom(String typeName) {
        return ArchConditions.be(JavaClass.Predicates.assignableFrom(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableFrom(String typeName) {
        return ArchConditions.not(ArchConditions.beAssignableFrom(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAssignableFrom(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.be(JavaClass.Predicates.assignableFrom(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAssignableFrom(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.not(ArchConditions.beAssignableFrom(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beInterfaces() {
        return ArchConditions.be(JavaClass.Predicates.INTERFACES).describeEventsBy((__, satisfied) -> (satisfied ? "is an" : "is no") + " interface");
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeInterfaces() {
        return ArchConditions.not(ArchConditions.beInterfaces());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beEnums() {
        return ArchConditions.be(JavaClass.Predicates.ENUMS).describeEventsBy((__, satisfied) -> (satisfied ? "is an" : "is no") + " enum");
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeEnums() {
        return ArchConditions.not(ArchConditions.beEnums());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beRecords() {
        return ArchConditions.be(JavaClass.Predicates.RECORDS).describeEventsBy((__, satisfied) -> (satisfied ? "is a" : "is no") + " record");
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeRecords() {
        return ArchConditions.not(ArchConditions.beRecords());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beTopLevelClasses() {
        return BE_TOP_LEVEL_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeTopLevelClasses() {
        return ArchConditions.not(BE_TOP_LEVEL_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beNestedClasses() {
        return BE_NESTED_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeNestedClasses() {
        return ArchConditions.not(BE_NESTED_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beMemberClasses() {
        return BE_MEMBER_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeMemberClasses() {
        return ArchConditions.not(BE_MEMBER_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beInnerClasses() {
        return BE_INNER_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeInnerClasses() {
        return ArchConditions.not(BE_INNER_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAnonymousClasses() {
        return BE_ANONYMOUS_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeAnonymousClasses() {
        return ArchConditions.not(BE_ANONYMOUS_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beLocalClasses() {
        return BE_LOCAL_CLASSES;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> notBeLocalClasses() {
        return ArchConditions.not(BE_LOCAL_CLASSES);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends HasName.AndFullName> ArchCondition<T> containNumberOfElements(DescribedPredicate<? super Integer> predicate) {
        return new NumberOfElementsCondition(predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> beDeclaredIn(Class<?> owner) {
        return ArchConditions.be(JavaMember.Predicates.declaredIn(owner));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> notBeDeclaredIn(Class<?> owner) {
        return ArchConditions.not(ArchConditions.beDeclaredIn(owner));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> beDeclaredIn(String ownerTypeName) {
        return ArchConditions.be(JavaMember.Predicates.declaredIn(ownerTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> notBeDeclaredIn(String ownerTypeName) {
        return ArchConditions.not(ArchConditions.beDeclaredIn(ownerTypeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaMember> beDeclaredInClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        DescribedPredicate<JavaMember> declaredIn = JavaMember.Predicates.declaredIn(predicate.as("classes that " + predicate.getDescription(), new Object[0]));
        return ArchConditions.be(declaredIn);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaField> haveRawType(Class<?> type) {
        return ArchConditions.have(HasType.Predicates.rawType(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaField> haveRawType(String typeName) {
        return ArchConditions.have(HasType.Predicates.rawType(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaField> haveRawType(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.have(HasType.Predicates.rawType(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawParameterTypes(Class<?> ... parameterTypes) {
        return ArchConditions.have(HasParameterTypes.Predicates.rawParameterTypes(parameterTypes));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawParameterTypes(String ... parameterTypeNames) {
        return ArchConditions.have(HasParameterTypes.Predicates.rawParameterTypes(parameterTypeNames));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawParameterTypes(DescribedPredicate<? super List<JavaClass>> predicate) {
        return ArchConditions.have(HasParameterTypes.Predicates.rawParameterTypes(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawReturnType(Class<?> type) {
        return ArchConditions.have(HasReturnType.Predicates.rawReturnType(type));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawReturnType(String typeName) {
        return ArchConditions.have(HasReturnType.Predicates.rawReturnType(typeName));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> haveRawReturnType(DescribedPredicate<? super JavaClass> predicate) {
        return ArchConditions.have(HasReturnType.Predicates.rawReturnType(predicate));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> declareThrowableOfType(Class<? extends Throwable> type) {
        return ArchConditions.declareThrowableOfType(JavaClass.Predicates.equivalentTo(type).as(type.getName(), new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> declareThrowableOfType(String typeName) {
        return ArchConditions.declareThrowableOfType(HasName.Predicates.name(typeName).as(typeName, new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> declareThrowableOfType(DescribedPredicate<? super JavaClass> predicate) {
        DescribedPredicate<HasThrowsClause<?>> declareThrowableOfType = HasThrowsClause.Predicates.throwsClauseContainingType(predicate).as("declare throwable of type " + predicate.getDescription(), new Object[0]);
        return ArchConditions.does(declareThrowableOfType);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> onlyBeCalledByClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        ChainableFunction<JavaAccess<?>, JavaCodeUnit> origin = JavaAccess.Functions.Get.origin();
        ChainableFunction owner = HasOwner.Functions.Get.owner();
        return new CodeUnitOnlyCallsCondition("only be called by classes that " + predicate.getDescription(), origin.then(owner).is(predicate), JavaCodeUnit.Functions.Get.GET_CALLS_OF_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> onlyBeCalledByCodeUnitsThat(DescribedPredicate<? super JavaCodeUnit> predicate) {
        ChainableFunction<JavaAccess<?>, JavaCodeUnit> origin = JavaAccess.Functions.Get.origin();
        return new CodeUnitOnlyCallsCondition("only be called by code units that " + predicate.getDescription(), origin.is(predicate), JavaCodeUnit.Functions.Get.GET_CALLS_OF_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> onlyBeCalledByMethodsThat(DescribedPredicate<? super JavaMethod> predicate) {
        ChainableFunction<JavaAccess<?>, JavaCodeUnit> origin = JavaAccess.Functions.Get.origin();
        return new CodeUnitOnlyCallsCondition("only be called by methods that " + predicate.getDescription(), origin.is(ArchConditions.matching(JavaMethod.class, predicate)), JavaCodeUnit.Functions.Get.GET_CALLS_OF_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaCodeUnit> onlyBeCalledByConstructorsThat(DescribedPredicate<? super JavaConstructor> predicate) {
        ChainableFunction<JavaAccess<?>, JavaCodeUnit> origin = JavaAccess.Functions.Get.origin();
        return new CodeUnitOnlyCallsCondition("only be called by constructors that " + predicate.getDescription(), origin.is(ArchConditions.matching(JavaConstructor.class, predicate)), JavaCodeUnit.Functions.Get.GET_CALLS_OF_SELF);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends HasDescription & HasSourceCodeLocation> ArchCondition.ConditionByPredicate<T> have(DescribedPredicate<? super T> predicate) {
        return ((ArchCondition.ConditionByPredicate)ArchCondition.from(predicate.forSubtype()).as(ArchPredicates.have(predicate).getDescription(), new Object[0])).describeEventsBy((predicateDescription, satisfied) -> (satisfied ? "has " : "does not have ") + predicateDescription);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends HasDescription & HasSourceCodeLocation> ArchCondition.ConditionByPredicate<T> be(DescribedPredicate<? super T> predicate) {
        return ((ArchCondition.ConditionByPredicate)ArchCondition.from(predicate.forSubtype()).as(ArchPredicates.be(predicate).getDescription(), new Object[0])).describeEventsBy((predicateDescription, satisfied) -> (satisfied ? "is " : "is not ") + predicateDescription);
    }

    private static <U, T> DescribedPredicate<T> matching(Class<U> type, DescribedPredicate<? super U> predicate) {
        return DescribedPredicate.describe(String.format("matching %s %s", type.getSimpleName(), predicate.getDescription()), input -> type.isInstance(input) && predicate.test(input));
    }

    private static <T extends HasDescription & HasSourceCodeLocation> ArchCondition<T> does(DescribedPredicate<? super T> predicate) {
        return ArchCondition.from(predicate.forSubtype()).describeEventsBy((predicateDescription, satisfied) -> (satisfied ? "does " : "does not ") + predicateDescription);
    }

    private static class HaveOnlyModifiersCondition<T extends HasModifiers & HasDescription>
    extends AllAttributesMatchCondition<T, JavaClass> {
        private final Function<JavaClass, ? extends Collection<T>> getHasModifiers;

        HaveOnlyModifiersCondition(String description, JavaModifier modifier, Function<JavaClass, ? extends Collection<T>> getHasModifiers) {
            super("have only " + description, ArchConditions.be(HasModifiers.Predicates.modifier(modifier).as(modifier.toString().toLowerCase(), new Object[0])));
            this.getHasModifiers = getHasModifiers;
        }

        @Override
        Collection<T> relevantAttributes(JavaClass javaClass) {
            return this.getHasModifiers.apply(javaClass);
        }
    }

    private static class NumberOfElementsCondition<T extends HasName.AndFullName>
    extends ArchCondition<T> {
        private final DescribedPredicate<Integer> predicate;
        private final SortedSet<String> allElementNames = new TreeSet<String>();

        NumberOfElementsCondition(DescribedPredicate<? super Integer> predicate) {
            super("contain number of elements " + predicate.getDescription(), new Object[0]);
            this.predicate = predicate.forSubtype();
        }

        @Override
        public void check(T item, ConditionEvents events) {
            this.allElementNames.add(item.getFullName());
        }

        @Override
        public void finish(ConditionEvents events) {
            int size = this.allElementNames.size();
            boolean conditionSatisfied = this.predicate.test(size);
            String message = String.format("there is/are %d element(s) in %s", size, this.join(this.allElementNames));
            events.add(new SimpleConditionEvent(size, conditionSatisfied, message));
        }

        private String join(SortedSet<String> strings) {
            return "[" + Joiner.on(", ").join(strings) + "]";
        }
    }
}

